import React, { useEffect, useState } from 'react'
import Overlay from '../../utils/Overlay'
import Error from '../UI/Error';
import { axiosPrivate } from '../../api/PrivateRequestServices';
import { InfoBox } from '@react-google-maps/api';
import { DatePicker } from "antd";
import FormDaysArray from '../../utils/FormDaysArray';
import moment from 'moment';

import Success from '../UI/Success';
import { weekDayOff } from '../../configuration/GlobalConfig';

const AddNewPlan = ({onBackdropClick ,isSuccess ,setIsSuccess}) => {
    const { RangePicker } = DatePicker;
    const [apiError, setApiError] = useState({});
    const [apiSuccess,setApiSuccess]=useState("")
    const [showDropDown, setShowDropDown] = useState({
        driverList: false,
    })
    const [DayDate, setDayDate] = useState({})
    const [dates, setDates] = useState({});
    const [data, setData] = useState({
        shiftTypeData: [],
        leaveData: [],
        driverList: []
    })
    const [selectDay, setSelectDay] = useState([]);
    const [driverInfo, setDriverInfo] = useState({
        driverName: "",
        driverId: ""
    })
    const [planType, setPlanType] = useState({
        setShift: false,
        markLeave: false
    })
    const [shiftName, setShiftName] = useState([])
    const [shiftCode, setShiftCode] = useState([]);
    const [shiftInfo, setShiftInfo] = useState(
        [{
            key: Date.now(),

            shiftDate: "",
            shiftType: "",
            weeklyOff: "",
            shiftDateErr: "",
            shiftTypeErr: "",
            weeklyOffErr: "",
            leaveOff: "",
            leaveOffErr:""
        }])
    const shiftInfoArray = [];
    const addNewShift = () => {
        setShiftInfo([...shiftInfo,
        {
            key: Date.now(),

            shiftDate: "",
            shiftType: "",
            weeklyOff: "",
            shiftDateErr: "",
            shiftTypeErr: "",
            weeklyOffErr: "",
             leaveOff: "",
            leaveOffErr:""
        }
        ])

    }
    const [planTypeErr,setPlanTypeErr]=useState("")
    const [days, setDays] = useState([])
    const [leaveCode, setLeaveCode] = useState([]);
    const [leaveName, setLeaveName] = useState([]);
    const [showWeeklyOffDropDown, setShowWeeklyOffDropDown] = useState(false)
    const [showShiftTypeDropDown, setShowShiftTypeDropDown] = useState(false)
    const [showLeaveDropDown, setShowLeaveDropDown] = useState(false)
    const [driverErr, setDriverErr] = useState("");
    const openDropDown = (e) => {
        setShowDropDown({ [e.currentTarget.id]: !showDropDown[e.currentTarget.id] })
    }
    const handleShiftType = (shiftData, i) => {
        const data = [...shiftInfo];
        const shiftCodelable = [...shiftCode];
        const shiftNameLable = [...shiftName];
        shiftCodelable[i] = shiftData.shift_code;
        shiftNameLable[i] = shiftData.shift_name;
        data[i]['shiftTypeErr'] = "";
        data[i]['shiftType'] = shiftData.shift_code;

        setShiftCode(shiftCodelable);
        setShiftName(shiftNameLable)

    }
    const handleremove = (id, index) => {
        const filtered = shiftInfo.filter((obj) => {
            return obj.key !== id;
        });
        setShiftInfo(filtered);
    };
    const weeklyOff = (i, dates) => {



        setShowWeeklyOffDropDown({ [i]: !showWeeklyOffDropDown[i] })


    }
    const handlePlanType = (e) => {

        setPlanType({ [e.currentTarget.id]: true })
        setPlanTypeErr("");
        setDriverInfo({
            driverName: "",
            driverId:""
        })
        setShiftInfo([
            {
                key: Date.now(),

                shiftDate: "",
                shiftType: "",
                weeklyOff: "",
                shiftDateErr: "",
                shiftTypeErr: "",
                weeklyOffErr: "",
                leaveOff: "",
                leaveOffErr:""
            }
        ])


    }
    const handleWeeklyOff = (day, i) => {

        const days = [...selectDay];
        days[i] = day;
        setSelectDay(days);
        const data = [...shiftInfo];
        data[i]["weeklyOffErr"] = "";
        data[i]["weeklyOff"] = day;
        setShiftInfo(data);


    }
    const handleDriver = (driver) => {
        setDriverErr("");
        setDriverInfo({ driverName: driver.firstname, driverId: driver.user_id })
    }
   
    const validations = (fields) => {
        let isValid = true;
        if (planType.setShift == false && planType.markLeave == false)
        {
            setPlanTypeErr("Please select any plan type");
            
            }
        if (driverInfo.driverId == "")
        {
            setDriverErr("Please select driver")
            isValid = false;
            }
        const data = [...fields];
        for (var i = 0; i < data.length; i++) {
            if (data[i].shiftDate == "") {
                data[i].shiftDateErr = "Please select shift date"
                isValid = false;
            }
            if (data[i].shiftType == "" &&planType.setShift==true) {
                data[i].shiftTypeErr = "Please select shift type"
                isValid = false;
            }
            // if (data[i].weeklyOff == ""&&planType.setShift==true) {
            //     data[i].weeklyOffErr = "Please select weekly off"
            //     isValid = false;
            // }
           
            if (data[i].leaveOff == "" && planType.markLeave == true)
            {
              
                data[i].leaveOffErr = "Please select leave off"
                isValid = false;
                
                }
        }
        setShiftInfo(data);
        return isValid;
    }
    const addJobPlan = async () => {

        const isValid = validations(shiftInfo);

        const allData = [...shiftInfo];
       

        const request = [];
        
        if (isValid == true) {
            Object.entries(allData).map((finalData) => {
              
                return (
                   DayDate[finalData[0]]!=undefined&& DayDate[finalData[0]].map((datesArr) => {
                        let day = moment(datesArr).format('dddd');
                      
                        return (
                            request.push({
                                "user_id": driverInfo.driverId,
                                "status_code": planType.setShift?(finalData[1].weeklyOff == day ? weekDayOff : finalData[1].shiftType):(finalData[1].leaveOff),
                                "date": datesArr
                            })
                        )

                    })
                )
            })
            const addJobPlanUrl = process.env.REACT_APP_SAVE_ATTENDANCE;
            const addJobPlanResponse = await axiosPrivate.post(addJobPlanUrl, request);

            
             if (addJobPlanResponse?.data?.response?.errors!=undefined)
            {
               addJobPlanResponse?.data?.response?.errors.map((errorData) => {
                
                   setApiError((prev) => {
                       const errDate=errorData.date
                       return {
                           
                           ...prev,
                           [errDate]:errorData?.error?.message
                           
                       }
                   })
                   
                })
                
            }
          
            if (addJobPlanResponse?.data?.response?.data?.success.length > 0)
            {
                let finalRequestArr = addJobPlanResponse?.data?.response?.data?.success;
                finalRequestArr.map((slotObj,index) => {
                    // finalRequestArr[index]['slot']=slotObj['start_time'];
                    // finalRequestArr[index]['attendant_user_id']=slotObj['driver_user_id'];
                    // finalRequestArr[index]['puppy']=selectedSlotData?.puppy;
                    // finalRequestArr[index]['task_name']=taskInfo.name;
                    // finalRequestArr[index]['attendant']=attendantInfo?.name;
                });
                 setApiSuccess("Mapping updated successfully");
                setTimeout(() => {
                    onBackdropClick()
                     setIsSuccess(!isSuccess);
                // manageJobOnSuccessCallback(finalRequestArr,selectedSlotData?.shift);
                //closepopup();

                }, 3000);
               
            }
        }

       

    }
    const handleLeave = (leave, i) => {
        const data = [...shiftInfo];
        const leaveLableCode = [...leaveCode];
        const leaveNameLable = [...leaveName];
        leaveLableCode[i] = leave.leave_type_code;
        leaveNameLable[i] = leave.leave_type_name;
        data[i]['leaveOffErr']=""
        data[i]['leaveOff'] = leave.leave_type_code;

        setLeaveCode(leaveLableCode);
        setLeaveName(leaveNameLable)
    }
     const handleDate = (dateValues, dateData, index) => {
        setDates((prev) => {
            return {
                ...prev,
                [index]: dateData
            }
        })

        const fields = [...shiftInfo]
        // if (dates == undefined) {
        //     fields[i]['weeklyOffErr'] = "Please select date range first"
        //     setShiftInfo(fields)
        // }
        // else {
        fields[index]['shiftDateErr']=""
        fields[index]['shiftDate'] = dateData;
        const array = FormDaysArray(dateData[0], dateData[1]);

        setShiftInfo(fields)
        setDays(array.days);
        setDayDate((prev) => {
            return {
                ...prev,
                [index]: array.dates
            }
        })
        

     }
    const handleClose = () => {
        onBackdropClick();
    }
    useEffect(() => {
        const getData = async () => {
            const shiftTypeUrl = process.env.REACT_APP_GET_SHIFT_TYPE;
            const shiftTypeResponse = await axiosPrivate.get(shiftTypeUrl);

            const leaveDataUrl = process.env.REACT_APP_GET_LEAVE_SUB_CATEGORY_DATA;
            const leaveDataResponse = await axiosPrivate.get(leaveDataUrl);

            const driverListUrl = process.env.REACT_APP_GET_ATTENDANTS_LIST+"&limit=1000";
            const driverListResponse = await axiosPrivate.get(driverListUrl)

            if (shiftTypeResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        shiftTypeData: shiftTypeResponse?.data?.response?.data
                    }
                })
            }
            if (leaveDataResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        leaveData: leaveDataResponse?.data?.response?.data
                    }
                })
            }
            if (driverListResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        driverList: driverListResponse?.data?.response?.data?.user_info
                    }
                })
            }

        }
        getData();
    }, [])
   

    return (
        <Overlay onBackdropClick={onBackdropClick}>
            <div class="model_box_child addJobPlannerP" id="addJobPlannerP" style={{ width: "400px" }}>
                <div class="ap_heading">
                    <h4>Add new plan<span onClick={onBackdropClick} class="material-symbols-rounded black close_model">close</span></h4>
                </div>
                <div class="contentSection">
                    <section class="assignPromoP dForm">
                        <div class="fieldGroup">
                            <label class="smallLabel">Plan type</label>
                            <ul class="xType">
                                <li >
                                    <input type="radio" name="yTypeRadioY" checked={planType.setShift == true ? "checked" : ""} />
                                    <label onClick={handlePlanType} id="setShift" for="yTypeRadio1">Set shift</label>
                                </li>
                                <li>
                                    <input type="radio" name="yTypeRadioY" checked={planType.markLeave == true ? "checked" : ""} />
                                    <label onClick={handlePlanType} id="markLeave" for="yTypeRadio2">Mark leave</label>
                                </li>
                            </ul>
                        </div>
                         {planTypeErr != "" && <Error error={planTypeErr} />}
                        <div class="fieldGroup">
                            <label class="smallLabel">Driver/Supervisor</label>
                            <div class="multiOption" onClick={openDropDown} id="driverList">
                                <div class={showDropDown.driverList == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                    <p>{driverInfo.driverName != "" ? driverInfo.driverName : "Select driver/Supervisor"}<i class="material-symbols-rounded grey">expand_more</i></p>
                                    <div class="selectDrop customScroll hFix">
                                        <ul class="dropMenu">

                                            {data.driverList.length != 0 && data.driverList.map((driverData) => {
                                                return (
                                                    <li class={driverInfo.driverId == driverData.user_id ? "selected" : ""}>
                                                        <a href="javascript:void(0);" onClick={() => handleDriver(driverData)}>{driverData.firstname}
                                                            {driverInfo.driverId == driverData.user_id && <i class="material-symbols-rounded">done</i>}</a>
                                                    </li>
                                                )
                                            })}

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            {driverErr != "" && <Error error={driverErr} />}
                        </div>

                        <section>


                            {(planType.setShift == true || planType.markLeave == true) &&
                                <div class="addSlot dForm">
                                    {shiftInfo.map((info, index) => {
                                        return (
                                            <>
                                                <div class="fieldGroup">
                                                    <label class="smallLabel jcSpacebetween flexFlowInitial"><span>Select shift date range </span>
                                                        {
                                                            shiftInfo.length > 1 && index != 0 &&
                                                            <i onClick={() => {
                                                                handleremove(info.key, index);
                                                            }} class="material-symbols-rounded mt-m">delete</i>}</label>
                                                    <span class="absIcon">
                                                        {/* <input type="text" placeholder="DD/MM/YYYY" name="" />
                                                    <i class="material-symbols-rounded grey arrowBottom mt-m">calendar_month</i> */}


                                                        <RangePicker 
                                                        disabledDate={(current) => current.isBefore(moment().subtract(1,"day"))}
                                                        onChange={(dateValues, dateData) => handleDate(dateValues, dateData, index)} />


                                                    </span>
                                                </div>

                                                {info.shiftDateErr != "" && <Error error={info.shiftDateErr} />}
                                                <div class="lists">
                                                    <div class="xType alignBottom">
                                                        {planType.setShift == true &&
                                                            <div class="fieldGroup fullWidth">
                                                                <em class="smallLabel">Shift type </em>
                                                                <div class="multiOption" id="shiftTypes" onClick={() => {
                                                                    setShowShiftTypeDropDown({
                                                                        [index]: !showShiftTypeDropDown[index],
                                                                    });
                                                                }}>

                                                                    <div class={showShiftTypeDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                        <p>{shiftName[index] ? shiftName[index] : "Select shift"}<i class="material-symbols-rounded grey">expand_more</i>
                                                                        </p>
                                                                        <div class="selectDrop customScroll hFix">

                                                                            <ul class="dropMenu">

                                                                                {data.shiftTypeData.length != 0 &&
                                                                                    data.shiftTypeData.map((shiftData, i) => {

                                                                                        return (
                                                                                            <li class={shiftName[index] == shiftData.shift_name ? "selected" : ""}>
                                                                                                <a onClick={() => handleShiftType(shiftData, index)} href="javascript:void(0);">
                                                                                                    {shiftData.shift_name}
                                                                                                </a>
                                                                                            </li>
                                                                                        )
                                                                                    })
                                                                                }

                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                {info.shiftTypeErr != "" && <Error error={info.shiftTypeErr} />}
                                                            </div>}

                                                        {planType.setShift == true &&
                                                            <div class="fieldGroup fullWidth">
                                                                <em class="smallLabel">Weekly off</em>
                                                                <div class="multiOption" onClick={() => weeklyOff(index, dates[index])}>
                                                                    <div class={showWeeklyOffDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                        <p>{selectDay[index] ? selectDay[index] : "Select leave"}<i class="material-symbols-rounded grey">expand_more</i>
                                                                        </p>
                                                                        <div class="selectDrop customScroll hFix">
                                                                            <ul class="dropMenu pText">

                                                                                {days&&days.map((day) => {

                                                                                    return (
                                                                                        <li class={selectDay[index] == day ? "selected cPointer" : "cPointer"}>
                                                                                            <p onClick={() => handleWeeklyOff(day, index)}>{day}</p>
                                                                                            {/* <span>5/5 left</span> */}
                                                                                        </li>

                                                                                    )
                                                                                })}


                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>

                                                                {info.weeklyOffErr != "" && <Error error={info.weeklyOffErr} />}
                                                            </div>}

                                                        {planType.markLeave == true &&
                                                            <div class="fieldGroup fullWidth">
                                                                <em class="smallLabel">Leave off</em>
                                                                <div class="multiOption" onClick={() => {
                                                                    setShowLeaveDropDown({
                                                                        [index]: !showLeaveDropDown[index],
                                                                    });
                                                                }}>
                                                                    <div class={showLeaveDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                        <p>{leaveName[index] ? leaveName[index] : "Select leave"}<i class="material-symbols-rounded grey">expand_more</i>
                                                                        </p>
                                                                        <div class="selectDrop customScroll hFix">
                                                                            <ul class="dropMenu pText">

                                                                                {data.leaveData.length != 0 && data.leaveData.map((leave) => {
                                                                                    return (
                                                                                        <li class="cPointer">
                                                                                            <p onClick={() => handleLeave(leave, index)}>{leave.leave_type_name}</p>
                                                                                            {/* <span>5/5 left</span> */}
                                                                                        </li>
                                                                                    )
                                                                                })}
                                                                                {/* <li class="cPointer disable">
                                                                            <p>Comp-off</p>
                                                                            <span>0/5 left</span>
                                                                        </li> */}

                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                {info.leaveOffErr != "" && <Error error={info.leaveOffErr} />}
                                                            </div>}


                                                    </div>
                                                </div>
                                            </>
                                        )
                                    })}

                                    <div class="link">
                                        <a onClick={addNewShift} href="javascript:void(0);">+  Add new shift</a>
                                    </div>
                                </div>}
                        </section>
                    </section>
                   

                    {
                        
                       Object.entries(apiError).map((errorData) => {
                          
                            return (
                                <>
                                    {errorData[0] != undefined && <Error error={errorData[0] + ": " + errorData[1]} />}
                                    <br />
                                    </>
                            )
                        })
                    }
                    {
                        apiSuccess && <Success success={ apiSuccess} />
                    }
                    <div class="actionButtons mt-24">
                        <span>
                            <a onClick={addJobPlan} class="btn prim">Add job plan</a>
                        </span>
                    </div>
                </div>
            </div>


        </Overlay>
    )
}


export default AddNewPlan