import React, { useEffect, useState } from 'react'
import Overlay from '../../utils/Overlay'
import Error from '../UI/Error';
import { axiosPrivate } from '../../api/PrivateRequestServices';
import { InfoBox } from '@react-google-maps/api';
import { DatePicker } from "antd";
import FormDaysArray from '../../utils/FormDaysArray';
import moment from 'moment';
import { weekDayOff } from '../../configuration/GlobalConfig';

import Success from '../UI/Success';
import { isValidDateValue } from '@testing-library/user-event/dist/utils';

const EditAttendance = ({ onBackdropClick, attendanceInfo, setAttendanceInfo, isSuccess, setIsSuccess, editAttendanceOnSuccessCallback }) => {
    const calendarData = attendanceInfo.info.calendar_data[moment(attendanceInfo.date).format("YYYY-MM-DD")];




    const [apiError, setApiError] = useState({});
    const [apiSuccess, setApiSuccess] = useState("")
    const [showDropDown, setShowDropDown] = useState({
        driverList: false,
    })
    const [error, setError] = useState("");
    const [DayDate, setDayDate] = useState({})
    const [dates, setDates] = useState({});
    const [data, setData] = useState({
        shiftTypeData: [],
        leaveData: [],
        driverList: []
    })
    const [selectDay, setSelectDay] = useState(calendarData.attendance_status != null && calendarData.attendance_status.toLowerCase() == weekDayOff.toLowerCase() && [moment(attendanceInfo.date).format('dddd')]);
    const [driverInfo, setDriverInfo] = useState({
        driverName: "",
        driverId: ""
    })
    const [planType, setPlanType] = useState({
        setShift: false,
        markLeave: false,
        isShift: calendarData.is_shift
    })
    const [shiftName, setShiftName] = useState([calendarData.shift_label]);
    const [shiftCode, setShiftCode] = useState([]);
    const [shiftInfo, setShiftInfo] = useState(
        [{
            key: Date.now(),
            shiftDate: moment(attendanceInfo.date).format('YYYY-MM-DD'),
            shiftType: calendarData.attendance_status,
            weeklyOff: "",
            shiftDateErr: "",
            shiftTypeErr: "",
            weeklyOffErr: "",
            leaveOff: calendarData.attendance_status,
            leaveOffErr: "",
            shiftClass:calendarData.color_code_class
        }])
    const shiftInfoArray = [];
    const addNewShift = () => {
        setShiftInfo([...shiftInfo,
        {
            key: Date.now(),
            shiftDate: "",
            shiftType: "",
            weeklyOff: "",
            shiftDateErr: "",
            shiftTypeErr: "",
            weeklyOffErr: "",
            leaveOff: "",
            leaveOffErr: ""
        }
        ])

    }
    const [planTypeErr, setPlanTypeErr] = useState("")
    const [days, setDays] = useState([])
    const [leaveCode, setLeaveCode] = useState([]);
    const [leaveName, setLeaveName] = useState([]);
    const [showWeeklyOffDropDown, setShowWeeklyOffDropDown] = useState(false)
    const [showShiftTypeDropDown, setShowShiftTypeDropDown] = useState(false)
    const [showLeaveDropDown, setShowLeaveDropDown] = useState(false)
    const [driverErr, setDriverErr] = useState("");
    const openDropDown = (e) => {
        setShowDropDown({ [e.currentTarget.id]: !showDropDown[e.currentTarget.id] })
    }
    const handleShiftType = (shiftData, i) => {
        const data = [...shiftInfo];
        const shiftCodelable = [...shiftCode];
        const shiftNameLable = [...shiftName];
        shiftCodelable[i] = shiftData != "Select shift type" ? shiftData.shift_code : "";
        shiftNameLable[i] = shiftData != "Select shift type" ? shiftData.shift_name : "Select shift type";
        data[i]['shiftTypeErr'] = "";
        data[i]['shiftType'] = shiftData != "Select shift type" ? shiftData.shift_code : "";
        data[i]["shiftClass"] = shiftData != "Select shift type" ? shiftData.color_code_class : "";
        setShiftInfo(data);
        setShiftCode(shiftCodelable);
        setShiftName(shiftNameLable);
        setSelectDay({ [0]: "Select weekly off" });

    }
    const handleremove = (id, index) => {
        const filtered = shiftInfo.filter((obj) => {
            return obj.key !== id;
        });
        setShiftInfo(filtered);
    };
    const weeklyOff = (i, dates) => {


        setError("")
        setShowWeeklyOffDropDown({ [i]: !showWeeklyOffDropDown[i] })


    }
    const handlePlanType = (e) => {
        let isShift = planType.isShift;
        if (e.currentTarget.id === 'setShift') {
            isShift = '1';
        } else {
            isShift = '0';
        }
        setPlanType({ [e.currentTarget.id]: true, isShift: isShift });
        setPlanTypeErr("");
        setDriverInfo({
            driverName: "",
            driverId: ""
        })
        setShiftInfo([
            {
                key: Date.now(),
                shiftDate: moment(attendanceInfo.date).format('YYYY-MM-DD'),
                shiftType: calendarData.attendance_status,
                shiftClass: calendarData.color_code_class,
                weeklyOff: "",
                shiftDateErr: "",
                shiftTypeErr: "",
                weeklyOffErr: "",
                leaveOff: "",
                leaveOffErr: ""
            }
        ])


    }
    const handleWeeklyOff = (day, i) => {
        days[i] = day;
        setSelectDay(days);
        const data = [...shiftInfo];
        data[i]["weeklyOffErr"] = "";
        data[i]["weeklyOff"] = day != "Select weekly off" ? day : "";
        data[i]["shiftClass"] = day != "Select weekly off" ? "wo" : "";
        setShiftInfo(data);



    }
    const handleDriver = (driver) => {
        setDriverErr("");
        setDriverInfo({ driverName: driver.firstname, driverId: driver.user_id })
    }

    const validations = (fields) => {
        let isValid = true;
        const data = [...fields];
        for (var i = 0; i < data.length; i++) {

            if ((data[i].weeklyOff == "" || data[i].weeklyOff == "Select weekly off") && (data[i].shiftType == "")) {
                setError("Either select shift type or weekly off");
                isValid = false;
            }

        }
        setShiftInfo(data);
        return isValid;
    }

    const addJobPlan = async () => {

        const allData = [...shiftInfo];

        const isValid = validations(allData);
        const request = [];

        if (isValid == true) {

            if ((planType.setShift == true || calendarData.is_shift == 1 || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() === weekDayOff.toLowerCase())) && (planType.markLeave == false || planType.markLeave == undefined)) {

                request.push({
                    "user_id": attendanceInfo.info.user_id,
                    "status_code": selectDay[0] == moment(attendanceInfo.date).format('dddd') ? weekDayOff : (shiftCode[0] != undefined ? shiftCode[0] : calendarData.attendance_status),
                    "date": moment(attendanceInfo.date).format('YYYY-MM-DD')
                })
            }
            else if ((planType.markLeave == true || calendarData.is_shift == 0 || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() !== weekDayOff.toLowerCase())) && (planType.setShift == false || planType.setShift == undefined)) {
                request.push({
                    "user_id": attendanceInfo.info.user_id,
                    "status_code": leaveCode[0] ? leaveCode[0] : calendarData.attendance_status,
                    "date": moment(attendanceInfo.date).format('YYYY-MM-DD')
                })

            }



            const addJobPlanUrl = process.env.REACT_APP_SAVE_ATTENDANCE;
            const addJobPlanResponse = await axiosPrivate.post(addJobPlanUrl, request);


            if (addJobPlanResponse?.data?.response?.errors != undefined) {
                addJobPlanResponse?.data?.response?.errors.map((errorData) => {

                    setApiError((prev) => {
                        const errDate = errorData.date
                        return {

                            ...prev,
                            [errDate]: errorData?.error?.message

                        }
                    })

                })

            }

            if (addJobPlanResponse?.data?.response?.data?.success.length > 0) {
                let finalRequestArr = addJobPlanResponse?.data?.response?.data?.success;
                finalRequestArr.map((slotObj, index) => {
                });

                let editedData = {};
                editedData['user_id'] = request[0]['user_id'];
                editedData['date'] = request[0]['date'];
                editedData['attendance_status'] = request[0]['status_code']; 
                editedData['color_code_class'] = request[0]['status_code'].toLowerCase() == weekDayOff.toLowerCase() ? 'wo' : shiftInfo[0]['shiftClass'];
                editedData['is_shift'] = request[0]['status_code'].toLowerCase() == weekDayOff.toLowerCase() ? '0' : planType.isShift;
                editedData['shift_label'] = editedData['is_shift'] === '1' ? shiftName[0] : "";   
                setApiSuccess("Mapping updated successfully");
                setTimeout(() => {
                    editAttendanceOnSuccessCallback(editedData);
                }, 3000);

            }

        }


    }




    const handleLeave = (leave, i) => {
        const data = [...shiftInfo];
        const leaveLableCode = [...leaveCode];
        const leaveNameLable = [...leaveName];
        leaveLableCode[i] = leave.leave_type_code;
        leaveNameLable[i] = leave.leave_type_name;
        data[i]['leaveOffErr'] = ""
        data[i]['leaveOff'] = leave.leave_type_code;
        data[i]["shiftClass"] = leave.color_code_class;
        setShiftInfo(data);

        setLeaveCode(leaveLableCode);
        setLeaveName(leaveNameLable)
    }
    const handleDate = (dateValues, dateData, index) => {
        setDates((prev) => {
            return {
                ...prev,
                [index]: dateData
            }
        })

        const fields = [...shiftInfo]
        // if (dates == undefined) {
        //     fields[i]['weeklyOffErr'] = "Please select date range first"
        //     setShiftInfo(fields)
        // }
        // else {
        fields[index]['shiftDateErr'] = ""
        fields[index]['shiftDate'] = dateData;

        const array = FormDaysArray(dateData[0], dateData[1]);

        setShiftInfo(fields)
        setDays(array.days);
        setDayDate((prev) => {
            return {
                ...prev,
                [index]: array.dates
            }
        })


    }
    const handleClose = () => {
        onBackdropClick();
    }
    useEffect(() => {
        const getData = async () => {
            const shiftTypeUrl = process.env.REACT_APP_GET_SHIFT_TYPE;
            const shiftTypeResponse = await axiosPrivate.get(shiftTypeUrl);

            const leaveDataUrl = process.env.REACT_APP_GET_LEAVE_SUB_CATEGORY_DATA;
            const leaveDataResponse = await axiosPrivate.get(leaveDataUrl);

            const driverListUrl = process.env.REACT_APP_GET_ATTENDANTS_LIST;
            const driverListResponse = await axiosPrivate.get(driverListUrl)

            if (shiftTypeResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        shiftTypeData: shiftTypeResponse?.data?.response?.data
                    }
                })
            }
            if (leaveDataResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        leaveData: leaveDataResponse?.data?.response?.data
                    }
                })
            }
            if (driverListResponse?.status == 200) {

                setData((prev) => {
                    return {
                        ...prev,
                        driverList: driverListResponse?.data?.response?.data?.user_info
                    }
                })
            }


        }
        getData();
    }, [])


    return (
        calendarData.attendance_status != null &&
        <Overlay onBackdropClick={onBackdropClick}>
            <div class="model_box_child addJobPlannerP" id="addJobPlannerP" style={{ width: "400px" }}>
                <div class="ap_heading">
                    <h4>Edit plan<span onClick={onBackdropClick} class="material-symbols-rounded black close_model">close</span></h4>
                </div>
                <div class="contentSection">
                    <section class="assignPromoP dForm">
                        <div class="fieldGroup">
                            <label class="smallLabel">Plan type</label>
                            <ul class="xType">
                                <li >

                                    <input type="radio" name="yTypeRadioY" checked={((planType.setShift == true || calendarData.is_shift == 1 || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() === weekDayOff.toLowerCase())) && (planType.markLeave == false || planType.markLeave == undefined)) ? "checked" : ""} />
                                    <label onClick={handlePlanType} id="setShift" for="yTypeRadio1">Set shift</label>
                                </li>
                                <li>
                                    <input type="radio" name="yTypeRadioY" checked={((planType.markLeave == true
                                        || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() !== weekDayOff.toLowerCase())) && (planType.setShift == false || planType.setShift == undefined)) ? "checked" : ""} />
                                    <label onClick={handlePlanType} id="markLeave" for="yTypeRadio2">Mark leave</label>
                                </li>
                            </ul>
                        </div>
                        {planTypeErr != "" && <Error error={planTypeErr} />}
                        <div class="fieldGroup">
                            <label class="smallLabel">Driver/Supervisor</label>
                            <div class="multiOption" onClick={openDropDown} id="driverList">
                                <div class="selectBox fullWidth">
                                    <p>{attendanceInfo.info.firstname}<i class="material-symbols-rounded grey">expand_more</i></p>

                                </div>
                            </div>

                        </div>

                        <section>



                            <div class="addSlot dForm">
                                {shiftInfo.map((info, index) => {
                                    return (
                                        <>
                                            <div class="fieldGroup">
                                                <label class="smallLabel jcSpacebetween flexFlowInitial"></label>
                                                <span>Select shift date range </span>
                                                <span class="absIcon">
                                                    <input type="text" value={moment(attendanceInfo.date).format("YYYY-MM-DD")} placeholder="DD/MM/YYYY" name="" />
                                                    <i class="material-symbols-rounded grey arrowBottom mt-m">calendar_month</i>
                                                </span>

                                            </div>

                                            <div class="lists">
                                                <div class="xType alignBottom">
                                                    {((planType.setShift == true || calendarData.is_shift == "1") || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() == weekDayOff.toLowerCase())) && (planType.markLeave == false || planType.markLeave == undefined) &&
                                                        <div class="fieldGroup fullWidth">
                                                            <em class="smallLabel">Shift type </em>
                                                            <div class="multiOption" id="shiftTypes" onClick={() => {
                                                                setShowShiftTypeDropDown({
                                                                    [index]: !showShiftTypeDropDown[index],
                                                                })
                                                                setError("");
                                                            }}>

                                                                <div class={showShiftTypeDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                    <p>{shiftName[index] ? shiftName[index] : calendarData.shift_label ? calendarData.shift_label : "Select shift type"}<i class="material-symbols-rounded grey">expand_more</i>
                                                                    </p>
                                                                    <div class="selectDrop">

                                                                        <ul class="dropMenu">
                                                                            <li class={"Select shift type" == shiftName[index] || shiftName[index] == undefined ? "selected" : ""}>
                                                                                <a onClick={() => handleShiftType("Select shift type", index)} href="javascript:void(0);">
                                                                                    Select shift type
                                                                                </a>
                                                                            </li>
                                                                            {data.shiftTypeData.length != 0 &&
                                                                                data.shiftTypeData.map((shiftData, i) => {

                                                                                    return (
                                                                                        <>

                                                                                            <li class={shiftData.shift_name == shiftName[index] || shiftName[index] == undefined && (calendarData.attendance_status == shiftData.shift_code) ? "selected" : ""}>
                                                                                                <a onClick={() => handleShiftType(shiftData, index)} href="javascript:void(0);">
                                                                                                    {shiftData.shift_name ? shiftData.shift_name : calendarData.attendance_status}
                                                                                                </a>
                                                                                            </li>
                                                                                        </>
                                                                                    )
                                                                                })
                                                                            }

                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {info.shiftTypeErr != "" && <Error error={info.shiftTypeErr} />}
                                                        </div>}


                                                    {((planType.setShift == true || calendarData.is_shift == "1" || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() == weekDayOff.toLowerCase())) && (planType.markLeave == false || planType.markLeave == undefined)) &&
                                                        <div class="fieldGroup fullWidth">
                                                            <em class="smallLabel">Weekly off</em>
                                                            <div class="multiOption" onClick={() => weeklyOff(index, dates[index])}>
                                                                <div class={showWeeklyOffDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                    <p>{selectDay[index] ? selectDay[index] : "Select leave"}<i class="material-symbols-rounded grey">expand_more</i>
                                                                    </p>
                                                                    <div class="selectDrop">
                                                                        <ul class="dropMenu pText">

                                                                            <li class={selectDay[index] == "Select weekly off" ? "selected" : "cPointer"}>

                                                                                <p onClick={() => handleWeeklyOff("Select weekly off", index)} >Select weekly off</p>

                                                                            </li>
                                                                            <li class={selectDay[index] == moment(attendanceInfo.date).format('dddd') ? "selected" : "cPointer"}>

                                                                                <p onClick={() => handleWeeklyOff(moment(attendanceInfo.date).format('dddd'), index)}>{moment(attendanceInfo.date).format('dddd')}</p>

                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            {info.weeklyOffErr != "" && <Error error={info.weeklyOffErr} />}
                                                        </div>}

                                                    {((planType.markLeave == true) || (calendarData.is_shift == 0 && calendarData.attendance_status.toLowerCase() != weekDayOff.toLowerCase())) && (planType.setShift == false || planType.setShift == undefined) &&
                                                        <div div class="fieldGroup fullWidth">
                                                            <em class="smallLabel">Leave off</em>
                                                            <div class="multiOption" onClick={() => {
                                                                setShowLeaveDropDown({
                                                                    [index]: !showLeaveDropDown[index],
                                                                });
                                                            }}>
                                                                <div class={showLeaveDropDown[index] == true ? "selectBox fullWidth open" : "selectBox fullWidth"}>
                                                                    <p>{leaveName[index] ? leaveName[index] : calendarData.attendance_status_description}<i class="material-symbols-rounded grey">expand_more</i>
                                                                    </p>
                                                                    <div class="selectDrop">
                                                                        <ul class="dropMenu pText">

                                                                            {data.leaveData.length != 0 && data.leaveData.map((leave) => {
                                                                                return (
                                                                                    <li class="cPointer">
                                                                                        <p onClick={() => handleLeave(leave, index)}>{leave.leave_type_name}</p>

                                                                                    </li>
                                                                                )
                                                                            })}


                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            {info.leaveOffErr != "" && <Error error={info.leaveOffErr} />}
                                                        </div>}


                                                </div>
                                            </div >
                                        </>
                                    )
                                })}


                            </div>
                        </section>
                    </section>
                    {error != "" && <Error error={error} />}

                    {
                        Object.entries(apiError).map((errorData) => {

                            return (
                                <>
                                    {errorData[0] != undefined && <Error error={errorData[0] + ": " + errorData[1]} />}
                                    <br />
                                </>
                            )
                        })
                    }
                    {
                        apiSuccess && <Success success={apiSuccess} />
                    }
                    <div class="actionButtons mt-24">
                        <span>
                            <a onClick={addJobPlan} class="btn prim">Update</a>
                        </span>
                    </div>
                </div>
            </div>


        </Overlay >
    )
}


export default EditAttendance