import { useState, useEffect } from "react";
import { axiosPrivate } from "../../api/PrivateRequestServices";
import moment from "moment";
import JobPlannerdisplay from "./JobPlannerdisplay";

const perPageLimit = 10;

function JobPlannerDisplayData({
    showPopUp, setShowPopUp, attendanceInfo, setAttendanceInfo
}) {

    let fromDate, toDate;
    const today = new Date();
    var duration = moment.duration({ 'days': 6 });
    const [date, setDate] = useState({
        fromDate: moment(today).format("YYYY-MM-DD"),
        toDate: moment(today).add(duration).format('YYYY-MM-DD')
    })
    const [isLoading, setIsLoading] = useState();
    const [isSuccess, setIsSuccess] = useState();


    const [searchText, setSearchText] = useState("");


    const [attendanceData, setAttendanceData] = useState([]);

    const editAttendanceOnSuccessCallback = (editedData) => {

        let currentAttendanceData = { ...attendanceData };
        currentAttendanceData[editedData.user_id]['calendar_data'][editedData.date]['attendance_status'] = editedData.attendance_status;
        currentAttendanceData[editedData.user_id]['calendar_data'][editedData.date]['color_code_class'] = editedData.color_code_class;
        currentAttendanceData[editedData.user_id]['calendar_data'][editedData.date]['is_shift'] = editedData.is_shift;
        currentAttendanceData[editedData.user_id]['calendar_data'][editedData.date]['shift_label'] = editedData.shift_label;
        setAttendanceData(currentAttendanceData);
        setShowPopUp({ upLoadAttenance: false, saveAttendance: false });
    };


    useEffect(() => {
        const getSchedule = async () => {
            setIsLoading(true);
            const attendanceSchedulebody = {

                "start_date": date.fromDate,
                "end_date": date.toDate,


            }
            const attendanceScheduleUrl = process.env.REACT_APP_GET_ATTENDANT_SCHEDULE;
            const attendanceScheduleResponse = await axiosPrivate.post(attendanceScheduleUrl, attendanceSchedulebody)

            if (attendanceScheduleResponse?.data?.status == 200) {
                setIsLoading(false);
                setAttendanceData(attendanceScheduleResponse?.data?.response?.data);
            }
        }

        getSchedule();

    }, [date, isSuccess])


    return (

        <>
            <JobPlannerdisplay showPopUp={showPopUp} setShowPopUp={setShowPopUp} date={date} setDate={setDate} attendanceData={attendanceData} isLoading={isLoading} attendanceInfo={attendanceInfo} setAttendanceInfo={setAttendanceInfo}
                isSuccess={isSuccess} setIsSuccess={setIsSuccess} editAttendanceOnSuccessCallback={editAttendanceOnSuccessCallback}
            />
        </>
    );
}

export default JobPlannerDisplayData;
