import React, { useState } from 'react'
import moment from 'moment';
import Spinner from "../UI/Spinner";
import UpLoadAttendance from './UploadAttendance';
import AddNewPlan from './AddNewPlan';
import StickyTd from './StickyTd';
import RecordTd from './RecordTd';
import EditAttendance from './EditAttendance';
import useAuth from '../../hooks/useAuth';
const JobPlannerdisplay = ({ showPopUp, setShowPopUp, date, setDate, attendanceData, isLoading ,attendanceInfo, setAttendanceInfo,isSuccess,setIsSuccess, editAttendanceOnSuccessCallback }) => {

    const days = ["Sun", "Mon", "Tues", "Wed", "Thu", "Fri", "Sat"];
    const today = new Date();
    const { auth } = useAuth();
    var duration1 = moment.duration({ 'days': 1 });
    var duration2 = moment.duration({ 'days': 7 });
    const setFutureDate = () => {
        setDate({
            fromDate: moment(date.toDate).add(duration1).format("YYYY-MM-DD"),
            toDate: moment(date.toDate).add(duration2).format('YYYY-MM-DD')
        })
    }
    const onBackdropClick = (operation_status) => {
        
        if (operation_status == true)
        {
             setIsSuccess(!isSuccess)
            
            }
      
        setShowPopUp({ upLoadAttenance: false, saveAttendance: false })
        document.body.classList.remove("hidden");


    }
    const setPastDate = () => {
        setDate({
            fromDate: moment(date.fromDate).subtract(duration2).format("YYYY-MM-DD"),
            toDate: moment(date.fromDate).subtract(duration1).format('YYYY-MM-DD')
        })
    }

    function getDatesInRange(startDate, endDate) {
        const date = new Date(startDate.getTime());

        const dates = [];

        while (date <= endDate) {
            dates.push(new Date(date));
            date.setDate(date.getDate() + 1);
        }

        return dates;
    }

    const d1 = new Date(date.fromDate);
    const d2 = new Date(date.toDate);
    const datearr = getDatesInRange(d1, d2);

   
    return (
        <>
            {showPopUp.editAttendance==true&&auth.priviliges.includes("write_job_planner")&&<EditAttendance attendanceInfo={attendanceInfo} setAttendanceInfo={setAttendanceInfo} onBackdropClick={onBackdropClick} isSuccess={isSuccess} setIsSuccess={setIsSuccess} editAttendanceOnSuccessCallback={editAttendanceOnSuccessCallback} />}
            {showPopUp.addNewPlan == true&&auth.priviliges.includes("write_job_planner") && <AddNewPlan onBackdropClick={onBackdropClick} isSuccess={isSuccess} setIsSuccess={setIsSuccess} />}
            {showPopUp.upLoadAttenance == true&&auth.priviliges.includes("write_job_planner") && <UpLoadAttendance onBackdropClick={onBackdropClick}  />}
            <div class="subContent jobPlannerTable mt-8 pt-24">
                <div class="xRow titleHead mb-24 jcSpacebetween">
                    <h3 class="mar-0 fW600">{moment(date.fromDate).format("D MMM")} - {moment(date.toDate).format("D MMM")}</h3>
                    <div class="lnheig gap16 flex">
                        <i class="material-symbols-rounded arrowLeft mt-l  cPointer black fill" onClick={setPastDate}>expand_more</i>
                        <i class="material-symbols-rounded arrowRight mt-l cPointer black fill" onClick={setFutureDate}>expand_more</i>
                    </div>
                </div>
                <div class="tableSlots scrollBarC">

                    <table class="mainTable">
                        <tbody>
                            <tr>
                                <StickyTd attendanceData={attendanceData} />
                                <RecordTd datearr={datearr} attendanceData={attendanceData} isLoading={isLoading} showPopUp={showPopUp} setShowPopUp={setShowPopUp} attendanceInfo={attendanceInfo} setAttendanceInfo={setAttendanceInfo}  />
                            </tr>
                            </tbody>

                    </table>
                </div>
            </div>
        </>
    )
}

export default JobPlannerdisplay