import React from 'react'
import Spinner from '../UI/Spinner'
import moment from 'moment'
import RecordCalenderData from './RecordCalenderData';

const TableBody = ({ datearr, attendanceData, isLoading ,showPopUp, setShowPopUp, attendanceInfo, setAttendanceInfo}) => {
    
    return (
        <tbody>
            {isLoading == false ?

                attendanceData != undefined && Object.entries(attendanceData).map((data) => {
                    return(<tr>
                        <RecordCalenderData
                            attendentUserId={data[0]}
                            attendanceRecords={data[1]}
                            dateArr={datearr}
                            showPopUp={showPopUp} setShowPopUp={setShowPopUp}
                            attendanceInfo={attendanceInfo} setAttendanceInfo={setAttendanceInfo}
                            isLoading={isLoading}
                        />
                    </tr>)
                }) : <Spinner/>
            
            }
        </tbody>
    )
}

export default TableBody