import React from 'react'
import Overlay from '../../utils/Overlay'
import { Link } from 'react-router-dom'
import { useState } from 'react';
import useAxiosIntercept from '../../hooks/useAxiosIntercept';
import Error from '../UI/Error';
import Success from '../UI/Success';
import Spinner from '../UI/Spinner';
export default function UploadAttendance({ onBackdropClick }) {
    
  
    const axiosPrivate = useAxiosIntercept();
    const [isLoading, setIsLoading] = useState();
    const [csvFile, setCsvFile] = useState("");
    const [fileName, setFileName] = useState("");
    const [fileSize, setFileSize] = useState("");
    const [showReportDownloadLink, setShowReportDownloadLink] = useState(false);
    const [reportFile, setReportFile] = useState("");
    const [successMsg, setSuccessMsg] = useState("");
    const [errors, setErrors] = useState({ message: "" });
    const downloadCSV = async () => {
        const URL = process.env.REACT_APP_ATTENDANCE_MAPPING_SAMPLE;
        const sampleFile = await axiosPrivate.get(URL);
        if (sampleFile?.data?.status == "200") {

            window.open(sampleFile?.data?.response?.data?.sample_file, '_blank', 'noreferrer')
        }
    }
    const getFileDetails = (e) => {
        setErrors("");
        setShowReportDownloadLink(false);
        setCsvFile(e.target.files[0]);
        setFileName(e.target.files[0].name);
        setFileSize(e.target.files[0].size);

    }
    const deleteFile = () => {
        setCsvFile("");
        setFileName("");
        setFileSize("");
        setErrors("");

    }
    const downloadReport = () => {
        window.open(reportFile, '_blank', 'noreferrer')


    }
    const updateSlots = async () => {
        setIsLoading(true);
        

        try {
            const formData = new FormData();
            formData.append("file", csvFile);
            const config = { headers: { 'content-type': 'multipart/form-data' } }

            if (csvFile != "") {
                const response = await axiosPrivate.post(process.env.REACT_APP_UPLOAD_ATTENDANCE_CSV, formData, config);
                if (response?.data?.status == "200") {
                    setIsLoading(false);
                    setShowReportDownloadLink(true);
                    setReportFile(response?.data?.response?.data?.filepath)
                    setSuccessMsg("csv uploaded successfully");

                }
                else {
                    setIsLoading(false);
                    setErrors(response?.data?.response?.errors);
                    setCsvFile("")
                }

            }
            else {
                setErrors({ message: "Please Upload CSV file" });
                setIsLoading(false);
                


            }





        }
        catch (err) {

        }


    }
    return (
        <>

{isLoading==true&&<Spinner/>}
            <Overlay onBackdropClick={onBackdropClick}>


                <div class="model_box_child uploadSlotsP" id="uploadSlotsP" style={{ width: "260px" }}>
                    <div class="ap_heading">
                        <h4 style={{ color: "#212121", fontSize: "1.25rem" }}>Upload job plan <span class="material-symbols-rounded black close_model" style={{ marginLeft: "auto" }} onClick={()=>onBackdropClick(true)}>close</span></h4>
                    </div>
                    <div class="contentSection" style={{ marginTop: "20px" }}>
                        <section class="assignPromoP">
                            <div class="promoText">

                                <i class="material-symbols-rounded mt-m">upload_file</i>
                                <p>Upload file

                                </p>
                                <input type="file" required style={{ opacity: "0", position: "absolute", width: "100%", left: "0", cursor: "pointer" }} onChange={getFileDetails} />

                                <br />

                            </div>
                            {csvFile && <div class="promoText uploaded">
                                <i class="material-symbols-rounded mt-l fill">check_circle</i>
                                <p>{fileName} <em>{(fileSize / 1024).toFixed(2) + " kb"}</em></p>
                                <i class="material-symbols-rounded mt-m delete" onClick={deleteFile}>delete</i>
                            </div>}

                        </section>
                        <section>
                            <div class="addSlot mt-24">
                                <div class="link">
                                    <i class="material-symbols-rounded mt-m">download_for_offline</i>
                                    <Link onClick={downloadCSV}>Download sample file</Link>

                                </div>
                                {showReportDownloadLink && <div class="link">
                                    <i class="material-symbols-rounded mt-m">download_for_offline</i>
                                    <Link onClick={downloadReport}>Download Report file</Link>

                                </div>}

                            </div>
                        </section>

                        <div class="actionButtons mt-24">
                            <span>
                                {errors && <Error error={errors.message} />}
                                
                                {Array.isArray(errors) && errors?.length > 0 && errors.map((error) => {
                                    return (<>
                                        <br />
                                        <Error error={error?.message} />
                                       

                                    </>)
                                })}
                                <a class="btn prim fullW" onClick={updateSlots}>Update job plan</a>
                                {successMsg && <Success success={successMsg} />}
                            </span>
                        </div>
                    </div>
                </div>


            </Overlay>
        </>
    )
}
