import { React, useRef, useState, useEffect } from "react";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import useLogout from "../../../hooks/useLogout";
import useOutsideClick from "../../../hooks/useOutsideClick";
import useAuth from "../../../hooks/useAuth";
import Image from "../../UI/Image";

const Header = ({ errType, errValue, name }) => {
  const logout = useLogout();
  const popupref = useRef();
  const { auth, setAuth } = useAuth();
  const axiosPrivate = useAxiosIntercept();
  const [userDetails, setUserDetails] = useState([]);
  const [showUserProfile, setShowUserProfile] = useState(false);

  const userId = auth.userId;

  useOutsideClick(popupref, () => {
    setShowUserProfile(false);
  });

  const loggingOut = async () => {
    const response = await logout();
  };
  const getuserDetalis = async () => {
    const URL = process.env.REACT_APP_GET_SINGLE_USER;
    try {
      const response = await axiosPrivate.get(URL + `&user_id=${userId}&show_privileges=1`, {
        //  signal: controller.signal,
        
      });
      if (response?.data?.status === 200) {
        if (response?.data?.response?.data?.user_info != null) {
          setAuth((prev) => {
            return {
              ...prev,
              userName: response?.data?.response?.data?.user_info.firstname,
              userEmail: response?.data?.response?.data?.user_info.email,
              userLastName: response?.data?.response?.data?.user_info.lastname,
              userImage: response?.data?.response?.data?.user_info.user_image,
              userIsRoot: response?.data?.response?.data?.user_info.is_root,
              priviliges: response?.data?.response?.data?.user_info.privileges
            };
          });
        }
        setUserDetails(response?.data?.response?.data?.user_info);

      }
    } catch (err) {

    }
  };

  useEffect(() => {
    //  const controller = new AbortController();

    if ((auth.userName == "") || (auth.userIsRoot == undefined || auth.userIsRoot == "")) {
      getuserDetalis();
    }




    // return () => {
    //   controller.abort();
    // };
  }, []);

  const showProfile = () => {
    setShowUserProfile(!showUserProfile);
    if (auth.userName == "") {
      getuserDetalis();
    }
  };

  return (
    <div className="headerWrap">
      <div className="header">
        <span style={{ marginLeft: "220px" }}></span>
        <div className="userNav" onClick={showProfile} ref={popupref}>
          {/* <i className="userAvtar">
              <Image
                userImage={userDetails?.user_image}
                name={userDetails?.firstname ? userDetails?.firstname : "Guest"}
              />
            </i> */}
          {auth.userImage && auth.userImage != undefined ? <i className="userAvtar"><img src={auth.userImage} style={{ overflow: "hidden" }}></img></i> : (auth.userName && auth.userName != undefined ? <i className="userAvtar">{auth.userName.charAt(0).toUpperCase()}</i> : <i className="userAvtar">User</i>)}

          <ul
            className="dropMenu"
            style={{ display: showUserProfile ? "block" : "none" }}
          >
            <li className="profileTxt">
              <Link to="">
                {/* <i className="userAvtar ml-0 mr-12">
                    <Image
                      userImage={userDetails?.user_image}
                      name={
                        userDetails?.firstname
                          ? userDetails?.firstname
                          : "Guest"
                      }
                    />
                  </i> */}
                {auth.userImage && auth.userImage != undefined ? <i className="userAvtar ml-0 mr-12"><img src={auth.userImage} style={{ overflow: "hidden" }}></img></i> : (auth.userName && auth.userName != undefined ? <i className="userAvtar ml-0 mr-12">{auth.userName.charAt(0).toUpperCase()}</i> : <i className="userAvtar ml-0 mr-12">User</i>)}
                <span>{auth.userName ? `${auth.userName}` : "Guest"}
                  <em>
                    {auth.userEmail}
                  </em>
                </span>
              </Link>
            </li>
            {/* <li>
                <Link to="">Profile</Link>
              </li> */}
            <li>
              <Link style={{ color: "red" }} to="" onClick={loggingOut}>
                Logout
              </Link>
            </li>
          </ul>
        </div>
      </div>
    </div>
  )

};

export default Header;
