import React, { useState, useEffect, useContext } from "react";
import { Outlet, Link } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import NavFooter from "../SideBar/NavFooter";
import NavList from "./NavList";
import NavContext from "../../../context/NavContext";

const NavBar = () => {
  const [navData, setNavData] = useState(null);
  const axiosPrivate = useAxiosIntercept();
  const { nav, setNav } = useContext(NavContext);

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getNavData = async () => {
      try {
        const response = await axiosPrivate.get(
          process.env.REACT_APP_GET_MENU_LINKS,
          {
            signal: controller.signal,
          }
        );
        // isMounted && setNavData(response?.data);
        return response?.data?.response?.data?.menu_links
      } catch (err) {
        //console.error(err);
      }
    };
    if (nav?.length == "0" || nav == undefined) {
      getNavData().then((data) => {
        setNav(data);

      });

    }


    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);
  return (
    <>
      <div className="main_navigation">
        <ul>
          {nav && (
            <NavList navigationList={nav} />
          )}
        </ul>
        <NavFooter />
      </div>

      <Outlet />
    </>
  );
};

export default NavBar;
