import React, { Children, useState } from "react";
import { Link, useLocation, matchPath } from "react-router-dom";
import useLogout from "../../../hooks/useLogout";

const NavList = ({ navigationList, classData }) => {
  const [showNextLevelNav, setshowNextLevelNav] = useState({});

  const { pathname } = useLocation();
  const logoutUser = useLogout();

  const logout = async () => {
    const response = await logoutUser();
  };

  return (
    <ul className={classData ? classData : ""}>
      {navigationList !== undefined &&
        navigationList.map((item) => {
          // console.log(`Item link url`, item.link_url, pathname);
          return (
            <React.Fragment key={item.link_id}>
              {item.sub_links ? (
                <li
                  className={
                    matchPath({ path: `/${item.link_name}/*` }, pathname) !==
                      null
                      ? "active openMenu"
                      : showNextLevelNav[item.link_name]
                        ? "openMenu"
                        : ""
                  }
                  key={item.link_name}
                >
                  <a
                    style={{ cursor: "pointer" }}
                    onClick={() => {
                      setshowNextLevelNav({
                        ...showNextLevelNav,
                        [item.link_name]: !showNextLevelNav[item.link_name],
                      });
                    }}
                  >
                    <i className="material-symbols-rounded mt-m grey">
                      {item.menu_icon_tag}
                    </i>
                    {item.link_name}
                    {showNextLevelNav[item.link_name] ? (
                      <i className="material-symbols-rounded grey arrowTop mt-m arrow">
                        expand_more
                      </i>
                    ) : (
                      <i className="material-symbols-rounded grey arrowBottom mt-m arrow">
                        expand_more
                      </i>
                    )}
                  </a>
                  {item.sub_links && (
                    <NavList
                      classData="childMenuList"
                      navigationList={item.sub_links}
                    />
                  )}
                </li>
              ) : (
                <li
                  className={
                    matchPath({ path: `/${item.link_url}/*` }, pathname) !==
                      null
                      ? "active"
                      : ""
                  }
                  key={item.link_name}
                >
                  <Link to={item.link_url}>
                    <i className="material-symbols-rounded mt-m grey">
                      {item.menu_icon_tag}
                    </i>
                    {item.link_name}
                  </Link>
                  {showNextLevelNav[item.link_name] && item.sub_links && (
                    <NavList
                      classData="childMenuList"
                      navigationList={item.sub_links}
                    />
                  )}
                </li>
              )}
            </React.Fragment>
          );
        })}
    </ul>
  );
};

export default NavList;
