import React, { useMemo } from "react";
import { GoogleMap, Marker } from "@react-google-maps/api";
const mapZoom = 18;

function Map(props) {
  const { currentLat, currentLng } = props;
  const center = useMemo(
    () => ({ lat: currentLat, lng: currentLng }),
    [currentLat, currentLng]
  );
  return (
    <>
      <GoogleMap
        zoom={mapZoom}
        center={center}
        mapContainerClassName="map-container"
      >
        <Marker position={center} />
      </GoogleMap>
    </>
  );
}

export default Map;
