import React, { useState } from "react";
import { Autocomplete, useLoadScript } from "@react-google-maps/api";
import Map from "./Map";
import './Map.css';
const placesLibrary = ["places"];
const googleMapsApiKey = "AIzaSyB5sj0eNvx5bQDM_hJTIIhY42n_c75P63A";
function MapAutoComplete({ setMapState }) {
  const [searchResult, setSearchResult] = useState("");
  const [currentLat, setCurrentLat] = useState(1.29027);
  const [currentLng, setCurrentLng] = useState(103.851959);
  const { isLoaded } = useLoadScript({
    googleMapsApiKey: googleMapsApiKey,
    libraries: placesLibrary,
  });
  const restrictions = {
    country: ["sg"],
  };
  function onLoad(autocomplete) {
    setSearchResult(autocomplete);
  }

  function onPlaceChanged() {
    if (searchResult != null) {
      const place = searchResult.getPlace();
      const lat = place.geometry.location.lat();
      const lng = place.geometry.location.lng();
      if (setMapState !== undefined) {
        setMapState(place);
      }
      setCurrentLat(lat);
      setCurrentLng(lng);
    } else {
      alert("Please enter text");
    }
  }

  if (!isLoaded) {
    return <div>Loading...</div>;
  }

  return (
    <>
      <Autocomplete
        onPlaceChanged={onPlaceChanged}
        onLoad={onLoad}
        restrictions={restrictions}
      >
        <div class="fieldGroup mt-0">
          <input type="text" placeholder="Search for address" />
        </div>
      </Autocomplete>

      <Map currentLat={currentLat} currentLng={currentLng} />
    </>
  );
}
export default MapAutoComplete;
