import { useState, useEffect } from "react";
import { Link } from "react-router-dom";

const AccountNavItems = ({
  AccountItems,
  setIndexAccountType,
  setAccountTypeInfo,
  setSelectedIndexPackages,
  selectedIndexPackages,
}) => {
  const [selectedIndex, setSeletedIndex] = useState(0);

  useEffect(() => {
    setIndexAccountType(AccountItems?.[selectedIndex]?.package_types);
    setAccountTypeInfo((prev) => {
      return {
        ...prev,
        accountTypeId: AccountItems?.[selectedIndex]?.package_account_id,
        packageTypeId:
          AccountItems?.[selectedIndex]?.package_types?.[selectedIndexPackages]
            ?.package_type_id,
      };
    });
  }, [selectedIndex]);

  useEffect(() => {
    let packageIndex = selectedIndex === undefined ? 0 : selectedIndex;
    if (packageIndex == 0) {
      document.title =
        "Packages ::: " +
        (AccountItems?.[packageIndex]?.package_account_type === undefined
          ? "Pay as you go"
          : AccountItems?.[packageIndex]?.package_account_type);
    } else {
      if (
        AccountItems?.[packageIndex]?.package_types[selectedIndexPackages]
          .package_type_name !== undefined
      ) {
        document.title =
          "Packages ::: " +
          AccountItems?.[packageIndex]?.package_account_type +
          " - " +
          AccountItems?.[packageIndex]?.package_types[selectedIndexPackages]
            .package_type_name;
      } else {
        document.title =
          "Packages ::: " + AccountItems?.[packageIndex]?.package_account_type;
      }
    }
  }, [selectedIndex, selectedIndexPackages]);
  return (
    <>
      {AccountItems?.[0]
        ? AccountItems?.map((item, index) => {
            return (
              <li
                key={item.package_account_id}
                className={index === selectedIndex ? "selected" : ""}
                onClick={() => {
                  setSeletedIndex(index);
                  setIndexAccountType(AccountItems?.[index]?.package_types);
                  setSelectedIndexPackages(0);
                  setAccountTypeInfo((prev) => {
                    return {
                      ...prev,
                      accountTypeId: item.package_account_id,
                      packageTypeId:
                        AccountItems?.[index]?.package_types?.[index]
                          ?.package_type_id,
                    };
                  });
                }}
              >
                <Link>{item.package_account_type}</Link>
              </li>
            );
          })
        : ""}
    </>
  );
};

export default AccountNavItems;
