import React, { useState, useEffect } from "react";
import AccountNavItems from "./AccountNavItems";
import { Link } from "react-router-dom";

const AccountNavList = ({ AccountsData, setAccountTypeInfo, packageTypes }) => {
  const [indexAccountType, setIndexAccountType] = useState([]);
  const [selectedIndexPackages, setSeletedIndexPackages] = useState(0);

  useEffect(() => {
    setIndexAccountType(packageTypes);
  }, [packageTypes]);

  return (
    <>
      <ul className="level1">
        <AccountNavItems
          AccountItems={AccountsData}
          setIndexAccountType={setIndexAccountType}
          setAccountTypeInfo={setAccountTypeInfo}
          setSelectedIndexPackages={setSeletedIndexPackages}
          selectedIndexPackages={selectedIndexPackages}
        />
      </ul>
      {indexAccountType?.[0] && (
        <ul className="level2 mt-24">
          {/* <AccountNavItems AccountItems={item.package_types} /> */}
          {indexAccountType?.map((item, index) => {
            return (
              <React.Fragment key={index}>
                <li
                  key={item.package_type_id}
                  className={index === selectedIndexPackages ? "selected" : ""}
                  onClick={() => {
                    setSeletedIndexPackages(index);
                    setAccountTypeInfo((prev) => {
                      return {
                        ...prev,
                        packageTypeId: item.package_type_id,
                      };
                    });
                  }}
                >
                  <Link>{item.package_type_name}</Link>
                </li>
              </React.Fragment>
            );
          })}
        </ul>
      )}
    </>
  );
};

export default AccountNavList;
