import React, { useEffect, useState, useRef } from "react";
import SubMainContainer from "../UI/SubMainContainer";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import responseHandler from "../../services/responseHandler";
import AccountNavList from "./AccountNavList";
import PackageListing from "./PackageListing";
import useAuth from "../../hooks/useAuth";
import DataNotFound from "../UI/DataNotFound";
import Spinner from "../UI/Spinner";
import NoPriviliges from "../UI/NoPriviliges";
const Accounts = ({ searchValue }) => {
  const [packageAccountTypes, setPackageAccountTypes] = useState([]);
  const [accountTypeInfo, setAccountTypeInfo] = useState({
    accountTypeId: 0,
    packageTypeId: 0,
  });
  const { auth } = useAuth();
  const [packageTypes, setPackageTypes] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const effectRun = useRef(false);

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getAccountTypes = async () => {
      try {
        const response = await axiosPrivate.get(
          process.env.REACT_APP_GET_ACCOUNT_TYPES_URL,
          {
            signal: controller.signal,
          }
        );
        if (response?.data?.status === 200) {
          const { package_account_type } = response.data.response?.data;

          isMounted && setPackageAccountTypes(package_account_type);
          setAccountTypeInfo((prev) => {
            return {
              ...prev,
              accountTypeId: package_account_type?.[0]?.package_account_id,
              packageTypeId:
                package_account_type?.[0]?.package_types?.[0]?.package_type_id,
            };
          });
          setPackageTypes(package_account_type?.[0]?.package_types);
        } else {
          console.log(`API Error: ${JSON.stringify(response?.data?.response)}`);
        }
      } catch (err) {
        return responseHandler(err, "NETWORK_ERROR");
      }
    };

    // if (!effectRun.current) {
    getAccountTypes();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      effectRun.current = true;
    };
  }, []);

  return (
    <>
      <SubMainContainer SubMainContainerCustomClass="navTabs mt-24">
        {auth.priviliges.includes("read_package") &&
          <AccountNavList
            AccountsData={packageAccountTypes}
            setAccountTypeInfo={setAccountTypeInfo}
            packageTypes={packageTypes}
          />}
      </SubMainContainer>
      {auth.priviliges.length > "0" ? auth.priviliges.includes("read_package") ?
        <PackageListing
          accountTypeInfo={accountTypeInfo}
          searchValue={searchValue}
        /> : <NoPriviliges message="no priviliges" /> : <Spinner />}
    </>
  );
};

export default Accounts;
