import React from "react";
import {Link} from "react-router-dom";

const PackageBrandDetails = (props) => { 
    return (
        <>
            <div className="colItem actionNavList">
                {props.vehicleSpecifications[0].brand_id === "0" ? ('All') : 
                (
                    <>
                        {props.vehicleSpecifications?.length}
                        <i className="material-symbols-rounded arrowBottom mt-m">expand_more</i>
                        <div className="dropMenuWrap">
                            <ul className="dropMenu">
                            {props.vehicleSpecifications.map((item,index) => (
                                <li key={index}>
                                    <Link to="">
                                            {item.brand_name !== null ? (item.brand_name) : ('')} 
                                            {item.model_name !== null ? (' ' + item.model_name) : ('')} 
                                            {item.variant_name !== null ? (' ' + item.variant_name) : ('')}
                                    </Link>
                                </li>
                            ))}
                            </ul>
                        </div>
                    </>
                )}
            </div>
        </>
    )
}

PackageBrandDetails.defaultProps = { };

export default PackageBrandDetails;