import React, { useState, useEffect, useRef } from "react";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import responseHandler from "../../services/responseHandler";
import SubMainContainer from "../UI/SubMainContainer";
import { HourMapping } from "../../configuration/createPackageFormConfigs";
import PackageStatus from "./PackageStatus";
import { Time } from "../../utils/Time";
import PackageBrandDetails from "./PackageBrandDetails";
import {partner_package_account_id,corporate_package_account_id} from "../../configuration/GlobalConfig";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
import RecoveryInsuranceTile from "./RecoveryInsuranceTile";
import { recovery_insurance_category_type } from "../../configuration/createPackageFormConfigs";
const PackageListing = ({ accountTypeInfo, searchValue }) => {
  const { auth } = useAuth();
  const [packageDetails, setPackageDetails] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const effectRun = useRef(false);
  const [status, setStatus] = useState({});
  const [inactive, setInactive] = useState();
  
  const getAddOnPriceDisplay = (service) => {
        let display_text = "free"
        if(service.max_service_limit > 0 ) {
            display_text = service.max_service_limit+" free/$"+parseInt(service.default_price)+" if no free";
        }else if(service.service_charge > 0) {
            display_text = "$"+parseInt(service.service_charge);
        }
        return display_text;
  };

  useEffect(() => {
    setStatus({});
    let isMounted = true;
    const controller = new AbortController();
    const getAccountTypes = async () => {
      try {
        let request = {
          package_account_id: accountTypeInfo.accountTypeId,
          package_type_id: accountTypeInfo.packageTypeId,
          services: 1,
        };
        if (searchValue !== "") {
          request = { ...request, package_name: searchValue };
        }
        const response = await axiosPrivate.post(
          process.env.REACT_APP_GET_PACKAGES_URL + '&show_vehicle_specs=1',
          request,
          {
            signal: controller.signal,
          }
        );
      
        if (response?.data?.status === 200) {
          isMounted &&
            setPackageDetails(response?.data?.response?.data?.packages);
          let packages = response?.data?.response?.data?.packages;
          packages.map((pack) => {
            return setInactive((prev) => {
              return { ...prev, [pack?.package_id]: pack?.package_status };
            });
          });
        } else {
          setPackageDetails({});
          // console.log(`API Error: ${JSON.stringify(response?.data?.response)}`);
        }
      } catch (err) {
        return responseHandler(err, "NETWORK_ERROR");
      }
    };

    if (effectRun.current) {
      getAccountTypes();
    }

    return () => {
      isMounted = false;
      controller.abort();
      effectRun.current = true;
    };
  }, [accountTypeInfo, searchValue]);
  const chechStatus = () => { };

  const statusHandler = (e) => {
    setStatus({ [e.target.id]: !status[e.target.id] });
  };
 
  const deletePackage = (package_index) => {
    //let currentPackageDetails = packageDetails;
    if (package_index !== -1) {
      const currentPackageDetails = [...packageDetails];
      currentPackageDetails.splice(package_index, 1);
      setPackageDetails(currentPackageDetails);
    }
  };

  return (
    <>
      <SubMainContainer SubMainContainerCustomClass="boxType1 mt-24">
        {packageDetails.length >= 0 ? (
          packageDetails.map((detailsItem, i) => {
            const {
              package_type_id,
              package_id,
              package_name,
              maximum_pre_booking_time,
              parking_fee_inclusive,
              package_auto_renew,
              services,
              service_fee,
              max_pre_book_time_unit,
              minimum_pre_booking_time,
              minimum_battery_unit,
              package_charge_rate,
              min_pre_book_time_unit,
              maximum_battery_unit,
              package_price,
              package_credit_amount,
              booking_start_time,
              booking_end_time,
              maximum_booking_allowed,
              package_duration,
              package_duration_unit,
              package_status,
              service_fee_without_add_on,
              package_credit_duration,
              package_credit_duration_unit,
              package_category_type,
              package_account_id,
              package_vehicle_specifications
            } = detailsItem;

         
            return (
              <React.Fragment key={i}>
                <section
                  className={
                    package_type_id === "18"
                      ? "emergency"
                      : inactive?.[package_id] == "0"
                        ? "inactive"
                        : "active"
                  }
                >
                  {package_category_type==recovery_insurance_category_type?<RecoveryInsuranceTile detailsItem={detailsItem} statusHandler={statusHandler} inactive={inactive} setInactive={setInactive} deletePackage={deletePackage} i={i} status={status}/>:(<>
                    <div className="head">
                    <p>
                      <span>{package_name}</span>
                      {/* {detailsItem?.package_type_id} */}
                      {package_type_id === "1" ? (
                        ""
                      ) : package_type_id === "18" ? (
                        ""
                      ) : (
                        <>
                          {package_price.slice(0, 1) != 0 ? (
                            <span>Price- ${package_price}</span>
                          ) : (
                            <></>
                          )}{" "}
                        </>
                      )}
                      {package_credit_amount.slice(0, 1) > "0" && (
                        <span>${package_credit_amount} credits</span>
                      )}
                    </p>
                    <ul className="tabsList">
                      {package_type_id !== "1" &&
                        package_type_id !== "18" &&
                        package_type_id !== "4" &&
                        package_type_id !== "3" ? (
                        <li>
                          {maximum_booking_allowed} booking
                          {package_duration > 0 && `/ ${package_duration}`}
                          {HourMapping?.[package_duration_unit]}
                          {package_credit_duration > 1 && "s"}
                        </li>
                      ) : package_type_id == "4" || package_type_id == "3" ? (
                        package_credit_duration > 0 &&
                          package_credit_duration_unit != "" ? (
                          <li>
                            {package_credit_duration && package_credit_duration}
                            {HourMapping?.[package_credit_duration_unit]}
                            {package_credit_duration > 1 && "s"}
                            &nbsp;validity
                          </li>
                        ) : (
                          ""
                        )
                      ) : (
                        ""
                      )}
                        {((package_type_id == "4" || package_type_id == "5") 
                          && (package_credit_duration === undefined || package_credit_duration == "" || package_credit_duration == 0)
                          && package_credit_duration_unit == "")
                        &&
                        <li>Unlimited credits validity</li>
                        }
                      {inactive?.[package_id] == "3" ? (
                        <li className="listStatus">Partner only</li>
                      ) : (inactive?.[package_id] == "1" ?
                        ("") : (<li className="listStatus">Inactive</li>)
                      )}
                      {package_duration !== "0" &&
                        package_type_id === "18" &&
                        package_type_id === "1" ? (
                        <li>
                          {package_duration}
                          {HourMapping?.[package_duration_unit]} validity
                        </li>
                      ) : (
                        ""
                      )}
                    </ul>
                    {
                      auth.priviliges.includes("write_package") &&
                      <div className="actionNav">
                        <i
                          className="material-symbols-rounded mt-m grey"
                          onMouseOver={statusHandler}
                          id={package_id}
                        >
                          more_vert
                        </i>
                        {status[package_id] ? (
                          <PackageStatus
                            id={package_id}
                            packageStatus={package_status}
                            packageId={package_id}
                            setInActive={setInactive}
                            inActive={inactive}
                            package_type_id={package_type_id}
                            package_index={i}
                            deletePackage={deletePackage}
                            package_account_id={package_account_id} 
                            package_name={package_name}        
                          />
                        ) : (
                          ""
                        )}
                      </div>
                    }
                  </div>
                  <div className="dataTable">
                    <div>
                      {(package_account_id === partner_package_account_id 
                      || package_account_id === corporate_package_account_id) 
                      && package_vehicle_specifications?.length > 0 ? (
                        <p>
                          <div className="colItem">Brands/Variants</div>
                          <PackageBrandDetails vehicleSpecifications={package_vehicle_specifications} />
                        </p>
                      ) : (
                        ''
                      )}
                        
                      <p>
                        <span>Charge KWH</span>

                        {package_charge_rate > 0 ? (
                          <span>$ {package_charge_rate}</span>
                        ) : (
                          <span>Unlimited</span>
                        )}
                      </p>
                      <p>
                        <span>Battery size</span>
                        {maximum_battery_unit === "10000" &&
                          minimum_battery_unit == 0 ? (
                          <span>All</span>
                        ) : maximum_battery_unit === "10000" &&
                          minimum_battery_unit > 0 ? (
                          <span>{minimum_battery_unit} kWh</span>
                        ) : (
                          <span>
                            {minimum_battery_unit !== "0"
                              ? `${minimum_battery_unit} - ${maximum_battery_unit}`
                              : `<${maximum_battery_unit}`}
                            {" kWh"}
                          </span>
                        )}
                      </p>
                      <p>
                        <span>Time</span>

                        {booking_end_time === "23:59:59" ? (
                          <span>24 hrs</span>
                        ) : (
                          <span>
                            {`${Time(booking_start_time)} - ${Time(
                              booking_end_time
                            )}`}
                          </span>
                        )}
                      </p>
                      <p>
                        <span>Minimum hrs. to book</span>
                        <span>
                          {minimum_pre_booking_time}
                          {minimum_pre_booking_time > 1
                            ? HourMapping?.[min_pre_book_time_unit] + "s"
                            : HourMapping?.[min_pre_book_time_unit]}
                          {package_type_id === "18" ? (
                            ""
                          ) : (
                            <>
                              {" -    "}
                              {maximum_pre_booking_time}
                              {HourMapping?.[max_pre_book_time_unit]}
                            </>
                          )}
                        </span>
                      </p>
                      {service_fee && (
                        <p>
                          <span>Service fee</span>
                          <span>
                            {service_fee === "0" ? "Free" : `$${service_fee}`}

                            {service_fee_without_add_on &&
                              `\u00A0 or \u00A0 $${service_fee_without_add_on}`}
                          </span>
                        </p>
                      )}
                      {parking_fee_inclusive && (
                        <p>
                          <span>Parking inclusive</span>
                          <span>${parking_fee_inclusive}</span>
                        </p>
                      )}
                      {package_auto_renew === "1" && (
                        <p>
                          <span>Auto renew</span>
                          <span>Yes</span>
                        </p>
                      )}
                      {package_auto_renew === "0" && (
                        <p>
                          <span>Auto renew</span>
                          <span>No</span>
                        </p>
                      )}
                    </div>
                  </div>
                  {services?.length > 0 && (
                    <div className="tableFooter">
                      <ul>
                        <li>Add-ons:</li>
                        {services.map((service, index) => {
                          const {
                            service_id,
                            service_image_tag,
                            max_service_limit,
                            service_charge,
                            service_name,
                            default_price,
                          } = service;
                          return (
                            <React.Fragment key={index}>
                              <li key={service_id}>
                                <i className="material-symbols-rounded grey mt-s">
                                  {service_image_tag}
                                </i>{" "}

                                <span>
                                  {getAddOnPriceDisplay(service)}

                                </span>{" "}
                                {service_name}
                              </li>
                            </React.Fragment>
                          );
                        })}
                      </ul>
                    </div>
                  )}
                  </>)}
                
                </section>
              </React.Fragment>
            );
          })
        ) : (
          <DataNotFound/>
        )}
      </SubMainContainer>
    </>
  );
};

export default PackageListing;
