import React from "react";
import { useState } from "react";
import { Link } from "react-router-dom";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import responseHandler from "../../services/responseHandler";
import { useEffect } from "react";
import NotificationNew from "../../utils/NotificationNew";

const PackageStatus = ({
  id,
  packageStatus,
  packageId,
  setInActive,
  inActive,
  setPackageDetails,
  package_type_id,
  package_index,
  deletePackage,
  package_account_id,
  package_name
}) => {
  const axiosPrivate = useAxiosIntercept();
  const [notifyData, setNotifyData] = useState();
  const [showPopUP, setShowPopUP] = useState(false);
  const [Activestatus, setActiveStatus] = useState({});
  useEffect(() => {
    setActiveStatus((prev) => {
      return { ...prev, [id]: packageStatus };
    });
  }, []);

  const handleDeletePackage = () => {
    setNotifyData({
      id: 3,
      heading: "Delete package",
      name: "Are you sure you want to delete?",
      text: package_name,
      success: "Package deleted successfully",
      buttonNameYes: "Delete",
      buttonNameNo: "Cancel",
      url: process.env.REACT_APP_CHANGE_PACKAGE_STATUS,
      apiRequest: {
        package_id: packageId,
        package_status: 2,
      },
    });
    setShowPopUP(true);
    // setPackageDetails([]);
  };

  const handleChange = (pack_id, mode) => {
    let requestStatus = 1;
    if (mode == "active") {
      requestStatus = Activestatus[pack_id] == 3 || Activestatus[pack_id] == 1 ? 0 : 1;
    } else {
      requestStatus = Activestatus[pack_id] == 3 ? 1 : 3;
    }


    /*const requestStatus = Activestatus[e.target.id] === true ? 0 : 1;*/
    const changeStatus = async () => {
      try {
        const request = {
          package_id: packageId,
          package_status: requestStatus,
        };
        const response = await axiosPrivate.post(
          process.env.REACT_APP_CHANGE_PACKAGE_STATUS,
          request
        );
        if (response?.data?.status === 200) {
          setActiveStatus((prev) => {
            return { ...prev, [pack_id]: requestStatus };
          });
          if (requestStatus == 1 || requestStatus == 3) {
            setInActive((prev) => {
              return {
                ...prev,
                [pack_id]: requestStatus,
              };
            });
            var addClass = "active";
          } else {
            setInActive((prev) => {
              return {
                ...prev,
                [pack_id]: "0",
              };
            });
            var addClass = "inactive";
          }
          // var element = document
          //   .getElementById(`${[e.target.id]}`)
          //   .parentElement.closest("section");
          // element.classList.remove(...element.classList);
          // element.classList.add(addClass);
        }
      } catch (err) {
        return responseHandler(err, "NETWORK_ERROR");
      }
    };
    changeStatus();
  };

  const onBackdropClick = (operation_status) => {
    if (operation_status === true) {
      deletePackage(package_index);
    }
    document.body.classList.remove('hidden');
    setShowPopUP(false);
  };
  return (
    <>
      {showPopUP && (
        <NotificationNew
          notifyData={notifyData}
          onBackdropClick={onBackdropClick}
        />
      )}
      <div className="dropMenuWrap">
        <ul className="dropMenu" style={{ width: "180px" }}>
          <li>
            <Link to="">
              Active
              <label className="toggleSwitch">
                <input
                  type="checkbox"
                  checked={Activestatus[id] == 1 || Activestatus[id] == 3 ? "checked" : ""}
                />
                <span
                  className="slider round"
                  onClick={() => handleChange(id, "active")}
                ></span>
              </label>
            </Link>
            {package_account_id == "1" &&
              <span>This will make this visible to direct customers only</span>
            }
          </li>
          {package_account_id == "1" &&
            <li>
              <Link to="">
                Partner plan
                <label className="toggleSwitch">
                  <input
                    type="checkbox"
                    checked={Activestatus[id] == 3 ? "checked" : ""}
                  />
                  <span
                    className="slider round"
                    id={id}
                    onClick={() => handleChange(id, "partner")}
                  ></span>
                </label>
              </Link>
              <span>This will make this a partner only plan</span>
            </li>
          }
          {package_type_id !== "18" ? (

            <li>
              <Link style={{ color: "red" }} onClick={handleDeletePackage}>Delete</Link>
            </li>
          ) : (<></>)}

        </ul>
      </div>
    </>
  );
};

export default PackageStatus;
