import React, { useState, useEffect, useRef, useMemo } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import responseHandler from "../../../services/responseHandler";
import DropdownTreeSelect from "react-dropdown-tree-select";
import { partner_package_account_id } from "../../../configuration/GlobalConfig";

const AccountAndPackageType = ({
  formData,
  setFormData,
  setPage,
  error,
  seterror,
  errors,
  setErrors,
}) => {
  const [packageTypes, setPackageTypes] = useState({});
  const [packages, setPackages] = useState([]);
  const [accountType, setAccountType] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const [brandlist, setbrandlist] = useState([]);
  const [modellist, setmodellist] = useState();
  const [variantlist, setvariantlist] = useState();
  const [partnerlist, setpartnerlist] = useState();
  const [corporatelist, setcorporatelist] = useState();
  const package_account_type_id = formData.package_account_type_id;
  const [isselected, setisseected] = useState(true);
  const [isSelectRefresh, setIsSelectRefresh] = useState({
    brand: true,
    model: true,
    variant: true,
  });
  /* Multi brands selection starts */
  const onBrandsChange = (currentNode, selectedNodes) => {
    if (currentNode.value === "selectAll") {
      toggleAll(currentNode.checked);
    }
    let vehicle_spec = [];
    let vehicle_display_spec = [];

    if (currentNode.value === "selectAll" && currentNode.checked == true) {
      vehicle_spec.push({
        vehicle_brand_id: 0,
        vehicle_model_id: 0,
        vehicle_variant_id: 0
      });
      {
        package_account_type_id === partner_package_account_id
        ? (brandlist?.map((brand) => {
          <>
            {brand?.label !== "Select All"
              ? (vehicle_display_spec.push({
                brand_id: brand?.brand_id,
                brand_name: brand?.label,
                model_id: "0",
                model_name: null,
                variant_id: "0",
                variant_name: null
              })
              )
              : ('')}
          </>
        })
        )
        : (vehicle_display_spec.push({
          brand_id: "0",
          brand_name: null,
          model_id: "0",
          model_name: null,
          variant_id: "0",
          variant_name: null
        })
        )
      }
    } else if (currentNode.value === "selectAll" && currentNode.checked == false) {
      vehicle_spec = [];
      vehicle_display_spec = [];
    } else {
      selectedNodes?.map((selectedNode, i) => {
        if (selectedNode?.brand_id != "" && selectedNode?.model_id === undefined && selectedNode?.variant_id === undefined) {
          vehicle_spec.push({
            vehicle_brand_id: selectedNode?.brand_id,
            vehicle_model_id: 0,
            vehicle_variant_id: 0
          }
          );
          vehicle_display_spec.push({
            brand_id: selectedNode?.brand_id,
            brand_name: selectedNode?.label,
            model_id: "0",
            model_name: null,
            variant_id: "0",
            variant_name: null
          });
        } else if (selectedNode?.brand_id != "" && selectedNode?.model_id != "" && selectedNode?.variant_id != "") {
          vehicle_spec.push({
            vehicle_brand_id: selectedNode?.brand_id,
            vehicle_model_id: selectedNode?.model_id,
            vehicle_variant_id: selectedNode?.variant_id
          }
          );
          vehicle_display_spec.push({
            brand_id: selectedNode?.brand_id,
            brand_name: selectedNode?.brand_name,
            model_id: selectedNode?.model_id,
            model_name: selectedNode?.model_name,
            variant_id: selectedNode?.variant_id,
            variant_name: selectedNode?.variant_name
          });
        }
      });
    }
    if (vehicle_spec.length > 0) {
      setErrors((prev) => ({
        ...prev,
        brandidError: false,
      }));
    }

    setFormData((prev) => ({
      ...prev,
      vehicle_specs: vehicle_spec,
      vehicle_display_spec: vehicle_display_spec
    }));
  }
  const toggleAll = (checked) => {
    let data = [...brandlist];
    for (var i = 1; i < data.length; i++) {
      data[i].checked = checked;
    }
    setbrandlist(data);
  };

  const assignObjectPaths = (obj, stack) => {
    Object.keys(obj).forEach(k => {
      const node = obj[k];
      if (typeof node === "object") {
        node.path = stack ? `${stack}.${k}` : k;
        assignObjectPaths(node, node.path);
      }
    });
  };

  const dropdown = useMemo(() => {
    return (
      <DropdownTreeSelect
        data={brandlist}
        onChange={onBrandsChange}
        texts={{ placeholder: 'Search any brand/model' }}
        className="mdl-demo"
      />
    )
  }, [brandlist]);

  /* Multi brands selection ends */
  const changePackageName = (event) => {
    setErrors(() => {
      return {
        packageTypeError: false,
      };
    });
    //console.log(formData, "fdataaaaaaaaaa");
    setisseected(false);
    const controller = new AbortController();
    const getpartnerlist = async () => {
      if (package_account_type_id === "3") {
        const URL = process.env.REACT_APP_GET_PARTNER_LIST;
        try {
          const response = await axiosPrivate.get(URL + "&status=A", {
            signal: controller.signal,
          });
          setpartnerlist(response?.data?.response?.data?.partners);
          setFormData((prev) => {
            return {
              ...prev,
              package_id:
                event.target.childNodes[
                  event.target.selectedIndex
                ].getAttribute("id"),
              package_name: event.target.value,
              package_category_type: event.target.childNodes[event.target.selectedIndex].getAttribute(
                "data-package_category_type")
            };
          });
        } catch (err) {
          console.log(err);
        }
      } else if (package_account_type_id === "5") {
        const URL = process.env.REACT_APP_GET_CORPORATE_LIST;
        try {
          const response = await axiosPrivate.get(URL + "&status=A", {
            signal: controller.signal,
          });
          setcorporatelist(response?.data?.response?.data?.partners);
          setFormData((prev) => {
            return {
              ...prev,
              package_id:
                event.target.childNodes[
                  event.target.selectedIndex
                ].getAttribute("id"),
              package_name: event.target.value,
              package_category_type: event.target.childNodes[event.target.selectedIndex].getAttribute(
                "data-package_category_type")
            };
          });
        } catch (err) {
          console.log(err);
        }
      } else {
        setPackageTypes((prev) => {
          return {
            ...prev,
            package_id:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "id"
              ),
          };
        });
        setFormData((prev) => {
          return {
            ...prev,
            package_id:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "id"
              ),
            package_name: event.target.value,
            package_category_type: event.target.childNodes[event.target.selectedIndex].getAttribute(
              "data-package_category_type"
            ),
          };
        });
      }
    };
    getpartnerlist();
  };
  const changeAccountType = (event) => {
    setErrors(() => {
      return {
        accountTypeError: false,
      };
    });
    //console.log(brandlist?.length,"brand");
    //console.log(modellist?.length,"model")
    seterror(false);
    setisseected(true);
    setIsSelectRefresh({ brand: true, model: true, variant: true });
    brandlist?.length > 0 && setbrandlist([]);

    modellist?.length > 0 && setmodellist([]);
    // console.log(brandlist?.length,"brand");
    // console.log(modellist?.length,"model")
    const getPackages = async () => {
      try {
        const postData = {
          package_account_id:
            event.target.childNodes[event.target.selectedIndex].getAttribute(
              "id"
            ),
        };
        const response = await axiosPrivate.post(
          process.env.REACT_APP_GET_PACKAGE_TYPE_URL,
          postData
        );
        // console.log("hellllllo",response)
        setPackages(response?.data?.response?.data?.package_types);
        setPackageTypes((prev) => {
          return {
            ...prev,
            package_id: event.target.value,
          };
        });
        setFormData((prev) => {
          return {
            ...prev,
            package_account_type_id:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "id"
              ),
            acccount_type_name: event.target.value,
          };
        });
      } catch (err) {
        console.error(err);
      }
    };
    getPackages();
  };
  const getVehicleModels = (event) => {
    setvariantlist([]);
    seterror(false);
    setIsSelectRefresh({ brand: false, model: true, variant: true });
    setFormData((prev) => {
      return {
        ...prev,
        vehicle_model_id: null,
        vehicle_variant_id: null,
      };
    });
    setErrors(() => {
      return {
        brandidError: false,
      };
    });
    const controller = new AbortController();
    const brand_id =
      event.target.childNodes[event.target.selectedIndex].getAttribute(
        "brandid"
      );
    const getModels = async () => {
      let URL = process.env.REACT_APP_GET_MODEL_LIST;
      try {
        URL = URL + `&brand_id=${brand_id}`;
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        setmodellist(response?.data?.response?.data?.models);
        setFormData((prev) => {
          return {
            ...prev,
            vehicle_brand_name:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "value"
              ),
            vehicle_brand_id:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "brandid"
              ),
          };
        });
      } catch (err) {
        console.log(err);
      }
    };
    getModels();
  };
  const getVehicleBrands = (event) => {
    setmodellist([]);
    setvariantlist([]);
    setIsSelectRefresh({ brand: true, model: true, variant: true });
    const controller = new AbortController();
    setErrors(() => {
      return {
        partneridError: false,
      };
    });
    setFormData((prev) => {
      return {
        ...prev,
        package_partner_name:
          event.target.childNodes[event.target.selectedIndex].getAttribute(
            "value"
          ),
      };
    });

    const getBrands = async () => {
      let URL =
        process.env.REACT_APP_GET_BRAND_TREE +
        "&partner_id=" +
        event.target.childNodes[event.target.selectedIndex].getAttribute(
          "partnerid"
        );
      try {
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        if (response?.data?.status == "200") {

          let brand_tree = response?.data?.response?.data?.brand_tree;
          if (brand_tree.length > 0) {
            var cloned = brand_tree.slice(0);

            // insert special select all node
            cloned.splice(0, 0, {
              label: "Select All",
              value: "selectAll",
              className: "select-all"
            });
          }
          //            brand_tree.unshift({
          //                label: "Select All",
          //                value: "selectAll",
          //                className: "select-all"
          //            });
          setbrandlist(cloned);
        } else {
          setbrandlist([]);
        }
        setFormData((prev) => {
          return {
            ...prev,
            package_partner_id:
              event.target.childNodes[event.target.selectedIndex].getAttribute(
                "partnerid"
              ),
          };
        });
      } catch (err) {
        console.log(err);
      }
    };
    getBrands();
  };

  const getvehicleVariantid = (event) => {
    seterror(false);
    setErrors(() => {
      return {
        variantidError: false,
      };
    });
    setFormData((prev) => {
      return {
        ...prev,
        // vehicle_model_name:
        //   event.target.childNodes[event.target.selectedIndex].getAttribute(
        //     "value"
        //   ),
        vehicle_variant_id:
          event.target.childNodes[event.target.selectedIndex].getAttribute(
            "variantid"
          ),
        vehicle_variant_name:
          event.target.childNodes[event.target.selectedIndex].getAttribute(
            "value"
          ),
      };
    });
  };

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getAccountTypes = async () => {
      try {
        const userId = {
          user_id: 1,
        };
        const response = await axiosPrivate.post(
          process.env.REACT_APP_GET_ACCOUNT_TYPES_URL,
          userId,
          {
            signal: controller.signal,
          }
        );
        // console.log("ress",response);
        if (response?.data?.status === 200) {
          isMounted &&
            setAccountType(
              response?.data?.response?.data?.package_account_type
            );
        } else {
          console.log(`API Error: ${JSON.stringify(response?.data?.response)}`);
        }
      } catch (err) {
        return responseHandler(err, "NETWORK_ERROR");
      }
    };

    // if (effectRun.current) {
    getAccountTypes();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true;
    };
  }, []);

  return (
    <form style={{ width: "300px" }}>

      <div class="fieldGroup mt-0">
        <label>Account type</label>
        {accountType.length != 0 ? (
          <select
            defaultValue=""
            onChange={(event) => changeAccountType(event)}
          >
            <option>Select Account Type</option>

            {accountType.map((AccountData, i) => (
              <option
                key={i}
                id={AccountData?.package_account_id}
                value={AccountData?.package_account_type}
              >
                {AccountData?.package_account_type}
              </option>
            ))}
          </select>
        ) : (
          <select onChange={(event) => changeAccountType(event)} value="">
            <option value="">Select Account Type</option>
          </select>
        )}
        {errors?.accountTypeError && (
          <div class="alertTxt">
            <span class="error">
              <i class="material-symbols-rounded fill mt-s error mr-4">error</i>
              Account type is Missing
            </span>
          </div>
        )}
      </div>

      <div class="fieldGroup">
        <label>Package category</label>
        <select
          disabled={packages?.length === 0 ? "disabled" : ""}
          onChange={(event) => changePackageName(event)}
        >
          <option
            selected={isselected === true}
            value="Select Package Category"
          >
            Select Package Category
          </option>
          {packages?.map((PackagesData, i) => (
            <option
              id={PackagesData?.package_type_id}
              value={PackagesData?.package_type_name}
              data-package_category_type={PackagesData?.package_category_type}
            >
              {PackagesData?.package_type_name}
            </option>
          ))}
        </select>
        {errors?.packageTypeError && (
          <div class="alertTxt">
            <span class="error">
              <i class="material-symbols-rounded fill mt-s error mr-4">error</i>
              Package Category is Missing
            </span>
          </div>
        )}
      </div>

      {package_account_type_id === "3" || package_account_type_id === "5" ? (
        <>
          <div class="fieldGroup">
            <label>Partner</label>
            <select onChange={(event) => getVehicleBrands(event)}>
              {package_account_type_id === "3" ? (
                <>
                  <option selected={isselected === true}>Select Partner</option>
                  {partnerlist?.map((partnerlist, i) => (
                    <option
                      partnerid={partnerlist?.partner_id}
                      value={partnerlist?.partner_name}
                    >
                      {partnerlist?.partner_name}
                    </option>
                  ))}
                </>
              ) : (
                <>
                  <option selected={isselected === true}>
                    Select Corporate
                  </option>
                  {corporatelist?.map((corporatelist, i) => (
                    <option
                      partnerid={corporatelist?.partner_id}
                      value={corporatelist?.partner_name}
                    >
                      {corporatelist?.partner_name}
                    </option>
                  ))}
                </>
              )}
            </select>
            {errors?.partneridError && (
              <div class="alertTxt">
                <span class="error">
                  <i class="material-symbols-rounded fill mt-s error mr-4">
                    error
                  </i>
                  Partner is missing
                </span>
              </div>
            )}
          </div>
          {brandlist?.length > 0 ?
            (
              <div class="fieldGroup">
                <label>Brands</label>
                {dropdown}

                {errors?.brandidError && (
                  <div class="alertTxt">
                    <span class="error">
                      <i class="material-symbols-rounded fill mt-s error mr-4">
                        error
                      </i>
                      Brand is missing
                    </span>
                  </div>
                )}
              </div>
            ) :
            (
              errors?.brandidError && (
                <div class="fieldGroup">
                  <div class="alertTxt">
                    <span class="error">
                      <i class="material-symbols-rounded fill mt-s error mr-4">
                        error
                      </i>
                      No Brands for selected partner
                    </span>
                  </div>
                </div>
              )
            )
          }
        </>
      ) : (
        <></>
      )}
    </form>
  );
};
export default AccountAndPackageType;
