import React, { useState, useEffect, useRef } from "react";
import findCombination from "../../../utils/find";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import FormMapper from "../../../utils/FormMapper";
import { addOns } from "../../../configuration/addOnConfig";
import { initialStatefields } from "../../../configuration/createPackageFormConfigs";
import { recovery_insurance_category_type } from "../../../configuration/createPackageFormConfigs";
const PackageDetails = ({ formData, setFormData, setPage }) => {
  const [formArray, setFormArray] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const [addOnFromData, setAddOnFormData] = useState([]);
  const extraInfo = {
    formData,
    setPage,
  };

  const [dynamicFormData, setDynamicFormData] = useState({
    id: "dynamic",
    options: [],
  });

  const [packageLinkData, setPackageLinkData] = useState([]);

  useEffect(() => {
    const controller = new AbortController();
    const getFormData = async () => {
      const filteredFields = findCombination(formData, initialStatefields);
      filteredFields?.form?.length > 0
        ? setFormArray(filteredFields)
        : setPage(0);

      if (filteredFields?.dynamic || filteredFields?.addons) {
        const URL = process.env.REACT_APP_URLDYNAMIC;
        const urlDynamic = `${URL}&account_type=${formData.package_account_type_id}`;
        const responseDynamic = await axiosPrivate.get(urlDynamic, {
          signal: controller.signal,
        });
        const urlAddOn = process.env.REACT_APP_URL_ADD_ONS;

        const responseAddons = await axiosPrivate.post(urlAddOn, {
          group_service_type: formData?.package_category_type==recovery_insurance_category_type?"I":"A"
        });

        const [dynamicData, addOnsData] = await Promise.all([
          responseDynamic,
          responseAddons,
        ]);

        setDynamicFormData({
          id: "dynamic",
          options: dynamicData?.data?.response?.data,
        });
        let addon = [];
        addOnsData?.data?.response?.data?.services.map((service, index) => {
          addon = [
            ...addon,
            {
              ...addOns?.[0],
              ...{
                displayLabel: service?.service_name,
                id: "checkbox" +"_"+ service?.service_id,
                name: "radio" +"_"+ service?.service_id,
              },
            },
            {
              ...addOns?.[1],
              ...{
                id: "radio" + "_"+service?.service_id,
                name: "inp" +"_"+ service?.service_id,
                extra: service?.service_name,
              },
            },
            {
              ...addOns?.[2],
              ...{
                id: "inp" +"_"+ service?.service_id,
                extra: service?.service_name,
              },
            },
          ];
        });
        let keyIndex = filteredFields?.form?.findIndex(
          (item) => item.id === "addons"
        );
        if (keyIndex !== -1) {
          keyIndex = keyIndex + 1;
          let formData = [...filteredFields?.form];
          formData?.splice(keyIndex, 0, ...[...addon]);
          setFormArray((prev) => {
            return { ...prev, form: [...formData] };
          });
        }
      }
    };

    // console.log("effect", effectRun.current);
    // if (!effectRun.current) {
    getFormData();
    // }

    return () => {
      controller.abort();
      // effectRun.current = true;
    };
  }, []);

  useEffect(() => {
    const controller = new AbortController();
    const filteredFields = findCombination(formData, initialStatefields);
    filteredFields?.form?.length > 0
      ? setFormArray(filteredFields)
      : setPage(0);
    const getPackages = async () => {
      try {
        const postData = {
          package_account_id: 1,
          package_statuses: [1, 3]
        };
        const url = process.env.REACT_APP_GET_PACKAGES_URL;
        const res = await axiosPrivate.post(url, postData, {
          signal: controller.signal,
        });
        let result = res?.data?.response?.data;
        setPackageLinkData(result?.packages);
      } catch (err) {
        console.log(err);
      }
    };
    let keyIndex = filteredFields?.form?.findIndex(
      (item) => item.object_key === "package_link"
    );
    if (keyIndex !== -1) {
      getPackages();
    }

    return () => {
      controller.abort();
      // effectRun.current = true;
    };
  }, []);

  return (
    <>
      {formArray?.length !== 0 && (
        <FormMapper
          dynamicFormDatas={dynamicFormData}
          addOns={addOnFromData}
          extraInfo={extraInfo}
          formObject={formArray}
          packageLinkData={packageLinkData}
        />
      )}
    </>
  );
};

export default PackageDetails;
