import { useState, useRef } from "react";
import AccountAndPackageType from "./AccountAndPackageType";
import PackageDetails from "./PackageDetails";
import { Link } from "react-router-dom";
import PackageBrandDetails from "../PackageBrandDetails";

const PackageSteps = () => {
  const [page, setPage] = useState(0);
  const Titles = ["Account & Package type", "Package details"];
  const [formData, setFormData] = useState({});
  const [error, seterror] = useState(false);
  const [errors, setErrors] = useState({
    accountTypeError: false,
    packageTypeError: false,
    partneridError: false,
    brandidError: false,
    modelidError: false,
    variantidError: false,
  });
  const Components = [
    <AccountAndPackageType
      formData={formData}
      setFormData={setFormData}
      setPage={setPage}
      error={error}
      seterror={seterror}
      errors={errors}
      setErrors={setErrors}
    />,
    <PackageDetails
      formData={formData}
      setFormData={setFormData}
      setPage={setPage}
    />,
  ];

  const PageDisplay = (page) => {
    return <>{Components[page]}</>;
  };

  const onNext = () => {
    if (
      formData.package_account_type_id === undefined ||
      formData.package_account_type_id === null
    ) {
      setErrors(() => {
        return {
          accountTypeError: true,
        };
      });
    } else if (
      formData.package_id === undefined ||
      formData.package_id === null
    ) {
      setErrors(() => {
        return {
          packageTypeError: true,
        };
      });
    } else if (
      (formData?.package_account_type_id === "3" ||
        formData?.package_account_type_id === "5") &&
      (formData.package_partner_id === undefined ||
        formData.package_partner_id === null)
    ) {
      setErrors(() => {
        return {
          partneridError: true,
        };
      });
    } else if (
      (formData?.package_account_type_id === "3" ||
        formData?.package_account_type_id === "5") &&
      (formData?.vehicle_specs === undefined ||
        formData?.vehicle_specs === null || (formData?.vehicle_specs !== undefined && formData?.vehicle_specs.length <= 0))
    ) {
      setErrors(() => {
        return {
          brandidError: true,
        };
      });
      setPage(0);
      seterror(true);
    } else {
      setPage((currPage) => currPage + 1);
      seterror(false);
    }
  };

  return (
    <div className="border radius formSection">
      <div className="formSteps pad-24">
        <ul>
          {page === 0 ? (
            <li>
              <i>{page + 1}</i>
              <a href="">{Titles[page]}</a>
            </li>
          ) : (
            <li className="previous">
              <i></i>
              <a href="">{Titles[page - 1]}</a>
            </li>
          )}
          {page === 0 ? (
            <li className="next">
              <i>{page + 2}</i>
              <a href="">{Titles[page + 1]}</a>
            </li>
          ) : (
            <li>
              <i>{page + 1}</i>
              <a href="">{Titles[page]}</a>
            </li>
          )}
          {/* <!-- <li className="next"><i>3</i><a href="javascript:void(0);">Next step</a></li> --> */}
        </ul>
      </div>
      <div className="subContent pad-24">
        {page !== 0 && (
          <>
            <div className="heading">
              <i className="material-symbols-rounded grey mt-s">
                arrow_back_ios_new
              </i>
              <Link
                onClick={() => {
                  setPage((currPage) => currPage - 1);
                  setFormData({});
                }}
              >
                Back to account & package type
              </Link>
            </div>

            <div className="pacakgeDetails mt-16 mb-24">
              <div className="dataTable">
                <div>
                  <p>
                    <span>Account type</span>
                    <span>{formData.acccount_type_name}</span>
                  </p>
                  <p>
                    <span>Package category</span>
                    <span>{formData.package_name}</span>
                  </p>
                  {formData.package_account_type_id == 3 ||
                  formData.package_account_type_id == 5 ? (
                    <>
                      <p>
                        <span>
                          {formData.package_account_type_id == 3 && "Partner"}
                          {formData.package_account_type_id == 5 && "Client"}
                        </span>
                        <span>
                          {formData.package_partner_name &&
                            formData.package_partner_name}
                        </span>
                      </p>
                      {formData.vehicle_display_spec && (
                        <>
                        <p>
                          <div className="colItem">Brands/Variants</div>
                          <PackageBrandDetails vehicleSpecifications={formData.vehicle_display_spec} />
                        </p>
                        </>
                      )}
                    </>
                  ) : formData.package_account_type_id == 2 ? (
                    ""
                  ) : (
                    <p>
                      <span>Package type</span>
                      <span>Normal</span>
                    </p>
                  )}

                </div>
              </div>
            </div>
          </>
        )}

        <div className="dForm w300">
          {PageDisplay(page)}
          <br></br>
          <div className="actionButtons">
            <span className="">
              {page < Titles.length - 1 && (
                <button
                  hidden={page === Titles.length - 1}
                  onClick={() => {
                    onNext();
                  }}
                  className="btn prim"
                >
                  Next
                </button>
              )}
              {/* // : ( //{" "}
              <Link onClick={Submit} className="btn prim">
                // Create Package //{" "}
              </Link>
              // )} */}
            </span>
          </div>
        </div>
      </div>
    </div>
  );
};

export default PackageSteps;
