import { Link } from "react-router-dom";
import { useRef } from "react";
import SubMainContainer from "../UI/SubMainContainer";
import { useState } from "react";
import Accounts from "./Accounts";
import SearchBar from "../UI/SearchBar/SearchBar";
import Button from "../UI/Button";
import useAuth from "../../hooks/useAuth";
const PackagesListPageContent = () => {
  const [searchValue, setSearchValue] = useState("");
  const inputElement = useRef();
  const { auth } = useAuth();
  return (
    <SubMainContainer SubMainContainerCustomClass="rightCol">
      <div className="contentContainer">
        <h2>Packages</h2>
        <div className="searchPanel">
          <SearchBar
            placeholder={"Search plan by name"}
            setSearchValue={setSearchValue}
            searchValue={searchValue}
            inputElement={inputElement}
          />
          {auth.priviliges.includes("write_package") &&
            <Button
              value={"Create new package"}
              btn_link={"/packages/createPackage"}
            />}
        </div>
        <SubMainContainer SubMainContainerCustomClass="subContent">
          <Accounts searchValue={searchValue} />
        </SubMainContainer>
      </div>
    </SubMainContainer>
  );
};

export default PackagesListPageContent;
