import React from "react";
import { HourMapping } from "../../configuration/createPackageFormConfigs";
import moment from "moment";
import PackageStatus from "./PackageStatus";
import useAuth from "../../hooks/useAuth";
export default function RecoveryInsuranceTile({
  detailsItem,
  statusHandler,
  inactive,
  setInactive,
  deletePackage,
  i,
  status,
}) {
  const { auth } = useAuth();
  return (
    <>
      <div class="head">
        <p>
          <span>{detailsItem?.package_name}</span>
          {detailsItem?.package_price.slice(0, 1) != 0 && (
            <span>Price- ${detailsItem?.package_price}</span>
          )}
        </p>
        <ul class="tabsList">
          <li>
            {detailsItem?.maximum_booking_allowed}{" "}
            services
          </li>
          <li>
            {detailsItem?.package_duration && detailsItem?.package_duration}
            {HourMapping?.[detailsItem?.package_duration_unit]}
            {detailsItem?.package_duration > 1 && "s"}
            &nbsp;validity
          </li>
        </ul>
        {auth.priviliges.includes("write_package") && (
          <div className="actionNav">
            <i
              className="material-symbols-rounded mt-m grey"
              onMouseOver={statusHandler}
              id={detailsItem?.package_id}
            >
              more_vert
            </i>
            {status[detailsItem?.package_id] ? (
              <PackageStatus
                id={detailsItem?.package_id}
                packageStatus={detailsItem?.package_status}
                packageId={detailsItem?.package_id}
                setInActive={setInactive}
                inActive={inactive}
                package_type_id={detailsItem?.package_type_id}
                package_index={i}
                deletePackage={deletePackage}
                package_account_id={detailsItem?.package_account_id}
                package_name={detailsItem?.package_name}
              />
            ) : (
              ""
            )}
          </div>
        )}
      </div>
      <div class="dataTable">
        <div>
          <p>
            <span>Starts from</span>
            <span>{moment(detailsItem?.package_created_at).format('DD MMM YYYY')}</span>
          </p>

          {detailsItem?.services&&detailsItem?.services?.length>"0"&&detailsItem?.services.map((service)=>{
            return(<>
               <p key={service.service_id}>
            <span>{service?.service_name}</span>
            <span>{service?.service_admin_note}</span>
          </p>
            </>)
          })}
          <p>
            <span>Auto renew</span>
            <span>{detailsItem?.package_auto_renew ==="1"? "Yes" : "No"}</span>
          </p>
        </div>
      </div>
    </>
  );
}
