import React from "react";
import { useState, useEffect } from "react";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import CreateNewPuppy from "./CreatePuppy/CreateNewPuppy";
import useOutsideClick from "../../hooks/useOutsideClick";
import { useRef } from "react";
import Error from "../UI/Error";
import Success from "../UI/Success";
import Spinner from "../UI/Spinner";

const AssignAttenDant = ({
  onBackdropClick,
  puppy,
  showPopUP,
  index,
  puppyInfo,
}) => {
 
  const [driverInfo, setDriverInfo] = useState();
  const [attendantName, setAttenDantName] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [closeDropDown, setCloseDropDown] = useState(false);
  const [loading, setLoading] = useState(false);
  const [attendentDetails, setAttendentDetails] = useState({
    firstname: "",
    lastname: "",
    phone: "",
  });

  const [id, setId] = useState("");
  const [showSelectAttendant, setShowSelectAttendant] = useState({
    selectAttendant: false,
  });
  const assignAttendantRef = useRef();
  const [userId, setUserId] = useState("");
  const handelClose = () => {
    onBackdropClick();
  };
  useOutsideClick(assignAttendantRef, () => {
    setShowSelectAttendant({
      selectAttendant: !showSelectAttendant,
    });
  });
  const handelAttendant = (e, fname, lname, phoneNo, id) => {
    setErrorMessage("");
    setAttendentDetails({
      firstname: fname,
      lastname: lname,
      phone: phoneNo,
    });

    setAttenDantName(e.target.id);
    setUserId(id);
    setShowSelectAttendant((prev) => ({
      ...prev,
      selectAttendant: false,
    }));
  };
  const handeldropDown = (e) => {
    setShowSelectAttendant({
      [e.currentTarget.id]: !showSelectAttendant[e.currentTarget.id],
    });
  };
  const axiosPrivate = useAxiosIntercept();
  useEffect(() => {
  setLoading(true)
    let isMounted = true;
    const controller = new AbortController();
    const getDrivers = async () => {
      let URL = process.env.REACT_APP_DRIVERS_INFO_URL+"&limit=1000";

      try {
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        setLoading(false);
        isMounted && setDriverInfo(response?.data?.response?.data?.user_info);
        //setTotalRecords(response?.data?.response?.data?.total_records);
      } catch (err) {
        console.log(err);
        // navigate("/", { state: { from: location }, replace: true });
      }
    };
    getDrivers();
    return () => {
      isMounted = false;
      controller.abort();
    };
  }, []);

  // temp[index.i]["driver_info"]["driver_status"] = "";
  const handelAssignAttendant = async (e) => {
    setLoading(true);
    const assignAttendantRequest = {
      user_id: userId,
      vehicle_id: puppy.vehicle_id,
    };
    const assignAttendantUrl = process.env.REACT_APP_ASSIGN_ATTENDANT;

    const assignAttendantResponse = await axiosPrivate.post(
      assignAttendantUrl,
      assignAttendantRequest
    );
    if (assignAttendantResponse?.data?.status === 200) {
      setLoading(false);
      setErrorMessage("");
      setAttenDantName("");
      setSuccessMessage(assignAttendantResponse?.data?.message);
      setTimeout(() => {
        const temp = [...puppyInfo];
     
     
        temp[index.i]["driver_info"]["driver_status"] = "A";
        temp[index.i]["driver_info"]["driver_status_description"] = "Assigned";
        temp[index.i]["driver_info"]["first_name"] = attendentDetails.firstname;
        temp[index.i]["driver_info"]["last_name"] = attendentDetails.lastname;
        temp[index.i]["driver_info"]["phone"] = attendentDetails.phone;
       
        // setSuccess(!success);
        onBackdropClick();
      }, 3000);
    } else {
      setLoading(false);
      setErrorMessage(
        assignAttendantResponse?.data?.response?.errors[0].message
      );
      setAttenDantName("");
    }
  };

  return showPopUP ? (
    <Overlay onBackdropClick={onBackdropClick}>
      {
        loading==true&&<Spinner/>
      }
      <div
        class="model_box_child assignAttendant"
        id="assignAttendant"
        style={{ width: "300px" }}
      >
        <div class="ap_heading">
          <h4>
            Assign attendant{" "}
            <span
              style={{ marginLeft: "auto" }}
              class="material-symbols-rounded black close_model"
              onClick={handelClose}
            >
              close
            </span>
          </h4>
        </div>
        <div class="contentSection" style={{ paddingTop: "24px" }}>
          <section class="assignPromoP dForm">
            <div class="promoText customer">
              <h4>{puppy.registration_no}</h4>
              <p>{puppy.brand_name}</p>
            </div>
            <div class="fieldGroup" ref={assignAttendantRef}>
              <label>Select attendant</label>
              <div
                class="multiOption"
                id="selectAttendant"
                onClick={(e) => handeldropDown(e)}
              >
                <div
                  class={
                    showSelectAttendant.selectAttendant
                      ? "selectBox open"
                      : "selectBox"
                  }
                >
                  <p>
                    {attendantName ? attendantName : "select Attendant"}
                    <i class="material-symbols-rounded grey">expand_more</i>
                  </p>
                  <div class="selectDrop customScroll hFix">
                    <ul class="dropMenu">
                      {driverInfo ? (
                        driverInfo.map((driverDetails) => {
                          return (
                            <li
                              className={
                                userId === driverDetails.user_id
                                  ? "selected"
                                  : ""
                              }
                            >
                              <a
                                id={driverDetails.firstname}
                                onClick={(e) =>
                                  handelAttendant(
                                    e,
                                    driverDetails.firstname,
                                    driverDetails.lastname,
                                    driverDetails.phone,
                                    driverDetails.user_id
                                  )
                                }
                              >
                                {driverDetails.firstname}
                                {userId === driverDetails.user_id ? (
                                  <>
                                    <i className="material-symbols-rounded">
                                      done
                                    </i>
                                  </>
                                ) : (
                                  <></>
                                )}
                              </a>
                            </li>
                          );
                        })
                      ) : (
                        <></>
                      )}
                    </ul>
                  </div>

                  {errorMessage ? (
                    <>
                      <Error error={errorMessage} />
                    </>
                  ) : (
                    ""
                  )}
                </div>
              </div>
            </div>
          </section>
          <div class="actionButtons mt-24">
            <span>
              <a
                onClick={(e) => handelAssignAttendant(e)}
                href="javascript:void(0);"
                class="btn prim fullW"
              >
                Assign attendant
              </a>
            </span>
          </div>

          {successMessage ? (
            <>
              <Success success={successMessage} />
            </>
          ) : (
            ""
          )}
        </div>
      </div>
    </Overlay>
  ) : (
    <></>
  );
};

export default AssignAttenDant;
