import React from "react";
import { useEffect, useRef } from "react";
import Overlay from "../../../utils/Overlay";
import { useFormInputValidation } from "react-form-input-validation";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import { useState } from "react";

import Error from "../../UI/Error";
import Success from "../../UI/Success";

const CreateNewPuppy = ({
  onBackdropClick,
  openAddPuppyForm,
  puppyDetails,
  setPuppyDetails,
  isSuccess,
  setisSuccess,
  isPuppyCreated,
  setisPuppyCreated,
}) => {
  const [isValidForm, setIsValidForm] = useState(false);
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const vehicleBrandRef = useRef();
  const vehicleModelRef = useRef();
  const vehicleVariantRef = useRef();
  const [fields, errors, form] = useFormInputValidation(
    {
      vehicleNumber: "",
      batteryType: "",
      chargerNumber: "",
      batteryCapacity: "",
    },
    {
      vehicleNumber: "required",
      batteryType: "required",
      chargerNumber: "required|min:0",
      batteryCapacity: "required|numeric|min:0",
    }
  );
  const axiosPrivate = useAxiosIntercept();
  const [brandList, setBrandList] = useState([]);
  const [brandValue, setBrandValue] = useState("");

  const [vehicleDetails, setVehicleDetails] = useState({
    brandId: 0,
    modelId: 0,
    variantId: 0,
  });
  const [dropdownError, setDropdownError] = useState({
    brandError: "",
    modelError: "",
    variantError: "",
  });

  const [modelList, setModelList] = useState([]);
  const [modelValue, setModelValue] = useState("");
  const [error, setError] = useState("");
  const [variantList, setVariantList] = useState([]);
  const [variantValue, setVariantValue] = useState("");
  const [dropDownValue, setDropDownValue] = useState({
    vehicleBrand: false,
    vehicleModel: false,
    vehicleVariant: false,
  });
  const handelDropdown = (e) => {
    if (e.currentTarget.id !== undefined) {
      setDropDownValue({
        [e.currentTarget.id]: !dropDownValue[e.currentTarget.id],
      });
    } else {
      setDropDownValue({ vehicleBrand: false });
      setDropDownValue({ vehicleModel: false });
      setDropDownValue({ vehicleVariant: false });
    }
  };
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (
        vehicleBrandRef.current &&
        !vehicleBrandRef.current.contains(event.target) &&
        (vehicleModelRef.current === undefined ||
          (vehicleModelRef.current &&
            !vehicleModelRef.current.contains(event.target) &&
            (vehicleVariantRef.current == undefined ||
              (vehicleVariantRef.current &&
                !vehicleVariantRef.current.contains(event.target)))))
      ) {
        handelDropdown(event);
      }
    };
    document.addEventListener("click", handleClickOutside, true);
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  }, []);
  const handelbrandValue = (e, id) => {
    setDropDownValue((prev) => ({
      ...prev,
      vehicleBrand: false,
    }));
    setBrandValue(e.target.id);
    setModelValue("");
    setVariantValue("");

    // setBrandId(id);
    setVehicleDetails((prev) => ({
      ...prev,
      brandId: id,
      variantId: 0,
      modelId: 0,
    }));
  };
  const handelVariantValue = (e, id) => {
    setVariantValue(e.target.id);
    setDropDownValue((prev) => ({
      ...prev,
      vehicleVariant: false,
    }));
    //setBrandId(id);
    setVehicleDetails((prev) => ({ ...prev, variantId: id }));
  };
  const handelModelValue = (e, id) => {
    setModelValue(e.target.id);
    setVehicleDetails((prev) => ({ ...prev, modelId: id, variantId: 0 }));

    setVariantValue("");

    setDropDownValue((prev) => ({
      ...prev,
      vehicleModel: false,
    }));
  };
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    const getPuppy = async () => {
      let URL = process.env.REACT_APP_GET_BRAND_LIST;
      let varientModelUrl = process.env.REACT_APP_GET_VEHICLE_BRAND_MODEL_LIST;

      try {
        const response = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });

        if (brandValue != "") {
          varientModelUrl = `${varientModelUrl}&brand_id=${vehicleDetails.brandId}&variants=false`;
          const modelResponse = await axiosPrivate.get(
            varientModelUrl
            // modelRequest
          );

          setModelList(modelResponse?.data?.response?.data?.models);
        }

        if (modelValue != "") {
          varientModelUrl = `${varientModelUrl}&model_id=${vehicleDetails.modelId}&variants=true`;
          const VariantResponse = await axiosPrivate.get(varientModelUrl);

          setVariantList(
            VariantResponse?.data?.response?.data?.models[0].variants
          );
        }

        isMounted &&
          setBrandList(response?.data?.response?.data?.brand_details);
      } catch (err) {
        //seterror(err);
      }
    };

    getPuppy();
    // }

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [brandValue, modelValue, variantValue]);

  useEffect(() => { }, [dropdownError, isValidForm]);

  const submit = async (e) => {
    e.preventDefault();

    Object.keys(errors).forEach((i) => (errors[i] = null));
    const brandErr = "";
    const modelError = "";
    const variantError = "";

    setDropdownError({
      brandError: brandErr,
      modelError: modelError,
      variantError: variantError,
    });

    setError("");
    const isValid = await form.validate(e);
    if (vehicleDetails.brandId === 0) {
      setDropdownError((prev) => ({
        ...prev,
        brandError: "please select vehicle brand",
      }));
    } else if (vehicleDetails.modelId === 0) {
      setDropdownError((prev) => {
        return {
          ...prev,
          modelError: "please select vehicle model",
        };
      });
    } else if (vehicleDetails.variantId === 0) {
      setDropdownError((prev) => {
        const variantError = "please select vehicle variant";
        return {
          ...prev,
          variantError: variantError,
        };
      });
    } else {
    }

    if (isValid && vehicleDetails.variantId != 0) {

      setIsValidForm(isValid);

      Object.keys(errors).forEach((i) => (errors[i] = null));
      setError("");

      const createPuppyRequest = {
        registration_no: `${fields.vehicleNumber}`,
        battery_type: `${fields.batteryType}`,
        total_charging_capacity: `${fields.batteryCapacity}`,
        variant_id: `${vehicleDetails.variantId}`,
        serial_number: `${fields.chargerNumber}`,
      };

      let createPuppy = process.env.REACT_APP_ADD_NEW_PUPPPY;
      let createPuppyResponse = await axiosPrivate.post(
        createPuppy,
        createPuppyRequest
      );

      if (createPuppyResponse?.data?.status == 200) {
        Object.keys(errors).forEach((i) => (errors[i] = null));
        // );

        setSuccessMessage("");
        seterrorMessage("");
        setSuccessMessage(createPuppyResponse?.data?.message);
        setTimeout(() => {
          onBackdropClick();
          setisSuccess(!isSuccess);
          setisPuppyCreated(true);
          // window.location.reload();
        }, 3000);
      } else {
        setSuccessMessage("");
        seterrorMessage("");
        seterrorMessage(createPuppyResponse?.data?.response?.errors[0].message);
      }
    } else {
      setIsValidForm(false);
    }
  };
  const closeAddPuppyForm = () => {
    onBackdropClick();
  };

  return openAddPuppyForm ? (
    <>
      <Overlay onBackdropClick={onBackdropClick}>
        <form onSubmit={submit}>
          <div
            class="model_box_child addPuppy"
            id="addPuppy"
            style={{ width: "300px" }}
          >
            <div class="ap_heading">
              <h4>
                Add new puppy{" "}
                <span
                  style={{ marginLeft: "auto" }}
                  onClick={closeAddPuppyForm}
                  class="material-symbols-rounded black close_model"
                >
                  close
                </span>
              </h4>
            </div>
            <div class="contentSection" style={{ paddingTop: "24px" }}>
              <section class="assignPromoP dForm">
                <div class="fieldGroup mt-0">
                  <label>Vehicle number</label>
                  <span className={errors.vehicleNumber ? "error" : ""}>
                    <input
                      type="text"
                      placeholder="Enter vehicle number"
                      name="vehicleNumber"
                      onChange={form.handleChangeEvent}
                      value={fields.vehicleNumber}
                    />
                  </span>
                  {errors.vehicleNumber && (
                    <Error error={errors.vehicleNumber} />
                  )}
                </div>

                <div class="fieldGroup">
                  <label>Puppy vehicle brand</label>
                  <div class="multiOption">
                    <div
                      ref={vehicleBrandRef}
                      id="vehicleBrand"
                      onClick={(e) => handelDropdown(e)}
                      className={
                        dropDownValue.vehicleBrand
                          ? "selectBox fullWidth open"
                          : "selectBox fullWidth"
                      }
                    >
                      <p>
                        {brandValue ? brandValue : "select vehicle brand"}
                        <i class="material-symbols-rounded grey">expand_more</i>
                      </p>
                      <div class="selectDrop customScroll hFix">
                        <ul class="dropMenu">
                          {brandList ? (
                            brandList.map((brandDetails, i) => {
                              return (
                                <li
                                  className={
                                    brandValue === brandDetails.name
                                      ? "selected"
                                      : ""
                                  }
                                >
                                  <a
                                    id={brandDetails.name}
                                    onClick={(e) =>
                                      handelbrandValue(e, brandDetails.id)
                                    }
                                    href="javascript:void(0);"
                                  >
                                    {brandDetails.name}
                                    {brandValue === brandDetails.name ? (
                                      <i className="material-symbols-rounded">
                                        done
                                      </i>
                                    ) : (
                                      <></>
                                    )}
                                  </a>
                                </li>
                              );
                            })
                          ) : (
                            <></>
                          )}
                        </ul>
                      </div>
                    </div>
                  </div>
                  {brandValue == "" && dropdownError.brandError && (
                    <Error error={dropdownError.brandError} />
                  )}
                </div>
                {brandValue ? (
                  <>
                    <div class="fieldGroup">
                      <label>Puppy vehicle model</label>
                      <div class="multiOption">
                        <div
                          ref={vehicleModelRef}
                          id="vehicleModel"
                          onClick={(e) => handelDropdown(e)}
                          className={
                            dropDownValue.vehicleModel
                              ? "selectBox fullWidth open"
                              : "selectBox fullWidth"
                          }
                        >
                          <p>
                            {modelValue ? modelValue : "Select vehicle model"}

                            <i class="material-symbols-rounded grey">
                              expand_more
                            </i>
                          </p>
                          <div class="selectDrop customScroll hFix">
                            <ul class="dropMenu">
                              {modelList ? (
                                modelList.map((modelDetails) => {
                                  return (
                                    <li
                                      className={
                                        modelValue === modelDetails.name
                                          ? "selected"
                                          : ""
                                      }
                                    >
                                      <a
                                        id={modelDetails.name}
                                        onClick={(e) =>
                                          handelModelValue(e, modelDetails.id)
                                        }
                                      >
                                        {modelDetails.name}
                                        {modelValue === modelDetails.name ? (
                                          <i className="material-symbols-rounded">
                                            done
                                          </i>
                                        ) : (
                                          <></>
                                        )}
                                      </a>
                                    </li>
                                  );
                                })
                              ) : (
                                <></>
                              )}
                            </ul>
                          </div>
                        </div>
                      </div>
                      {modelValue == "" && dropdownError.modelError && (
                        <Error error={dropdownError.modelError} />
                      )}
                    </div>
                  </>
                ) : (
                  <></>
                )}

                {modelValue ? (
                  <>
                    <div class="fieldGroup">
                      <label>Puppy vehicle Variant</label>
                      <div class="multiOption">
                        <div
                          ref={vehicleVariantRef}
                          id="vehicleVariant"
                          onClick={(e) => handelDropdown(e)}
                          className={
                            dropDownValue.vehicleVariant
                              ? "selectBox fullWidth open"
                              : "selectBox fullWidth"
                          }
                        >
                          <p>
                            {variantValue
                              ? variantValue
                              : "Select vehicle variant"}

                            <i class="material-symbols-rounded grey">
                              expand_more
                            </i>
                          </p>
                          <div class="selectDrop customScroll hFix">
                            <ul class="dropMenu">
                              {/* <li class="selected">
                                <a href="javascript:void(0);">
                                  Vehicle variant 1
                                  <i class="material-symbols-rounded">done</i>
                                </a>
                              </li> */}
                              {/* <li>
                                <a
                                  id=""
                                  onClick={(e) =>
                                    handelVariantValue(e, variantDetails.id)
                                  }
                                >
                                  {variantDetails.name}
                                </a>
                              </li> */}
                              {variantList ? (
                                variantList.map((variantDetails) => {
                                  return (
                                    <li
                                      className={
                                        variantValue === variantDetails.name
                                          ? "selected"
                                          : ""
                                      }
                                    >
                                      <a
                                        id={variantDetails.name}
                                        onClick={(e) =>
                                          handelVariantValue(
                                            e,
                                            variantDetails.id
                                          )
                                        }
                                      >
                                        {variantDetails.name}
                                        {variantValue ===
                                          variantDetails.name ? (
                                          <i className="material-symbols-rounded">
                                            done
                                          </i>
                                        ) : (
                                          <></>
                                        )}
                                      </a>
                                    </li>
                                  );
                                })
                              ) : (
                                <></>
                              )}
                            </ul>
                            {error && <Error error={error} />}
                          </div>
                        </div>
                      </div>
                      {variantValue == "" && dropdownError.variantError && (
                        <Error error={dropdownError.variantError} />
                      )}
                    </div>
                  </>
                ) : (
                  <></>
                )}
                <div class="fieldGroup">
                  <label>Battery type</label>
                  <ul class="xType">
                    <li>
                      <input
                        type="radio"
                        id="yTypeRadio1"
                        name="batteryType"
                        onChange={form.handleChangeEvent}
                        value="R"
                      />
                      <label for="yTypeRadio1">Fixed</label>
                    </li>
                    <li>
                      <input
                        type="radio"
                        id="yTypeRadio2"
                        name="batteryType"
                        onChange={form.handleChangeEvent}
                        value="S"
                      />

                      <label for="yTypeRadio2">Swapable</label>
                    </li>
                  </ul>
                  {errors.batteryType && <Error error={errors.batteryType} />}
                </div>
                <div class="fieldGroup">
                  <label>Charger identifier number</label>
                  <span className={errors.chargerNumber ? "error" : ""}>
                    <input
                      type="text"
                      placeholder="Enter charger identifier number"
                      name="chargerNumber"
                      onChange={form.handleChangeEvent}
                      value={fields.chargerNumber}
                    />
                  </span>
                  {errors.chargerNumber && (
                    <Error error={errors.chargerNumber} />
                  )}
                </div>
                <div class="fieldGroup">
                  <label>Battery capacity</label>
                  <div class="multiOption">
                    <input
                      type="text"
                      placeholder="Enter battery capacity"
                      name="batteryCapacity"
                      onChange={form.handleChangeEvent}
                      value={fields.batteryCapacity}
                    />
                    <div class="sepText bg">
                      <span>kWH</span>
                    </div>
                  </div>
                  {errors.batteryCapacity && (
                    <Error error={errors.batteryCapacity} />
                  )}
                </div>
              </section>
              <div class="actionButtons mt-24">
                <span>
                  <button
                    type="submit"
                    href="javascript:void(0);"
                    class="btn prim fullW"
                  >
                    Add vehicle
                  </button>
                </span>
                {successMessage ? <Success success={successMessage} /> : <></>}
                {errorMessage ? <Error error={errorMessage} /> : <></>}
              </div>
            </div>
          </div>
        </form>
      </Overlay>
    </>
  ) : (
    <></>
  );
};

export default CreateNewPuppy;
