import { useState, useEffect, useRef } from "react";

import usePaginate from "../../hooks/usePaginate";
import useHttp from "../../hooks/useHttp";
import PartnerListing from "../Customer/Partner/PartnerListing";
import SearchBar from "../UI/SearchBar/SearchBar";
import Button from "../UI/Button";
import PuppyListing from "./PuppyListing";
import PuppySummary from "./PuppySummary";
import NoData from "../UI/NoData";
import Loading from "../UI/Loading";
import useAuth from "../../hooks/useAuth";

const perPageLimit = 10;

function PuppyInfoNew({
  searchValue,
  setSearchValue,
  pageNumber,
  setPageNumber,
  partnerDetails,
  setPartnerDetails,
  puppyInfo,
  setPuppyInfo,
}) {
  const { auth } = useAuth();
  const [searchText, setSearchText] = useState("");
  const search_keyword = searchValue;
  const [error, seterror] = useState("");
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [vehicleStatusValue, setvehicleStatusValue] = useState("");
  const [batteryTypeValue, setBatteryTypeValue] = useState("");
  const [attendantStatusValue, setAttendantStatusValue] = useState("");
  const [puppySummary, setPuppySummary] = useState({});
  const [openAddPuppyForm, setOpenAddPuppyForm] = useState(false);
  const vehicleStatusref = useRef();
  const batteryTypeRef = useRef();
  const attendantStatusRef = useRef();
  const [isSuccess, setisSuccess] = useState();
  const [isPuppyCreated, setisPuppyCreated] = useState(false);
  const prevSuccess = useRef({ isPuppyCreated }).current;
  const prevIsSuccess = useRef({ isSuccess }).current;

  const [open, setOpen] = useState(false);

  const [hasMore, setHasMore] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const [selectedUser, setSelectedUser] = useState(null);
  const [filteredValue, setValue] = useState("");
  const [showFilter, setShowFilter] = useState(false);
  const search_by = "registration_no";
  const [success, setSuccess] = useState(false);
  const onBackdropClick = () => {
    //setOpenAddPuppyForm(false);
    openAddPuppyForm = false;
  };

  useEffect(() => {
    const handleClickOutside = (event) => {
      if (
        vehicleStatusref.current &&
        !vehicleStatusref.current.contains(event.target) &&
        batteryTypeRef.current &&
        !batteryTypeRef.current.contains(event.target) &&
        attendantStatusRef.current &&
        !attendantStatusRef.current.contains(event.target)
      ) {
        handelFilter(event);
      }
    };
    document.addEventListener("click", handleClickOutside, true);
    return () => {
      document.removeEventListener("click", handleClickOutside, true);
    };
  });
  const closeDropdown = () => {
    setShowFilter({ vehicleStatus: false });
    setShowFilter({ batteryType: false });
    setShowFilter({ attendantStatus: false });
  };
  const handelForm = () => {
    setOpenAddPuppyForm(true);
  };
  const handelFilter = (e) => {
   
    if (e.currentTarget.id !== undefined) {
      setShowFilter({ [e.currentTarget.id]: !showFilter[e.currentTarget.id] });
    } else {
      setShowFilter({ vehicleStatus: false });
      setShowFilter({ batteryType: false });
      setShowFilter({ attendantStatus: false });
    }
  };

  const handelVehicleStatusValue = (e) => {
    // setvehicleStatusValue("");
    // setIsClicked(!isClicked);
  
   
    
       setvehicleStatusValue(e.currentTarget.id);
    
  
    { e.currentTarget.id != vehicleStatusValue && setPuppyInfo([]) };
    setPageNumber(1);
   
    setShowFilter((prev) => ({
      ...prev,
      vehicleStatus: false,
    }));
  };
  const handelBatteryTypeValue = (e) => {
      // setIsClicked(!isClicked);
    setPageNumber(1);
    {e.currentTarget.id!=batteryTypeValue&&setPuppyInfo([]); }
    setBatteryTypeValue(e.currentTarget.id);
    setShowFilter((prev) => ({
      ...prev,
      batteryType: false,
    }));
  };
  const handelAttendantStatusValue = (e) => {
      // setIsClicked(!isClicked);
    setPageNumber(1);
       {e.currentTarget.id!=attendantStatusValue&&setPuppyInfo([]); }
    setAttendantStatusValue(e.currentTarget.id);
    setShowFilter((prev) => ({
      ...prev,
      attendantStatus: false,
    }));
  };
  //useEffect(() => {
  let isMounted = true;
  const controller = new AbortController();
  // const getPuppy = async () => {
  let url = process.env.REACT_APP_PUPPY_INFO_URL + "&show_all=true";
 

  if (searchValue === "") {
    url = url + `&page=${pageNumber}&limit=${perPageLimit}&show_charger_info=1`;
  }
  if (searchValue != "") {
    url =
      url +
      `&search_by=${search_by}&search_keyword=${searchValue}&page=${pageNumber}&limit=${perPageLimit}&show_charger_info=1`;
  }
  if (vehicleStatusValue === "D") {
    url =
      url +
      `&status=${vehicleStatusValue}&battery_type=${batteryTypeValue}&driver_status=${attendantStatusValue}&show_charger_info=1`;
  }
  if (
    (vehicleStatusValue != "" && vehicleStatusValue !== "D") ||
    batteryTypeValue != "" ||
    attendantStatusValue != ""
  ) {
    url =
      url +
      `&puppy_status=${vehicleStatusValue}&battery_type=${batteryTypeValue}&driver_status=${attendantStatusValue}&show_charger_info=1`;
  }

  const { isLoading, sendRequest: getusers } = useHttp();

  const { lastElementRef } = usePaginate(isLoading, hasMore, setPageNumber);
 
  useEffect(() => {
   
   
    const setSearchedusers = (searchedUsers) =>
    {
    
      const { data } = searchedUsers?.data?.response;
    

      if (data?.puppy_vehicles) {
         
        if (prevSuccess.isPuppyCreated != isPuppyCreated || prevIsSuccess.isSuccess != isSuccess) {
          
          setPuppyInfo(() => {
            return [...new Set([...data?.puppy_vehicles])];
          });
        } else {

          setPuppyInfo((prev) => {
            return [...new Set([...prev, ...data?.puppy_vehicles])];
          });
          setTotalRecords(data?.total);
          setisPuppyCreated(false);
        }
      } else {

        setPuppyInfo({});
      }
      setPuppySummary(data?.puppy_summary);

      if (data?.total == data?.puppy_vehicles?.length) {
        setHasMore(false);
      } else {
        setHasMore(searchedUsers.data.response.data?.puppy_vehicles.length > 0);
      }
    };
   
   
    if (
      pageNumber == 1 ||
      Math.ceil(parseInt(total_records) / perPageLimit) >= pageNumber
    ) {
   
      getusers(
        {
          url,
        },

        setSearchedusers
      );
    }
  },
[
    vehicleStatusValue,
    batteryTypeValue,
    attendantStatusValue,
    url,
    pageNumber,
  isSuccess,
  
    getusers,
  ]);

  const confirmUser = (user) => {
    setShowModal(true);
    setSelectedUser(user);
  };

  return (
    <div className="App">
      <>
        <PuppySummary puppySummary={puppySummary} />
        <div className="searchPanel ">
          <SearchBar
            pageNumber={pageNumber}
            setPageNumber={setPageNumber}
            puppyInfo={puppyInfo}
            setData={setPuppyInfo}
            setSearchValue={setSearchValue}
            searchValue={searchValue}
            placeholder={"Search puppy by vehicle number"}
          />
          {auth.priviliges.includes("write_puppy") &&
            <Button value={"Add new puppy"} click={handelForm} />}
        </div>


        <div className="searchPanel mb-24 mt-24 puppyFilter">
          <div className="multiOption columType">
            <h5 className="mb-8">Filter by</h5>
            <div
              id="vehicleStatus"
              className={
                showFilter.vehicleStatus ? "selectBox open" : "selectBox"
              }
              onClick={(e) => handelFilter(e)}
              ref={vehicleStatusref}
            >
              <p className="selected">
                {vehicleStatusValue
                  ?
                  vehicleStatusValue === "A"
                    ? "Booking assigned"
                    : "" || vehicleStatusValue === "F"
                      ? "Free"
                      : "" || vehicleStatusValue === "D"
                        ? "Inactive"
                        : "At charging station"
                  : "Vehicle status"}

                <i className="material-symbols-rounded grey">expand_more</i>
              </p>
              {showFilter.vehicleStatus ? (
                <div className="selectDrop customScroll hFix">
                  <ul className="dropMenu">
                    <li className={vehicleStatusValue == "" ? "selected" : ""}>
                      <a id="" onClick={(e) => handelVehicleStatusValue(e)}>
                        All
                        {vehicleStatusValue === "" ? (
                          <i className="material-symbols-rounded">done</i>
                        ) : (
                          <></>
                        )}
                      </a>
                    </li>
                    <li
                      className={vehicleStatusValue === "A" ? "selected" : ""}
                    >
                      <a id="A" onClick={(e) => handelVehicleStatusValue(e)}>
                        Booking assigned
                        {vehicleStatusValue === "A" ? (
                          <i className="material-symbols-rounded">done</i>
                        ) : (
                          <></>
                        )}
                      </a>
                    </li>
                    <li
                      className={vehicleStatusValue === "F" ? "selected" : ""}
                    >
                      <a onClick={(e) => handelVehicleStatusValue(e)} id="F">
                        Free
                        {vehicleStatusValue === "F" ? (
                          <i className="material-symbols-rounded">done</i>
                        ) : (
                          <></>
                        )}
                      </a>
                    </li>
                    <li
                      className={vehicleStatusValue === "C" ? "selected" : ""}
                    >
                      <a onClick={(e) => handelVehicleStatusValue(e)} id="C">
                        At charging station
                        {vehicleStatusValue === "C" ? (
                          <i className="material-symbols-rounded">done</i>
                        ) : (
                          <></>
                        )}
                      </a>
                    </li>

                    <li
                      className={vehicleStatusValue === "D" ? "selected" : ""}
                    >
                      <a id="D" onClick={(e) => handelVehicleStatusValue(e)}>
                        Inactive
                        {vehicleStatusValue === "D" ? (
                          <i className="material-symbols-rounded">done</i>
                        ) : (
                          <></>
                        )}
                      </a>
                    </li>
                  </ul>
                </div>
              ) : (
                <></>
              )}
            </div>
          </div>
          <div className="multiOption columType">
            <div
              id="batteryType"
              onClick={handelFilter}
              className={
                showFilter.batteryType ? "selectBox open" : "selectBox"
              }
              ref={batteryTypeRef}
            >
              <p className="selected">
                {batteryTypeValue
                  
                  ?batteryTypeValue==""?"Battery type":
                  batteryTypeValue === "S"
                    ? "Swapable"
                    : "Fixed"
                  : "Battery type"}
                <i className="material-symbols-rounded grey">expand_more</i>
              </p>
              <div className="selectDrop customScroll hFix">
                <ul className="dropMenu">
                  <li className={batteryTypeValue === "" ? "selected" : ""}>
                    <a id="" onClick={(e) => handelBatteryTypeValue(e)}>
                      All
                      {batteryTypeValue === "" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li className={batteryTypeValue === "S" ? "selected" : ""}>
                    <a onClick={handelBatteryTypeValue} id="S">
                      Swapable
                      {batteryTypeValue === "S" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li className={batteryTypeValue === "R" ? "selected" : ""}>
                    <a onClick={handelBatteryTypeValue} id="R">
                      Fixed
                      {batteryTypeValue === "R" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
          <div className="multiOption columType">
            <div
              ref={attendantStatusRef}
              onClick={handelFilter}
              id="attendantStatus"
              className={
                showFilter.attendantStatus ? "selectBox open" : "selectBox"
              }
            >
              <p className="selected">
                {attendantStatusValue
                  ?
                  attendantStatusValue === "A"
                    ? "Assigned"
                    : "" || attendantStatusValue === "F"
                      ? "Free"
                      : ""
                  : "Attendant Status"}
                <i className="material-symbols-rounded grey">expand_more</i>
              </p>
              <div className="selectDrop customScroll hFix">
                <ul className="dropMenu">
                  <li className={attendantStatusValue === "" ? "selected" : ""}>
                    <a onClick={handelAttendantStatusValue} id="">
                      All
                      {attendantStatusValue === "" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li
                    className={attendantStatusValue === "A" ? "selected" : ""}
                  >
                    <a onClick={handelAttendantStatusValue} id="A">
                      Assigned
                      {attendantStatusValue === "A" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                  <li
                    className={attendantStatusValue === "F" ? "selected" : ""}
                  >
                    <a onClick={handelAttendantStatusValue} id="F">
                      Free
                      {attendantStatusValue === "F" ? (
                        <i className="material-symbols-rounded">done</i>
                      ) : (
                        <></>
                      )}
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <PuppyListing
          puppyDetails={puppyInfo}
          setPuppyDetails={setPuppyInfo}
          onBackdropClick={onBackdropClick}
          setOpenAddPuppyForm={setOpenAddPuppyForm}
          openAddPuppyForm={openAddPuppyForm}
          success={success}
          setSuccess={setSuccess}
          lastElementRef={lastElementRef}
          puppySummary={puppySummary}
          setPuppySummary={setPuppySummary}
          vehicleStatusValue={vehicleStatusValue}
          isSuccess={isSuccess}
          setisSuccess={setisSuccess}
          isPuppyCreated={isPuppyCreated}
          setisPuppyCreated={setisPuppyCreated}
        />
      </>

      <div>{isLoading && pageNumber != 1 && <Loading />}</div>
      {pageNumber != "1" && pageNumber > Math.ceil(total_records / perPageLimit) && (<NoData />)}
    </div>
  );
}

export default PuppyInfoNew;
