import React from "react";
import { useNavigate } from "react-router-dom";
import Image from "../UI/Image";
import { FormatDate } from "../../utils/FormatDate";
import { unavailable } from "../../configuration/GlobalConfig";
import { useState } from "react";
import AssignAttenDant from "./AssignAttenDant";
import VehicleInActive from "./VehicleInActive";
import { useEffect } from "react";
import CreateNewPuppy from "./CreatePuppy/CreateNewPuppy";
import Spinner from "../UI/Spinner";
import DataNotFound from "../UI/DataNotFound";
import useAuth from "../../hooks/useAuth";
import UpdateBattery from "./UpdateBattery";
const PuppyListing = ({
  puppyDetails,
  setPuppyDetails,
  openAddPuppyForm,
  setOpenAddPuppyForm,
  success,
  setSuccess,
  lastElementRef,
  puppySummary,
  setPuppySummary,
  vehicleStatusValue,
  isSuccess,
  setisSuccess,
  isPuppyCreated,
  setisPuppyCreated,
}) => {

  const { auth } = useAuth();
  // const [puppyDetails, setPuppyDetails] = useState(puppyInfo);
  const [inActiveAttendant, setInActiveAttenDant] = useState(false);
  const [showSubComponent, setshowSubComponent] = useState({
    assignAttendant: false,
    inActive: false,
    vehicle_id: "",
    registration_no: "",
    brand_name: "",
    puppy_status: "",
  });
  const vehicleid = showSubComponent.puppy!=undefined?showSubComponent.puppy.vehicle_id:"";
  // useEffect(() => {
  //   setPuppyDetails(puppyInfo);
  // }, [puppyInfo]);
  const [showPopUP, setShowPopUP] = useState(false);

  const subContent = (
    e,
    puppy,
    
    
    i,
   
  ) => {
  
    setshowSubComponent({
      [e.target.id]: true,
      puppy:puppy,
   
      
      index: { i },
    
    });

 
    setShowPopUP(true);
  };

  const onBackdropClick = (operation_status) => {
    if (operation_status === true) {
      deletePuppyFromListing(vehicleid);
    }
    document.body.classList.remove("hidden");
    setShowPopUP(false);
    setOpenAddPuppyForm(false);

    //setShowDeletePopUP(false);
  };

  const deletePuppyFromListing = (vehicleid) => {
    const id = vehicleid;

    const currentPuppy = [...puppyDetails];

    let index = currentPuppy.findIndex(function (element) {
      if (element.vehicle_id === vehicleid) {
        return true;
      }
    });

    if (index !== -1) {
      currentPuppy.splice(index, 1);
      setPuppyDetails(currentPuppy);
    }
  };
  const [showAssignAttendant, setShowAssignAttendant] = useState(false);
  const navigate = useNavigate();
  return (
    <>
      {puppyDetails == "" ? (
        <Spinner />
      ) : Object.keys(puppyDetails).length !== 0 ? (
        <div className="puppyContent">
          <div class="dataTableDynamic">
            <table>
              <tbody>
                <tr>
                  <th>Vehicle number</th>
                  <th>Added on</th>
                  <th>Battery type</th>
                  <th>Attendant assigned</th>
                  <th>Current location</th>
                  <th>Status</th>
                    {auth.priviliges.includes("write_puppy") && <th>&nbsp;</th>}
                </tr>
                {puppyDetails.map((puppy, i) => {
                  const {
                    registration_no,
                    created_at,
                    puppy_status_description,
                    battery_type,
                    driver_info,
                    vehicle_id,
                    brand_name,
                    charger_info,
                    longitude,
                    latitude,
                    puppy_status,
                    status,
                  } = puppy;
                  if (puppyDetails.length == i + 1) {
                    return (
                      <>
                        <tr ref={lastElementRef} key={i}>
                          <td class="vName">
                            <span>{registration_no}</span>
                            <em>{brand_name}</em>
                          </td>
                          <td>{FormatDate(created_at)}</td>
                          <td>
                            {battery_type === "S" ? "Swapable" : "Fixed"}

                            <em class="status">
                              {charger_info !== undefined
                                ? `${charger_info?.available_charging_capacity} kWh left`
                                : ""}
                            </em>
                          </td>
                          <td>
                            {driver_info.first_name ? (
                              <>
                                <a href="javascript:void(0);">
                                  {driver_info.first_name
                                    ? driver_info.first_name
                                    : unavailable}
                                </a>
                                <em>
                                  {driver_info.phone
                                    ? driver_info.phone
                                    : unavailable}
                                </em>
                              </>
                            ) : (
                              <>{driver_info?.driver_status_description}</>
                            )}
                          </td>
                          <td>
                            {longitude
                              ? longitude + "," + latitude
                              : unavailable}
                          </td>

                          <td class={status == "D" ? "error" : "status"}>
                            {puppy_status_description}
                          </td>
                          {
                            auth.priviliges.includes("write_puppy") &&
                          
                            <td class="right">
                              <div class="actionNav">
                                <i class="material-symbols-rounded mt-m grey">
                                  more_vert
                                </i>
                                <div class="dropMenuWrap">
                                    <ul class="dropMenu" style={{ width: "180px" }}>
                                      {status == "A" &&
                                        <li>
                                          <a
                                            href="javascript:void(0);"
                                            class="open_model"
                                            id="assignAttendant"
                                            data-target="assignAttendant"
                                            onClick={(e) =>
                                              subContent(
                                                e,
                                                puppy,
                                           
                                                i,
                                           
                                              )
                                            }
                                          >
                                            Assign attendant
                                          </a>
                                        </li>}
                                    <li>
                                      <a
                                        id="inActive"
                                        href="javascript:void(0);"
                                        class={
                                          status === "D"
                                            ? "success open_model"
                                            : "error open_model"
                                        }
                                        data-target="assignInactive"
                                        onClick={(e) =>
                                          subContent(
                                            e,
                                               puppy,
                                           
                                            i,
                                           
                                          )
                                        }
                                      >
                                        {status === "D"
                                          ? "Mark as active"
                                          : "Mark as inactive"}
                                      </a>
                                      </li>
                                     
                                      
                                        <li>
                                          <a
                                            class="open_model"
                                            id="changeCharger"
                                            data-target="changeCharger"
                                            onClick={(e) =>
                                              subContent(
                                                e,
                                                puppy,
                                              
                                                i,
                                             

                                              )
                                            }
                                          >Update Battery size</a>
                                        </li>
                                  </ul>
                                </div>
                              </div>
                            </td>}
                        </tr>
                      </>
                    );
                  } else {
                    return (
                      <>
                        <tr key={i}>
                          <td class="vName">
                            <span>{registration_no}</span>
                            <em>{brand_name}</em>
                          </td>
                          <td>{FormatDate(created_at)}</td>
                          <td>
                            {battery_type === "S" ? "Swapable" : "Fixed"}
                            <em class="status">
                              {charger_info !== undefined
                                ? `${charger_info?.available_charging_capacity} kWh left`
                                : ""}
                            </em>
                          </td>
                          <td>
                            {driver_info.first_name ? (
                              <>
                                <a href="javascript:void(0);">
                                  {driver_info.first_name
                                    ? driver_info.first_name
                                    : unavailable}
                                </a>
                                <em>
                                  {driver_info.phone
                                    ? driver_info.phone
                                    : unavailable}
                                </em>
                              </>
                            ) : (
                              <>{driver_info?.driver_status_description}</>
                            )}
                          </td>
                          <td>
                            {longitude
                              ? longitude + "," + latitude
                              : unavailable}
                          </td>
                          
                          <td class={status == "D" ? "error" : "status"}>
                            {puppy_status_description}
                          </td>
                           {
                            auth.priviliges.includes("write_puppy") &&
                          
                            <td class="right">
                              <div class="actionNav">
                                <i class="material-symbols-rounded mt-m grey">
                                  more_vert
                                </i>
                                <div class="dropMenuWrap">
                                    <ul class="dropMenu" style={{ width: "180px" }}>
                                      {status == "A" &&
                                        <li>
                                          <a
                                            href="javascript:void(0);"
                                            class="open_model"
                                            id="assignAttendant"
                                            data-target="assignAttendant"
                                            onClick={(e) =>
                                              subContent(
                                                e,
                                                puppy,
                                            
                                                i,
                                            
                                              )
                                            }
                                          >
                                            Assign attendant
                                          </a>
                                        </li>}
                                    <li>
                                      <a
                                        id="inActive"
                                        href="javascript:void(0);"
                                        class={
                                          status === "D"
                                            ? "success open_model"
                                            : "error open_model"
                                        }
                                        data-target="assignInactive"
                                        onClick={(e) =>
                                          subContent(
                                            e,
                                               puppy,
                                           
                                            i,
                                           
                                          )
                                        }
                                      >
                                        {status === "D"
                                          ? "Mark as active"
                                          : "Mark as inactive"}
                                      </a>
                                      </li>
                                      
                                     
                                      
                                        <li>
                                          <a
                                            class="open_model"
                                            id="changeCharger"
                                            data-target="changeCharger"
                                            onClick={(e) =>
                                              subContent(
                                                e,
                                               puppy,
                                                i,
                                                

                                              )
                                            }
                                          >Update Battery size</a>
                                        </li>
                                  </ul>
                                </div>
                              </div>
                            </td>}
                         
                        </tr>
                      </>
                    );
                  }
                })}
              </tbody>
            </table>
            </div>
            
            {showSubComponent.changeCharger&&showPopUP&&<UpdateBattery  onBackdropClick={onBackdropClick} puppy={showSubComponent.puppy}
              showPopUP={showPopUP} isSuccess={isSuccess}
              setisSuccess={setisSuccess}   puppyDetails={puppyDetails}
              setPuppyDetails={setPuppyDetails}  index={showSubComponent.index}
      />}
            

          {showSubComponent.assignAttendant && showPopUP && (
              <AssignAttenDant
                puppy={showSubComponent.puppy}
              onBackdropClick={onBackdropClick}
              showPopUP={showPopUP}
              index={showSubComponent.index}
              puppyInfo={puppyDetails}
            />
            )}
            
            {showSubComponent.inActive && showPopUP && (
              <VehicleInActive
                puppy={showSubComponent.puppy}
              onBackdropClick={onBackdropClick}
              showPopUP={showPopUP}
             
              success={success}
              setSuccess={setSuccess}
           
              index={showSubComponent.index}
              puppyDetails={puppyDetails}
              setPuppyDetails={setPuppyDetails}
              puppySummary={puppySummary}
              setPuppySummary={setPuppySummary}
              vehicleStatusValue={vehicleStatusValue}
              isSuccess={isSuccess}
              setisSuccess={setisSuccess}
              isPuppyCreated={isPuppyCreated}
              setisPuppyCreated={setisPuppyCreated}
            
            />
          )}
        </div>
      ) : (
        <DataNotFound />
      )}

      {openAddPuppyForm && (
        <CreateNewPuppy
          onBackdropClick={onBackdropClick}
          showPopUP={showPopUP}
          openAddPuppyForm={openAddPuppyForm}
          puppyDetails={puppyDetails}
          setPuppyDetails={setPuppyDetails}
          isSuccess={isSuccess}
          setisSuccess={setisSuccess}
          isPuppyCreated={isPuppyCreated}
          setisPuppyCreated={setisPuppyCreated}
        />
      )}
    </>
  );
};

export default PuppyListing;
