import React from "react";
import { unavailable } from "../../configuration/GlobalConfig";

const PuppySummary = ({ puppySummary }) => {
  const { inactive, booked, free, at_charging_station } = puppySummary;
  return (
    <>
      <div class="xRow fullWidth lookUpDataDashboard mb-24">
        <div class="boxT1 type1">
          <i class="material-symbols-rounded grey fill">airport_shuttle</i>
          <p>Total vehicles</p>
          <span>{puppySummary.total ? puppySummary.total : unavailable}</span>
        </div>
        <div class="boxT1 chargingData">
          <i class="material-symbols-rounded grey fill">task</i>
          <p>Booking assigned</p>
          <span>{booked}</span>
        </div>
        <div class="boxT1 inprogress">
          <i class="material-symbols-rounded grey fill">charging_station</i>
          <p>At charging station</p>
          <span>{at_charging_station}</span>
        </div>
        <div class="boxT1">
          <i class="material-symbols-rounded grey fill">no_crash</i>
          <p>Free</p>
          <span>{free}</span>
        </div>
        <div class="boxT1 type5">
          <i class="material-symbols-rounded grey fill">car_crash</i>
          <p>Inactive</p>
          <span>{inactive}</span>
        </div>
      </div>
    </>
  );
};

export default PuppySummary;
