import React, { useState } from "react";
import { useEffect } from "react";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Error from "../UI/Error";
import Success from "../UI/Success";
import Spinner from "../UI/Spinner";
import { Link } from "react-router-dom";



const UpdateBattery = ({ onBackdropClick,puppy,
    showPopUP,  isSuccess, setisSuccess , puppyDetails,
    setPuppyDetails, index }) => {
    const [isChange, setIsChange] = useState(false);
    const [isLoading, setIsLoading] = useState(false);
    const chargerId = puppy.charger_info != undefined && puppy.charger_info.charger_id;


    const [chargerInfo, setChargerInfo] = useState({
        chargerId: puppy.charger_info != undefined ? puppy.charger_info.charger_id:"",
        serialNumber: puppy.charger_info!=undefined?puppy.charger_info.serial_number:"",
        totalChargingCapacity: puppy.chargerInfo!=undefined?puppy.charger_info.total_charging_capacity:"",
        registrationNo: puppy.charger_info != undefined ? puppy.charger_info.registration_no : "",
        availableChargingCapacity:puppy.charger_info != undefined ? puppy.charger_info.available_charging_capacity:"" ,

    })

    const [errorMessage, setErrorMessage] = useState("")
    const [successMessage, setSuccessMessage] = useState("")
    const [enableSubmit, setEnableSubmit] = useState(true);
    const [chargerList, setChargerList] = useState({})
    const [charger, setCharger] = useState({
        selectCharger: false
    })
    const [isError, setIsError] = useState(false);

    const handelClose = (fn) => {
        fn();
    };
    const handeldropDown = (e) => {

        setCharger({
            [e.currentTarget.id]: !charger[e.currentTarget.id],
        });
        isError == true && setIsError(false);
    };
    const handleCharger = (e, chargerdetails) => {
        if (chargerId == chargerdetails.charger_id)
        {
            setIsChange(false);
            
        }
        else {
            setIsChange(true);
        }
        

        setChargerInfo({
            ...chargerInfo, chargerId: chargerdetails.charger_id, serialNumber: chargerdetails.serial_number,
            totalChargingCapacity: chargerdetails.total_charging_capacity, registrationNo: chargerdetails.registration_no,
            availableChargingCapacity:chargerdetails.available_charging_capacity
        })
    }

    const axiosPrivate = useAxiosIntercept();
    useEffect(() => {

        let isMounted = true;
        const controller = new AbortController();
        const getCharger = async () => {
            let URL = `${process.env.REACT_APP_CHARGER_LIST}&limit=9999&status=A&charger_type=${puppy.battery_type}`;

            try {
                const response = await axiosPrivate.get(URL, {
                    signal: controller.signal,
                });

                isMounted && setChargerList(response?.data?.response?.data?.chargers);

            } catch (err) {
                console.log(err);

            }

        };
        getCharger();
        return () => {
            isMounted = false;
            controller.abort();
        };
    }, [successMessage]);
    const handleChangeCharger = async (e) => {
        setIsLoading(true);
        setErrorMessage("")
        setIsError(false);
        e.preventDefault();
        if (chargerInfo.chargerId === "") {
            setIsLoading(false);
            setErrorMessage("Please select charger");
            setIsError(true)
        }
        else if (chargerInfo.registrationNo != null && chargerId != chargerInfo.chargerId) {
            setIsLoading(false);
            setErrorMessage(`Can not be updated ! Selected battery is already assigned to ${chargerInfo.registrationNo}`);
            setIsError(true)
            
        }
        else {
            if (chargerInfo.chargerId != "" && enableSubmit == true) {
                if (isChange == true)
                {
                    const ChangeChargerRquest = {
                        vehicle_id: puppy.vehicle_id,
                        charger_id: chargerInfo.chargerId
                    }
                    setEnableSubmit(false);

                    const changeChargerUrl = process.env.REACT_APP_UPDATE_PUPPY_CHARGER;
                    const ChangeChargerResponse = await axiosPrivate.post(changeChargerUrl, ChangeChargerRquest);
                    if (ChangeChargerResponse?.data?.status == 200) {
                        setIsLoading(false);
                        setEnableSubmit(false);
                        setSuccessMessage(ChangeChargerResponse.data.message)
                        let temp = [...puppyDetails]
                        let charger_info = {
                            serial_number: chargerInfo.serialNumber,
                            available_charging_capacity: chargerInfo.availableChargingCapacity,
                            charger_id: chargerInfo.chargerId,
                            registration_no: chargerInfo.registrationNo,
                        }
                        if (puppy.charger_info != undefined) {
                       
                            temp[index.i]['charger_info']['serial_number'] = chargerInfo.serialNumber
                            temp[index.i]['charger_info']['available_charging_capacity'] = chargerInfo.availableChargingCapacity
                            temp[index.i]['charger_info']['charger_id'] = chargerInfo.chargerId
                            temp[index.i]['charger_info']['registration_no'] = chargerInfo.registrationNo
                        }
                        else {
                            temp[index.i]['charger_info'] = charger_info;
                        }
                  
                        setPuppyDetails(temp);
                        // setisSuccess(!isSuccess);
                        setTimeout(() => {
                            onBackdropClick();
                        }, 3000);
                    }
                    else {
                        setEnableSubmit(true);
                        setIsLoading(false);
                        setErrorMessage(ChangeChargerResponse?.data?.response?.errors[0].message)
                        setIsError(true);
                    }
                }
                else {
                    setIsLoading(false);
                    setErrorMessage("No any change");
                     setIsError(true)
                }
            }

            }
        
        
    }
    return showPopUP ? (
        <Overlay >
            {isLoading==true&&<Spinner/>}
            <div
                class="model_box_child assignAttendant"
                id="assignAttendant"
                style={{ width: "300px" }}
            >
                <div class="ap_heading">
                    <h4>
                        Update battery size{" "}
                        <span
                            style={{ marginLeft: "auto" }}
                            class="material-symbols-rounded black close_model"
                            onClick={() => { handelClose(onBackdropClick) }}
                        >
                            close
                        </span>
                    </h4>
                </div>
                <div class="contentSection" style={{ paddingTop: "24px" }}>
                    <section class="assignPromoP dForm">

                        <div class="promoText customer">
                            <h4>{puppy.registration_no}</h4>
                            <p class="flex mt-4">
                               
                                <i class="material-symbols-rounded grey mr-4">ev_charger</i>
                                <b class="fw-500">{puppy.charger_info!=undefined&&puppy.charger_info.total_charging_capacity} kWh</b>
                            </p>
                        </div>


                        <div class="fieldGroup" >
                            <label>Select charger identifier number</label>
                            <div
                                class="multiOption"
                                id="selectCharger"
                                onClick={(e) => handeldropDown(e)}
                            >
                                <div
                                    class={
                                        charger.selectCharger
                                            ? "selectBox  fullWidth open"
                                            : "selectBox fullWidth"
                                    }
                                >
                                    <p>
                                        {chargerInfo.serialNumber ? chargerInfo.serialNumber : "Select charger number"}
                                        <i class="material-symbols-rounded grey">expand_more</i>
                                    </p>
                                    <div class="selectDrop customScroll hFix">
                                        <ul class="dropMenu">
                                            {chargerList.length > 0 && (
                                                chargerList.map((chargerdetails) => {
                                                    return (



                                                        <li
                                                            className={
                                                                chargerInfo.chargerId === chargerdetails.charger_id
                                                                    ? "selected"
                                                                    : ""
                                                            }
                                                        >
                                                            <a
                                                                id={chargerdetails.charger_id}
                                                                onClick={(e) =>
                                                                    handleCharger(
                                                                        e,
                                                                        chargerdetails
                                                                    )
                                                                }
                                                            >
                                                                <div class="batteryList">
                                                                    <p> {chargerdetails.serial_number}</p>
                                                                    <span class="pad-0 mt-4">
                                                                        <i class="material-symbols-rounded grey ml-0">ev_charger</i>
                                                                        <span class="pl-4">{chargerdetails.total_charging_capacity != null ? chargerdetails.total_charging_capacity + "kWh" : ""} </span>•<span class={chargerdetails.registration_no!=null?"pl-4":"success"}>{chargerdetails.registration_no != null ? chargerdetails.registration_no : "Free"}</span>
                                                                    </span>
                                                                </div>

                                                                {chargerInfo.chargerId === chargerdetails.charger_id ? (
                                                                    <>
                                                                        <i className="material-symbols-rounded">
                                                                            done
                                                                        </i>
                                                                    </>
                                                                ) : (
                                                                    <></>
                                                                )}
                                                            </a>
                                                        </li>
                                                    );
                                                })
                                            )}
                                        </ul>
                                    </div>

                                    {isError == true && errorMessage ? (
                                        <>
                                            <Error error={errorMessage} />
                                        </>
                                    ) : (
                                        ""
                                    )}
                                </div>
                            </div>
                        </div>
                    </section>
                    <div class="actionButtons mt-24">
                        <span>

                            <Link 
                                style={{ pointerEvents: isChange == false ? "none" : "" }}
                                
                                onClick={(e) => handleChangeCharger(e)}
                                href="javascript:void(0);"
                                class={isChange == false ? "btn prim fullW disable" : "btn prim fullW"}
                            >
                                Update battery
                            </Link>
                        </span>
                    </div>

                    {successMessage ? (
                        <>
                            <Success success={successMessage} />
                        </>
                    ) : (
                        ""
                    )}
                </div>
            </div>
        </Overlay>
    ) : (
        <></>
    );
};

export default UpdateBattery;
