import React from "react";
import { useEffect, useState } from "react";
import Overlay from "../../utils/Overlay";
import useAxiosIntercept from "../../hooks/useAxiosIntercept";
import Button from "../UI/Button";
import Success from "../UI/Success";
import Error from "../UI/Error";
import Spinner from "../UI/Spinner";

const VehicleInActive = ({
  
  onBackdropClick,
  puppy,
  showPopUP,
  index,
  puppyDetails,
  setPuppyDetails,
  puppySummary,
  setPuppySummary,
  vehicleStatusValue,
  
}) => {
  const [loading, setLoading] = useState(false);
  const [cancellationReasons, setCancellationReasons] = useState([]);
  const [reasonId, setReasonId] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const axiosPrivate = useAxiosIntercept();
  const handelCancellationReasons = (e) => {
    setReasonId(e.target.id);
  };

  const HandelInActive = async () => {
    setLoading(true);
    if (reasonId) {
      
      const inActiveReques = {
        vehicle_id: puppy.vehicle_id,
        reason_id: reasonId,
        status: "D",
      };
      const inActiveUrl = process.env.REACT_APP_UPDATE_PUPPY_STATUS;
      const inActiveResponse = await axiosPrivate.post(
        inActiveUrl,
        inActiveReques
      );
      if (inActiveResponse?.data?.status === 200) {
        setLoading(false);
        seterrorMessage("");
        setSuccessMessage(inActiveResponse?.data?.message);
        const summary = puppySummary;

        summary.inactive = parseInt(summary.inactive) + 1;
        setPuppySummary(summary);

        const temp = [...puppyDetails];
        
       //temp[index.i]["puppy_status"] = "D";
        temp[index.i]["status"] = "D";
        temp[index.i]["puppy_status_description"]="Inactive"


        setPuppyDetails(temp);
        setTimeout(() => {
          setLoading(false);
          onBackdropClick();
        }, 3000);
      }
    } else if (reasonId == "" && puppy.status === "D") {
     
      const inActiveReques = {
        vehicle_id: puppy.vehicle_id,

        status: "A",
      };
      const inActiveUrl = process.env.REACT_APP_UPDATE_PUPPY_STATUS;
      const inActiveResponse = await axiosPrivate.post(
        inActiveUrl,
        inActiveReques
      );
      if (inActiveResponse?.data?.status === 200) {
        setLoading(false);
        seterrorMessage("");
        setSuccessMessage(inActiveResponse?.data?.message);
        const summary = puppySummary;

        summary.inactive = parseInt(summary.inactive) - 1;
        setPuppySummary(summary);

        const temp = [...puppyDetails];
        const puppyStatus = temp[index.i]["puppy_status"]=="D"?"F":temp[index.i]["puppy_status"];
       
        temp[index.i]["puppy_status_description"] =puppyStatus=="F"?"Free":puppyStatus=="A"?"Booking assigned":"Inactive" ;
        temp[index.i]["status"] = "A";
        
        setPuppyDetails(temp);
        setTimeout(() => {
          onBackdropClick(vehicleStatusValue == "D" ? true : "");
        }, 3000);
      }
    } else if (reasonId === "" && puppy.status !== "D") {
      seterrorMessage("Please select reason");
      setLoading(false);
    }
  };
  const closeInActiveForm = () => {
    onBackdropClick();
  };

  useEffect(() => {
    { puppy.status != "D" && setLoading(true); }
    let isMounted = true;
    const controller = new AbortController();

    const getCancellationReasons = async () => {
      let URL = process.env.REACT_APP_GET_CANCELLATION_REASONS;
      try {
        if (puppy.status !== "D") {
          const response = await axiosPrivate.get(URL + "&object_type=P", {
            signal: controller.signal,
          });
          setLoading(false);
          isMounted &&
            setCancellationReasons(
              response?.data?.response?.data?.cancellation_reasons
            );
        }
      } catch (err) {
        // seterror(err);
      }
    };

    getCancellationReasons();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true; // update the value of effectRun to true
    };
  }, []);
  return showPopUP ? (
    <>
      <Overlay onBackdropClick={onBackdropClick}>
        {loading==true&&<Spinner/>}
        <div
          class="model_box_child assignInactive"
          id="assignInactive"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Mark vehicle as inactive{" "}
              <span
                style={{ marginLeft: "auto" }}
                onClick={closeInActiveForm}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <h4>{puppy.registration_no}</h4>
                <p>{puppy.brand_name}</p>
              </div>
              {puppy.status !== "D" && (
                <div class="fieldGroup">
                  <label>Select reason to mark inactive</label>
                  <ul class="yType">
                    {cancellationReasons ? (
                      <>
                        {cancellationReasons.map((reasons) => {
                          return (
                            <li>
                              <input
                                type="radio"
                                id={`${reasons?.reason_id}`}
                                name="cancellationReasons"
                                value={`${reasons?.reason}`}
                                onClick={(e) => handelCancellationReasons(e)}
                              />
                              <label for={`${reasons?.reason_id}`}>
                                {reasons?.reason}
                              </label>
                            </li>
                          );
                        })}
                      </>
                    ) : (
                      <></>
                    )}
                  </ul>
                </div>
              )}
            </section>
            <div class="actionButtons mt-24">
              <span>
                {puppy.status !== "D" ? (
                  <a onClick={HandelInActive} class="btn prim btnError fullW">
                    Mark inactive
                  </a>
                ) : (
                  <a onClick={HandelInActive} class="btn prim btnSuccess fullW">
                    Mark active
                  </a>
                )}
                {/* <a onClick={HandelInActive} class="btn prim btnError fullW">
                    Mark inactive
                  </a> */}
              </span>
              {successMessage ? <Success success={successMessage} /> : <></>}
              {reasonId === "" && errorMessage ? (
                <Error error={errorMessage} />
              ) : (
                <></>
              )}
            </div>
          </div>
        </div>
      </Overlay>
    </>
  ) : (
    <></>
  );
};

export default VehicleInActive;
