import { useState, useEffect } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
// import AttendantsListing from "./AttendentsListing";
//import Pagination from "../Customer/Pagination";
import responseHandler from "../../../services/responseHandler";
import { messages } from "../../../configuration/GlobalConfig";
import AddOnsListing from "./AddOnsListing";
// import responseHandler from "../../services/responseHandler";
// import { messages } from "../../configuration/GlobalConfig";
import { pageTitles } from "../../../configuration/GlobalConfig";
import NoPriviliges from "../../UI/NoPriviliges";
import useAuth from "../../../hooks/useAuth";
const AddOnsInfo = ({ searchValue, setSearchValue }) => {
  document.title = pageTitles.ADDONS;
  const axiosPrivate = useAxiosIntercept();
  const { auth } = useAuth();
  const [serviceData, setServiceData] = useState(false);
  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [openAddPuppyForm, setOpenAddPuppyForm] = useState(false);
  const [upDatePage, setUpDatePage] = useState(false);
  const [error, setError] = useState("");
  const search_by = "firstname";

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getDrivers = async () => {
      let URL = process.env.REACT_APP_GET_SERVICE_LIST;
      //   if (searchValue === "")
      //     URL = URL + `&page=${currentPage}&limit=${usersPerPage}`;
      //   if (searchValue != "") {
      //     URL =
      //       URL +
      //       `&search_by=${search_by}&search_keyword=${search_keyword}&limit=${usersPerPage}`;
      //   }
      try {
        const { data } = await axiosPrivate.get(URL, {
          signal: controller.signal,
        });
        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");

          setServiceData(response.response.data.services);
          // setTotalRecords(response.response.data.total_records);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getDrivers();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [searchValue, currentPage, upDatePage]);

  const paginate = (number) => {
    setCurrentPage(number);
  };

  const renderAttendantListing = () => {
    if (error === "" && serviceData) {
      return (
       
        <>
          {auth.priviliges.includes("read_settings") ?
            <AddOnsListing
              serviceData={serviceData}
              setServiceData={setServiceData}
              upDatePage={upDatePage}
              setUpDatePage={setUpDatePage}
            />:<NoPriviliges/>}
          {/* <Pagination
            paginate={paginate}
            currentPage={currentPage}
            usersPerPage={usersPerPage}
            total_records={total_records}
            setUsersPerPage={setUsersPerPage}
            setCurrentPage={setCurrentPage}
          /> */}
        </>
      );
    } else {
      // Text / Message Component Here...
      return <p>{error}</p>;
    }
  };

  return renderAttendantListing();
};

export default AddOnsInfo;
