import React from "react";
import { useNavigate, Link } from "react-router-dom";
import { useState, useEffect } from "react";
// import Image from "../UI/Image";
// import { FormatDate } from "../../utils/FormatDate";
// import { unavailable } from "../../configuration/GlobalConfig";
// import VehicleInActive from "../Puppy/VehicleInActive";
import useAuth from "../../../hooks/useAuth";
import Logo from "../../../assets/images/spinner.gif";
import AddNewAddOn from "./AddNewAddOns/AddNewAddOn";
import EditAddon from "./EditAddon";
import DeleteAddons from "./DeleteAddOns";
//import AttendantInActive from "./AttendantInActive";

const AddOnsListing = ({
  //   attendantInfo,
  //   openAddPuppyForm,
  //   setOpenAddPuppyForm,
  //   setAttendantsInfo,
  //   searchValue,
  upDatePage,
  setUpDatePage,
  serviceData,
  setServiceData,
}) => {
  const [showPopUP, setShowPopUP] = useState(false);

  const [showSubComponent, setshowSubComponent] = useState({
    add: false,
    edit: false,
    delete: false,
  });
  const serviceId = showSubComponent.service_id;
  //const userId = showSubComponent.user_id;

  const subContent = (
    e,
    service_name,
    service_completion_time,
    service_description,
    service_short_decsription,
    service_image,
    default_price,
    service_id,
    description,
    service_status
  ) => {
    setshowSubComponent({
      [e.target.id]: true,
      service_name: { service_name },
      service_completion_time: { service_completion_time },
      service_description: { service_description },
      service_image: { service_image },
      default_price: { default_price },
      service_id: { service_id },
      description: { description },
      service_status: { service_status },
    });

    setShowPopUP(true);
  };
  const { auth } = useAuth();
  const onBackdropClick = (operation_status) => {
    if (operation_status === true) {
      deletePuppyFromListing(serviceId);
    }
    document.body.classList.remove("hidden");
    setShowPopUP(false);
    // setOpenAddPuppyForm(false);

    //setShowDeletePopUP(false);
  };

  const deletePuppyFromListing = (serviceId) => {
    const currentAttendants = [...serviceData];

    let index = currentAttendants.findIndex(function (element) {
      if (element.service_id === serviceId.service_id) {
        return true;
      }
    });

    if (index !== -1) {
      currentAttendants.splice(index, 1);
      setServiceData(currentAttendants);
    }
  };

  // const navigate = useNavigate();
  const renderAttendants = () => {
    if (serviceData === false) {
      return (
        <div
          style={{
            display: "flex",
            alignItems: "center",
            justifyContent: "center",
          }}
        >
          <img alt="Loading..." src={Logo} />
        </div>
      );
    } else if (serviceData.length === 0) {
      return <span>No Services To Display</span>;
    } else {
      return (
        <>
          <div class="yRow mt-24 rowLists">
            <div class="boxT1">
              <div class="item">
                <div class="text">
                  <h4>Add-ons</h4>
                  <span>Add/remove add-ons and manage their charges</span>
                </div>
                {auth.priviliges.includes("write_settings") &&
                  <div class="headingButtons mr-0">
                    <a
                      id="add"
                      href="javascript:void(0);"
                      class="btn prim open_model"
                      data-target="addNewAddOnP"
                      onClick={(e) => subContent(e)}
                    >
                      + Add new
                    </a>
                  </div>}
              </div>
              <div class="mt-16">
                <div>
                  <ul class="addOnList">
                    {serviceData.map((addOnsDetails) => {
                      const {
                        service_name,
                        service_completion_time,
                        service_description,
                        service_short_decsription,
                        service_image,
                        default_price,
                        service_id,

                        description,
                        service_status,
                      } = addOnsDetails;
                      return (
                        <li>
                          <div className="image">
                            <img src={service_image} alt="" />
                          </div>
                          <div className="">
                            <h5>{service_name}</h5>
                            {description ? (
                              description.map((descriptionData) => {
                                const data = descriptionData.split(",");
                                return (
                                  <>
                                    {data.map((highLight) => {
                                      return <span>{highLight}</span>;
                                    })}
                                  </>
                                );
                              })
                            ) : (
                              <></>
                            )}
                            {auth.priviliges.includes("write_settings") &&
                              <div className="links">
                                <a
                                  href="javascript:void(0);"
                                  class="mr-16 open_model"
                                  data-target="editAddOnP"
                                  id="edit"
                                  onClick={(e) =>
                                    subContent(
                                      e,
                                      service_name,
                                      service_completion_time,
                                      service_description,
                                      service_short_decsription,
                                      service_image,
                                      default_price,
                                      service_id,

                                      description,
                                      service_status
                                    )
                                  }
                                >
                                  Edit
                                </a>

                                <a
                                  href="javascript:void(0);"
                                  className="open_model"
                                  data-target="deleteAddOns"
                                  id="delete"
                                  onClick={(e) =>
                                    subContent(
                                      e,
                                      service_name,
                                      service_completion_time,
                                      service_description,
                                      service_short_decsription,
                                      service_image,
                                      default_price,
                                      service_id,

                                      description,
                                      service_status
                                    )
                                  }
                                >
                                  Delete
                                </a>
                              </div>}
                          </div>
                        </li>
                      );
                    })}
                  </ul>
                </div>
              </div>
            </div>

            {showSubComponent.add && showPopUP && (
              <AddNewAddOn
                onBackdropClick={onBackdropClick}
                showPopUP={showPopUP}
                upDatePage={upDatePage}
                setUpDatePage={setUpDatePage}
                // firstname={showSubComponent.firstname}
                // lastname={showSubComponent.lastname}
                // age={showSubComponent.age}
                // gender={showSubComponent.gender}
                // registration_no={showSubComponent.registration_no}
                // user_id={showSubComponent.user_id}
              />
            )}
            {showSubComponent.edit && showPopUP && (
              <EditAddon
                onBackdropClick={onBackdropClick}
                showPopUP={showPopUP}
                service_name={showSubComponent.service_name}
                service_completion_time={
                  showSubComponent.service_completion_time
                }
                service_description={showSubComponent.service_description}
                service_image={showSubComponent.service_image}
                service_id={showSubComponent.service_id}
                default_price={showSubComponent.default_price}
                description={showSubComponent.description}
                upDatePage={upDatePage}
                setUpDatePage={setUpDatePage}
              />
            )}
            {showSubComponent.delete && showPopUP && (
              <DeleteAddons
                onBackdropClick={onBackdropClick}
                showPopUP={showPopUP}
                service_id={showSubComponent.service_id}
                service_name={showSubComponent.service_name}
                service_status={showSubComponent.service_status}
                // firstname={showSubComponent.firstname}
                // lastname={showSubComponent.lastname}
                // age={showSubComponent.age}
                // gender={showSubComponent.gender}
                // registration_no={showSubComponent.registration_no}
                // user_id={showSubComponent.user_id}
              />
            )}
          </div>
        </>
      );
    }
  };

  return renderAttendants();
};
export default AddOnsListing;
