import React from "react";
import { useEffect, useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Success from "../../UI/Success";
import Error from "../../UI/Error";

const DeleteAddons = ({
  service_id,
  onBackdropClick,
  showPopUP,
  service_name,
  service_status,
}) => {
  const [cancellationReasons, setCancellationReasons] = useState([]);
  const [reasonId, setReasonId] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, seterrorMessage] = useState("");
  const [enableSubmit,setEnableSubmit]=useState(true)
  const axiosPrivate = useAxiosIntercept();
  const handelCancellationReasons = (e) => {
    setReasonId(e.target.id);
  };
  const HandelDeleteAddons = async () => {
    if (reasonId&&enableSubmit==true) {
      setEnableSubmit(false)
      const deleteRequest = {
        service_id: service_id.service_id,
        cancel_reason_id: reasonId,
        service_status: "0",
      };
      const deleteUrl = process.env.REACT_APP_DELETE_SERVICES;
      const deleteResponse = await axiosPrivate.post(deleteUrl, deleteRequest);
      if (deleteResponse?.data?.status === 200) {
        seterrorMessage("");
        setSuccessMessage(deleteResponse?.data?.message);
        setTimeout(() => {
          onBackdropClick(true);
        }, 3000);
      }
    } else {
      seterrorMessage("Please select reason");
    }
  };
  const closeInActiveForm = () => {
    onBackdropClick();
  };

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();

    const getCancellationReasons = async () => {
      let URL = process.env.REACT_APP_GET_CANCELLATION_REASONS;
      try {
        const response = await axiosPrivate.get(URL + "&object_type=A", {
          signal: controller.signal,
        });

        isMounted &&
          setCancellationReasons(
            response?.data?.response?.data?.cancellation_reasons
          );
      } catch (err) {
        // seterror(err);
      }
    };

    getCancellationReasons();
    // }

    return () => {
      isMounted = false;
      controller.abort();
      // effectRun.current = true; // update the value of effectRun to true
    };
  }, []);
  return showPopUP ? (
    <>
      <Overlay>
        <div
          class="model_box_child deleteAddOnsP"
          id="deleteAddOns"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Delete Add-ons
              <span
                style={{ marginLeft: "auto" }}
                onClick={closeInActiveForm}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <h4>{service_name?.service_name}</h4>
              </div>
              <div class="fieldGroup">
                <label>Select reason to mark inactive</label>
                <ul class="yType">
                  {cancellationReasons ? (
                    <>
                      {cancellationReasons.map((reasons) => {
                        return (
                          <li>
                            <input
                              type="radio"
                              id={`${reasons?.reason_id}`}
                              name="cancellationReasons"
                              value={`${reasons?.reason}`}
                              onClick={(e) => handelCancellationReasons(e)}
                            />
                            <label for={`${reasons?.reason_id}`}>
                              {reasons?.reason}
                            </label>
                          </li>
                        );
                      })}
                    </>
                  ) : (
                    <></>
                  )}
                </ul>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a onClick={HandelDeleteAddons} class="btn prim btnError fullW">
                  Delete
                </a>
              </span>
              {successMessage ? <Success success={successMessage} /> : <></>}
              {reasonId === "" && errorMessage ? (
                <Error error={errorMessage} />
              ) : (
                <></>
              )}
            </div>
          </div>
        </div>
      </Overlay>
    </>
  ) : (
    <></>
  );
};

export default DeleteAddons;
