import React, { useState } from "react";
import Overlay from "../../../utils/Overlay";
import { useFormInputValidation } from "react-form-input-validation";
import axios from "axios";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Error from "../../UI/Error";
import Success from "../../UI/Success";
const EditAddOn = ({
  onBackdropClick,
  showPopUP,
  service_name,
  service_completion_time,
  service_description,
  service_image,
  service_id,
  default_price,
  description,
  setUpDatePage,
  upDatePage,
}) => {
  const [serviceHighlights, setServiceHighlights] = useState([]);
  const axiosPrivate = useAxiosIntercept();
  const [successMessage, setSuccessMessage] = useState("");
  const [enableSubmit,setEnableSubmit]=useState(true);

  var details = [];
  var i = 0;
  description.description !== null ? (
    <>
      {description.description.map((data) => {
        details[i] = data;
        i++;
      })}
    </>
  ) : (
    <></>
  );

  const [fields, errors, form] = useFormInputValidation(
    {
      serviceName: service_name.service_name,
      serviceCharge: default_price.default_price,
      service_image: service_image.service_image,
      serviceCompletionTime: service_completion_time.service_completion_time,
      serviceDescription0: details[0],
      serviceDescription1: details[1],
      serviceDescription2: details[2],
    },
    {
      serviceName: "required|string",
      serviceCharge: "required|numeric",
      serviceCompletionTime: "required|numeric",
      serviceDescription0: "required|string",
      serviceDescription1: "required|string",
      serviceDescription2: "required|string",
    }
  );

  const [image, setImage] = useState(service_image);
  const [imageTrue, setImageTrue] = useState(false);
  const [imageErrorMessage, setImageErrorMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [thumbnail, setThumbnail] = useState("");
  function handleImage(e) {
    setImage(e.target.files[0]);
    setImageTrue(true);
    setThumbnail(URL.createObjectURL(e.target.files[0]));
  }

  const submit = async (e) => {
    setImageErrorMessage("");

    if (imageTrue === false && !fields.service_image) {
      setImageErrorMessage("Please upload Image");
    }

    const isValid = await form.validate(e);

    const serviceDescription = [];
    if (fields.serviceDescription0 != "") {
      serviceDescription.push(fields.serviceDescription0);
    }
    if (fields.serviceDescription1 != "") {
      serviceDescription.push(fields.serviceDescription1);
    }
    if (fields.serviceDescription2 != "") {
      serviceDescription.push(fields.serviceDescription2);
    }
    // const addAddOnsRequest = {
    //   service_name: fields.serviceName,
    //   service_image: image,
    //   service_completion_time: fields.serviceCompletionTime,
    //   default_price: fields.serviceCharge,
    //   service_description: serviceDescription,
    // };
    let formData = new FormData();
    formData.append("service_image", image);
    formData.append("service_name", fields.serviceName);
    formData.append("service_completion_time", fields.serviceCompletionTime);
    formData.append("service_default_price", fields.serviceCharge);
    formData.append("service_description[0]", serviceDescription[0]);
    formData.append("service_description[1]", serviceDescription[1]);
    formData.append("service_description[2]", serviceDescription[2]);
    formData.append("service_id", service_id.service_id);

    const config = { headers: { "content-type": "multipart/form-data" } };
    if (isValid && enableSubmit==true&&(imageTrue || fields.service_image)) {
      setEnableSubmit(false)
      const editAddOnsUrl = process.env.REACT_APP_EDIT_SERVICES;
      const editAddOnsResponse = await axiosPrivate.post(
        editAddOnsUrl,
        formData,
        config
      );

      if (editAddOnsResponse?.data?.status === 200) {
        
        setErrorMessage("");
        setSuccessMessage(editAddOnsResponse?.data?.message);
        setTimeout(() => {
          onBackdropClick(true);
          setUpDatePage(!upDatePage);
        }, 3000);
      }
    }
  };
  const handelClose = () => {
    onBackdropClick();
  };
  const removeImage = () => {
    setThumbnail();
    setImageTrue(false);
    setImage();
    fields.service_image = null;
  };
  const handleChangeEvent = (e) => {
    //setServiceHighlights(([e.target.id]: [e.target.value]));
  };

  return (
    <Overlay>
      <form onSubmit={submit}>
        <div
          class="model_box_child editAddOnP"
          id="editAddOnP"
          style={{ width: "320px", maxHeight: "550px", overflowY: "auto" }}
        >
          <div class="ap_heading">
            <h4>
              Edit add-on
              <span
                style={{ marginLeft: "auto" }}
                onClick={handelClose}
                class="material-symbols-rounded black close_model"
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <div class="dForm">
              <div class="fieldGroup mt-0">
                <label>Add-on name</label>
                <input
                  type="text"
                  placeholder="Enter add-on name"
                  name="serviceName"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceName}
                  autoComplete="off"
                />
                {errors.serviceName && <Error error={errors.serviceName} />}
              </div>
              <div class="fieldGroup ">
                <label>Service charge</label>
                <input
                  type="text"
                  placeholder="Enter service charge"
                  name="serviceCharge"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceCharge}
                  autoComplete="off"
                />
                {errors.serviceCharge && <Error error={errors.serviceCharge} />}
              </div>
              <div class="fieldGroup ">
                <label>Service completion time</label>
                <input
                  type="text"
                  placeholder="Enter service completion time"
                  name="serviceCompletionTime"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceCompletionTime}
                  autoComplete="off"
                />
                {errors.serviceCompletionTime && (
                  <Error error={errors.serviceCompletionTime} />
                )}
              </div>
              <div class="fieldGroup">
                <label>Main highlights of the add-on</label>
                <input
                  type="text"
                  placeholder="For ex: It takes 10 mins"
                  name="serviceDescription0"
                  class="mb-8"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceDescription0}
                  autoComplete="off"
                />
                {errors.serviceDescription0 && (
                  <Error error={errors.serviceDescription0} />
                )}

                <input
                  type="text"
                  placeholder="For ex: It uses newest technology"
                  name="serviceDescription1"
                  class="mb-8"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceDescription1}
                  autoComplete="off"
                />
                {errors.serviceDescription1 && (
                  <Error error={errors.serviceDescription1} />
                )}
                <input
                  type="text"
                  placeholder="For ex: It includes cleaning and polishing"
                  name="serviceDescription2"
                  class="mb-8"
                  onChange={form.handleChangeEvent}
                  value={fields.serviceDescription2}
                  autoComplete="off"
                />
                {errors.serviceDescription2 && (
                  <Error error={errors.serviceDescription2} />
                )}
              </div>
              <div class="fieldGroup wAuto">
                <label>
                  Upload photo of the add-on
                  <em>Size should be minimum 240 x 240 pixels</em>
                </label>
                <div class="customFileUploader">
                  {fields.service_image || imageTrue ? (
                    <div class="csutomImgUploads">
                      <span onClick={removeImage}>
                        <i class="material-symbols-rounded white arrowBottom mt-m arrow">
                          delete
                        </i>
                        <img
                          src={
                            fields.service_image
                              ? fields.service_image
                              : thumbnail
                          }
                          alt=""
                        />
                      </span>
                    </div>
                  ) : (
                    <></>
                  )}

                  {imageTrue == false && !fields.service_image ? (
                    <>
                      <input
                        type="file"
                        id="actual-btn"
                        onChange={handleImage}
                      />
                      <label for="actual-btn">
                        <i class="material-symbols-rounded grey arrowBottom mt-l arrow">
                          add_a_photo
                        </i>
                      </label>
                    </>
                  ) : (
                    <></>
                  )}
                </div>
                {imageErrorMessage && <Error error={imageErrorMessage} />}
              </div>
            </div>
            <div class="actionButtons mt-24">
              <span>
                <button type="submit" class="btn prim fullW">
                  Save changes
                </button>
              </span>

              {successMessage && <Success success={successMessage} />}
            </div>
          </div>
        </div>
      </form>
    </Overlay>
  );
};

export default EditAddOn;
