import { useState, useEffect } from "react";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
// import AttendantsListing from "./AttendentsListing";
//import Pagination from "../Customer/Pagination";
import responseHandler from "../../../services/responseHandler";
import { messages } from "../../../configuration/GlobalConfig";
import ManageAttendantIncentive from "./ManageAttendantIncentive";
import { pageTitles } from "../../../configuration/GlobalConfig";
import useAuth from "../../../hooks/useAuth";
import NoPriviliges from "../../UI/NoPriviliges";

// import responseHandler from "../../services/responseHandler";
// import { messages } from "../../configuration/GlobalConfig";

const AttendantIncentive = ({ searchValue, setSearchValue }) => {
  document.title = pageTitles.ATTENDENTINCENTIVE;
  const axiosPrivate = useAxiosIntercept();
  const { auth } = useAuth();
  const [serviceData, setServiceData] = useState(false);
  const search_keyword = searchValue;
  const [currentPage, setCurrentPage] = useState(1);
  const [usersPerPage, setUsersPerPage] = useState(5);
  const [total_records, setTotalRecords] = useState(0);
  const [openAddPuppyForm, setOpenAddPuppyForm] = useState(false);
  const [upDatePage, setUpDatePage] = useState(false);
  const [success, setSuccess] = useState(false);
  const [error, setError] = useState("");
  const [showPopUP, setShowPopUP] = useState(false);
  const [attendantIncentiveData, setAttendantIncentiveData] = useState([]);
  const search_by = "firstname";

  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getAttendantIncentive = async () => {
      let URL = process.env.REACT_APP_GET_ATTENDANT_INCENTIVE;
      const request = {
        config_data: [
          {
            site: "api",
            module: "common",
            config_key: "default_commission_details",
          },
        ],
      };

      try {
        const { data } = await axiosPrivate.post(URL, request);

        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");

          let jsonValue = response.response.data[0].value;

          let jsonObj = JSON.parse(jsonValue);

          setAttendantIncentiveData(jsonObj);
          //   // setTotalRecords(response.response.data.total_records);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getAttendantIncentive();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);

  const [showSubComponent, setshowSubComponent] = useState({
    manage: false,
  });

  const subContent = (e, commissionValue) => {
    setshowSubComponent({
      [e.target.id]: true,
      commissionValue: commissionValue,
    });

    setShowPopUP(true);
  };
  const onBackdropClick = () => {
    // if (operation_status === true) {
    //   deletePuppyFromListing(serviceId);
    // }
    setShowPopUP(false);
    document.body.classList.remove("hidden");
    // setOpenAddPuppyForm(false);

    //setShowDeletePopUP(false);
  };

  const renderAttendantListing = () => {
    if (error === "") {
      return (
        <>
          {auth.priviliges.includes("read_settings") ?
            <div class="yRow mt-24 rowLists">
              <div class="boxT1">
                <div class="item">
                  <div class="text">
                    <h4>Attendants</h4>
                    <span>Manage attendants incentive</span>
                  </div>
                  <i class="material-symbols-rounded arrowBottom mt-l">
                    expand_more
                  </i>
                </div>
                <div class="tableList mt-16">
                  <div>
                    <h5>Service fee</h5>
                    <table class="widthAuto">
                      <tbody>
                        <tr>
                          <td>
                            <span>Upsell incentive</span>
                            <span class="time">
                            
                              {`${attendantIncentiveData.commission_value}%`}
                              {auth.priviliges.includes("write_settings") &&
                                <a
                                  class="open_model"
                                  href="javascript:void(0);"
                                  data-target="manageBookingWindowP_ManageIncentive"
                                  id="manage"
                                  onClick={(e) =>
                                    subContent(
                                      e,
                                      attendantIncentiveData.commission_value
                                    )
                                  }
                                >
                                  Manage
                                </a>}
                            </span>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              {/* <div class="boxT1">
              <div class="item">
                <div class="text">
                  <h4>Booking window</h4>
                  <span>Manage the booking window</span>
                </div>
                <i class="material-symbols-rounded arrowTop mt-l">
                  expand_more
                </i>
              </div>
              <div class="tableList mt-16">
                <div>
                  <table class="widthAuto">
                    <tbody>
                      <tr>
                        <td>
                          <span>Global</span>
                          <span class="time">
                            Min. 2hr - Max 1month
                            <a
                              class="open_model"
                              href="javascript:void(0);"
                              data-target="manageBookingWindowP_Global"
                            >
                              Manage
                            </a>
                          </span>
                        </td>
                        <td>
                          <span>Emergency</span>
                          <span class="time">
                            1 hours<a href="javascript:void(0);">Manage</a>
                          </span>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
            <div class="boxT1">
              <div class="item">
                <div class="text">
                  <h4>Battery size</h4>
                  <span>Manage the battery size range of vehicles</span>
                </div>
                <div class="headingButtons">
                  <a
                    href="javascript:void(0);"
                    class="btn seco open_model"
                    data-target="manageBookingTimeP_BatterySize"
                  >
                    Manage sizes
                  </a>
                  <a
                    href="javascript:void(0);"
                    class="btn prim open_model"
                    data-target="manageBookingTimeP_AddBattery"
                  >
                    Add new size
                  </a>
                </div>
                <i class="material-symbols-rounded arrowBottom mt-l">
                  expand_more
                </i>
              </div>
              <div class="tableList mt-16">
                <div>
                  <ul class="tabsList ml-0">
                    <li>&lt; 45 kWh</li>
                    <li>45-60 kWh</li>
                    <li>60-80 kWh</li>
                    <li>&gt; 80kWh</li>
                  </ul>
                </div>
              </div>
            </div> */}
              {showSubComponent.manage && showPopUP && (
                <ManageAttendantIncentive
                  onBackdropClick={onBackdropClick}
                  showPopUP={showPopUP}
                  commissionValue={attendantIncentiveData.commission_value}
                  success={success}
                  setSuccess={setSuccess}
                />
              )}
            </div>:<NoPriviliges/>}
        </>
      );
    } else {
      // Text / Message Component Here...
      return <p>{error}</p>;
    }
  };

  return renderAttendantListing();
};

export default AttendantIncentive;
