import React from "react";
import { useState } from "react";
import Overlay from "../../../utils/Overlay";
import { useFormInputValidation } from "react-form-input-validation";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import { message } from "antd";
import { pageTitles } from "../../../configuration/GlobalConfig";
import Success from "../../UI/Success";
import Error from "../../UI/Error";
const ManageAttendantIncentive = ({
  onBackdropClick,
  showPopUP,
  commissionValue,
  success,
  setSuccess,
}) => {
  const handelClose = () => {
    onBackdropClick();
  };
  const axiosPrivate = useAxiosIntercept();
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");
  const [response, setResponse] = useState();
  const [notifyData, setNotifyData] = useState();
  const [fields, errors, form] = useFormInputValidation(
    {
      commission_value: commissionValue,
    },
    {
      commission_value: "required|numeric",
    }
  );
  const submit = async (e) => {
    Object.keys(errors).forEach((i) => (errors[i] = null));
    e.preventDefault();
    const isValid = await form.validate(e);

    const request = {
      config_data: {
        site: "api",
        module: "common",
        config_key: "default_commission_details",
        value: {
          commission_type: "P",
          commission_value: fields.commission_value,
        },
      },
    };
    const url = process.env.REACT_APP_MANAGE_ATTENDANT_INCENTIVE;
    if (isValid) {
      const response = await axiosPrivate.post(url, request);

      setSuccessMessage("");
      if (response?.data?.status === 200) {
        setErrorMessage("");
        setSuccessMessage(response?.data?.message);
        setTimeout(() => {
          onBackdropClick(true);
          setSuccess(!success);
        }, 3000);
      } else {
        setErrorMessage(response?.data?.message);
      }
    }

    // <UpdateSettingswrapper
    //   response={response}
    //   setResponse={setResponse}
    //   url={url})
    //   value={value}
    // />;
  };
  return showPopUP ? (
    <Overlay>
      <form onSubmit={submit}>
        <div
          class="model_box_child manageBookingTimeP ManageIncentive"
          id="manageBookingWindowP_ManageIncentive"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Manage incentive
              <span
                style={{ marginLeft: "auto" }}
                class="material-symbols-rounded black close_model"
                onClick={handelClose}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection" style={{ paddingTop: "24px" }}>
            <section>
              <div class="addTime dForm">
                <div class="lists">
                  <div class="xType alignBottom">
                    <div class="fieldGroup mt-0">
                      <em class="smallLabel">Upsell incentive</em>
                      <div class="multiOption">
                        <input
                          type="text"
                          placeholder="Enter new Upsell incentive"
                          name="commission_value"
                          onChange={form.handleChangeEvent}
                          value={fields.commission_value}
                        />
                        <div class="sepText bg">
                          <span class="active">%</span>
                        </div>
                      </div>

                      <span style={{ color: "red" }}>
                        {errors.commission_value}
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <button type="submit" class="btn prim fullW">
                  Save changes
                </button>
              </span>
              {successMessage ? <Success success={successMessage} /> : <></>}
              {errorMessage ? <Error errror={errorMessage} /> : <></>}
            </div>
          </div>
        </div>
      </form>
    </Overlay>
  ) : (
    <></>
  );
};

export default ManageAttendantIncentive;
