import React from 'react'
import { useLocation } from 'react-router-dom'
import { useNavigate } from 'react-router-dom';
import { useState } from 'react';
import { useParams } from 'react-router-dom'
import Success from "../../UI/Success"
import Error from "../../UI/Error"
import Message from "../../../utils/Message"
import useAxiosIntercept from "../../../hooks/useAxiosIntercept"
export default function BrandEdit() {
    const { state } = useLocation();
    const navigate = useNavigate();
    const axiosPrivate = useAxiosIntercept();
    const params = useParams();
    const [isSubmit, setisSubmit] = useState(false)
    const [editFields, seteditFields] = useState({
        brandName: state.name,
        brandImage: state.image,
        brand_id: params.brand_id
    })
    const [isEdited, setisEdited] = useState(false)
    const [image, setimage] = useState("")
    const [showImage, setshowImage] = useState(false);
    const [showMessage, setshowMessage] = useState(false)
    const [thumbnail, setThumbnail] = useState("");
    const [successMessage, setsuccessMessage] = useState("")
    const [errorMessage, setErrorMessage] = useState("")
    const [isSuccess, setIsSuccess] = useState(false);
    const handleImage = (e) => {
        setisEdited(true);
        setErrorMessage("")
        setshowImage(true);
        seteditFields({
            brandImage: e.target.files[0]
        });
        setThumbnail(URL.createObjectURL(e.target.files[0]));

    }
    const removeImage = () => {
        setshowImage(false);
        setThumbnail("");
        seteditFields({
            brandImage: ""
        })

    };
    const updateDetails = async () => {
        setisSubmit(true);

        const URL = process.env.REACT_APP_UPDATE_VEHICLE_BRAND + `&brand_id=${params.brand_id}`;

        const config = { headers: { "content-type": "multipart/form-data" } };
        const formData = new FormData();
        if (showImage) {

            formData.append("brand_logo", editFields.brandImage)

        }
        else {


            formData.append("brand_logo", image)
        }


        if (editFields.brandImage == "") {
            setErrorMessage("Brand image is mandatory")
        }

        else {
            if (isEdited) {
                const response = await axiosPrivate.post(URL, formData, config);

                if (response?.data?.status == "200") {
                    setshowMessage(true)
                    setsuccessMessage({
                        text: "Brand edited successfully"
                    });
                    setIsSuccess(true);
                    setshowImage(false);
                }
                else {
                    setisSubmit(false)
                    setErrorMessage(response?.data?.response?.errors[0]?.message)

                }

            }
            else {
                setErrorMessage("Nothing to update")
            }


        }
    }
    return (
        <>


            {showMessage && (
                <Message
                    message={successMessage}
                    successValue="Go Back To Brands"
                    errorValue="Try again"
                    successLink={"/settings"}
                    errorLink="/settings"
                    isSuccess={isSuccess}
                    setIsSuccess={setIsSuccess}


                />
            )}
            <div class="subContent">
                <div class="settings">
                    <div class="brands newEV editBrand">
                        <div class="dForm w300">
                            <section class="brandDetailSection mb-24">
                                <h3 class="mb-24">Brand details</h3>
                                <div class="fieldGroup mt-0">
                                    <label>Brand name</label>
                                    <span>
                                        <input type="text" placeholder={editFields.brandName} name="" value={editFields.brandName} disabled="true" />
                                    </span>
                                </div>
                                <div class="fieldGroup">
                                    <label>Upload photo of brand</label>
                                    <div class="customFileUploader">
                                        {showImage || editFields?.brandImage ? (<> <div class="csutomImgUploads">
                                            <span>
                                                <i class="material-symbols-rounded white arrowBottom mt-m arrow" onClick={removeImage}>delete</i>
                                                <img src={thumbnail ? thumbnail : editFields.brandImage} alt="" />
                                            </span>
                                        </div></>) : (<> <input type="file" id="actual-btn" onChange={handleImage} value={editFields.brandImage} />
                                            <label for="actual-btn">
                                                <i class="material-symbols-rounded grey arrowBottom mt-l arrow">add_a_photo</i>
                                            </label></>)}


                                    </div>
                                </div>
                            </section>


                            <div class="actionButtons mt-24">
                                <span class="">
                                    <a class="btn prim" onClick={updateDetails}>Update brand details</a>
                                </span>
                                {errorMessage && <Error error={errorMessage} />}
                            </div>

                            {/* {successMessage && <Success success={successMessage} />} */}
                        </div>
                    </div>
                </div>
            </div>

        </>
    )
}
