import React, { useState } from "react";
import Button from "../../UI/Button";
import loader from "../../../assets/images/spinner.gif";
import Spinner from "../../UI/Spinner";
import Notification from "../../../utils/Notification";
import { useNavigate } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import InactiveBrandPopUp from "./InactiveBrandPopUp";
import { FormatDate } from "../../../utils/FormatDate";
import SearchBar from "../../UI/SearchBar/SearchBar";
import { Link } from "react-router-dom";
import DataNotFound from "../../UI/DataNotFound";
import useAuth from '../../../hooks/useAuth';
import NoPriviliges from "../../UI/NoPriviliges";

export default function BrandListing({
  brands,
  setshowSubComponent,
  searchValue,
  setSearchValue,
  setBrands,
}) {
 
  const navigate = useNavigate();
  const axiosPrivate = useAxiosIntercept();
  const [index, setIndex] = useState("");
  const [brandName, setbrandName] = useState();
  const [brandid, setbrandid] = useState();
  const [showinactiveBrand, setshowInactiveBrand] = useState(false);
  const [brandId, setbrandId] = useState();
  const [reasons, setReasons] = useState();
  const [markBrandActive, setMarkBrandActive] = useState(false);
  const [notifyData, setNotifyData] = useState();
   const { auth }=useAuth();
  const activateBrand = (id, name, index) => {
    setMarkBrandActive(true);
    setNotifyData({
      brand_id: id,
      id: index,
      name: "Do you want to activate",
      text: "this brand ?",
      buttonNameYes: "Confirm",
      buttonNameNo: "Cancel",
      url: process.env.REACT_APP_UPDATE_VEHICLE_BRAND,
      apiRequest: {
        brand_id: id,
        status: "1",
      },
    });
  };

  const markBrandInactive = async (id, name, index) => {
    setbrandId(id);
    setbrandName(name);
    setshowInactiveBrand(true);
    setIndex(index);
    const response = await axiosPrivate.get(
      process.env.REACT_APP_BOOKING_CANCELLATION_REASON + "&object_type=BR"
    );

    if (response?.status == "200") {
      setReasons(response?.data?.response?.data?.cancellation_reasons);
    }
  };

  const onBackdropClick = (operation_status, index) => {
    if (operation_status === true) {
      let brands_temp = brands;
      brands_temp[index].status = brands_temp[index].status == 0 ? 1 : 0;
      setBrands(brands_temp);
    }
    setMarkBrandActive(false);
    setshowInactiveBrand(false);
    document.body.classList.remove("hidden");
  };
  const changeStatus = (id, name, status, index) => {
    if (status == "1") {
      markBrandInactive(id, name, index);
    } else {
      activateBrand(id, name, index);
    }
  };
  return (
    <>

      {markBrandActive && (
        <Notification
          notifyData={notifyData}
          onBackdropClick={onBackdropClick}
        />
      )}
      {showinactiveBrand && (
        <InactiveBrandPopUp
          reasons={reasons}
          brandId={brandId}
          setshowInactiveBrand={setshowInactiveBrand}
          onBackdropClick={onBackdropClick}
          brandName={brandName}
          setshowSubComponent={setshowSubComponent}
          index={index}
        />
      )}
      {auth.priviliges.includes("write_settings") &&
        <div class="searchPanel mt-24">
          <SearchBar
            placeholder={"Search by brand name"}
            searchValue={searchValue}
            setSearchValue={setSearchValue}
          />
          <Button value="Add new brand" btn_link={"/settings/addnewbrand"} />
        </div>}

      {brands === "" ? (
        <Spinner />
      ) : Object.keys(brands).length !== 0 ? (
          <>
             {auth.priviliges.includes("read_settings") ? 

              <div class="subContent pt-24">
                <div class="settings">
                  <div class="brands">
                    <div class="customersList">
                      {brands.map((brand, index) => {
                        return (
                          <div class="infoEntry" key={index}>
                            <div class="userInfo">
                              <div class="imgBlock">
                                <div>
                                  <img src={brand.image} alt="" />
                                </div>
                              </div>
                              <div class="name">
                                <span>{brand.name}</span>
                                <span>Added on {FormatDate(brand.created_at)}</span>
                              </div>
                            </div>
                            <div class="userInfo">
                              <div class="email">
                                <span>Total EVs</span>
                                <span>{brand.total_ev_count}</span>
                              </div>
                            </div>
                            <div class="userInfo">
                              <div class="contactInfo">
                                <span>Status</span>
                                <span
                                  class={brand.status == "1" ? "success" : "error"}
                                >
                                  {brand.status == "1" ? "Active" : "Inactive"}
                                </span>
                              </div>
                            </div>
                            <div class="moreInfoBtn">
                              <div class="actionNav wBorder ml-24">
                                {" "}
                                <i class="material-symbols-rounded mt-m grey mr-0">
                                  more_vert
                                </i>
                                <div class="dropMenuWrap">
                                  <ul class="dropMenu" style={{ width: "180px" }}>
                                    {auth.priviliges.includes("read_settings") &&
                                      <li
                                        onClick={(e) => {
                                          navigate(
                                            `/settings/branddetails/${brand?.id}`
                                          );
                                        }}
                                      >
                                        {" "}
                                        <a>View vehicle details</a>{" "}
                                      </li>}
                                    {auth.priviliges.includes("write_settings") && <>

                                      <li onClick={(e) => { navigate(`/settings/editbrand/${brand?.id}`, { state: { name: brand.name, image: brand.image } }) }}> <Link>Edit brand details</Link> </li>
                                      <li
                                        onClick={(e) => {
                                          navigate(`/settings/addnewEV/${brand?.id}`);
                                        }}
                                      >
                                        {" "}
                                        <a>Add new EV</a>{" "}
                                      </li>
                                      <li
                                        onClick={() => {
                                          changeStatus(
                                            brand.id,
                                            brand.name,
                                            brand?.status,
                                            index
                                          );
                                        }}
                                      >
                                        {" "}
                                        <a
                                          class={
                                            brand?.status == "1"
                                              ? "open_model error"
                                              : "open_model success"
                                          }
                                          data-target="MarkInactiveP"
                                        >
                                          {brand?.status == "1"
                                            ? "Mark as inactive"
                                            : "Mark as active"}
                                        </a>{" "}
                                      </li></>}
                                  </ul>
                                </div>
                              </div>
                            </div>
                          </div>
                        );
                      })}
                    </div>
                  </div>
                </div>
            </div>
            :<NoPriviliges message="no priviliges" />} 
        </>
      ) : (
        <>
          <div class="pt-24">
            <DataNotFound />
          </div>
        </>
      )}
    </>
  );
}
