import React from "react";
import { useNavigate } from "react-router-dom";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import { useState } from "react";
import { FormatDate } from "../../../utils/FormatDate";
import DeleteVehiclePopUp from "./DeleteVehiclePopUp";
import loader from "../../../assets/images/spinner.gif";
import Spinner from "../../UI/Spinner";
import useAuth from "../../../hooks/useAuth";
import DataNotFound from "../../UI/DataNotFound";
export default function BrandModelAndVarientsListing({
  brandDetails,
  onBackdropClick,
  setdeleteVehiclepopup,
  deleteVehiclepopup,
  setShowEditEVComponent,
  setvariantDetails,
  variantDetails,
  singlebrandData,
  setbrandDetails,
}) {
  const navigate = useNavigate();
  const { auth } = useAuth();
  const axiosPrivate = useAxiosIntercept();
  const [reasons, setReasons] = useState();
  const editEV = (name, image, battery, id) => {
    setvariantDetails({
      variant_name: name,
      variant_image: image,
      variant_battery: battery,
      variant_id: id,
    });
    setShowEditEVComponent(true);
  };
  const models = brandDetails?.models;
  const deleteVehicle = async (
    name,
    image,
    battery,
    id,
    modelIndex,
    variantIndex
  ) => {
    setvariantDetails({
      variant_name: name,
      variant_image: image,
      variant_battery: battery,
      variant_id: id,
      modelIndex: modelIndex,
      variantIndex: variantIndex,
    });
    setdeleteVehiclepopup(true);
    const response = await axiosPrivate.get(
      process.env.REACT_APP_BOOKING_CANCELLATION_REASON + "&object_type=BV"
    );
    if (response?.status == "200") {
      setReasons(response?.data?.response?.data?.cancellation_reasons);
    }
  };
  return (
    <>
      {deleteVehiclepopup && (
        <DeleteVehiclePopUp
          onBackdropClick={onBackdropClick}
          variantDetails={variantDetails}
          setdeleteVehiclepopup={setdeleteVehiclepopup}
          reasons={reasons}
          brandDetails={brandDetails}
          setbrandDetails={setbrandDetails}
        />
      )}
      <>
        <h2>
          <a style={{ cursor: "pointer" }}>
            <span
              class="material-symbols-rounded mt-l black"
              onClick={(e) => {
                navigate(-1);
              }}
            >
              arrow_back
            </span>
          </a>
          Brand details
        </h2>
        <div class="subContent">
          <div class="settings">
            <div class="brands">
              <div class="searchPanel vehicleHead mb-24">
                <div class="searchBar">
                  <div class="userInfo">
                    <div class="imgBlock">
                      <div>
                        <img src={singlebrandData[0]?.image} alt="" />
                      </div>
                    </div>
                    <div class="name">
                      <h2 class="mb-0">{singlebrandData[0]?.name}</h2>
                      <span>
                        Added on {FormatDate(singlebrandData[0]?.created_at)}
                      </span>
                    </div>
                  </div>
                </div>
                {auth.priviliges.includes("write_settings") &&
                  <a
                    class="btn prim"
                    onClick={(e) => {
                      navigate(`/settings/addnewEV/${singlebrandData[0]?.id}`);
                    }}
                  >
                    Add new EV
                  </a>}
              </div>
              {brandDetails === "" ? (
                <>
                  <Spinner />
                </>
              ) : Object.keys(brandDetails).length !== "0" &&
                brandDetails?.models?.length > 0 ? (
                <>
                  {models &&
                    models.map((model, i) => {
                      const variants = brandDetails?.models[i]?.variants;

                      return (
                        <>
                          <h3 class="mb-16">{model.name}</h3>
                          <div class="brandLists">
                            <ul>
                              {variants?.length > 0 ? (
                                <>
                                  {variants.map((variant, index) => {
                                    return (
                                      <>
                                        
                                        <li>
                                          {auth.priviliges.includes("write_settings") &&
                                            <div class="actionNav">
                                              <i class="material-symbols-rounded mt-m grey">
                                                more_vert
                                              </i>
                                              <div class="dropMenuWrap">
                                                <ul
                                                  class="dropMenu"
                                                  style={{ width: "160px" }}
                                                >
                                                
                                                  <li>
                                                    {" "}
                                                    <a
                                                      onClick={() => {
                                                        editEV(
                                                          variant.name,
                                                          variant.image,
                                                          variant.battery_capacity,
                                                          variant.id
                                                        );
                                                      }}
                                                    >
                                                      Edit details
                                                    </a>{" "}
                                                  </li>
                                                  
                                                  <li>
                                                    {" "}
                                                    <a
                                                      onClick={() => {
                                                        deleteVehicle(
                                                          variant.name,
                                                          variant.image,
                                                          variant.battery_capacity,
                                                          variant.id,
                                                          i,
                                                          index
                                                        );
                                                      }}
                                                      class="open_model error"
                                                      data-target="deleteVehicleP"
                                                    >
                                                      Delete vehicle
                                                    </a>{" "}
                                                  </li>
                                                </ul>
                                              </div>
                                            </div>}
                                            <a>
                                              <img src={variant.image} alt="" />
                                              <em>{variant.name}</em>
                                              <span class="chargingCapicity">
                                                <i class="material-symbols-rounded">
                                                  battery_horiz_050
                                                </i>
                                                {variant.battery_capacity +
                                                  " kWh"}
                                              </span>
                                            </a>
                                          </li>
                                      </>
                                    );
                                  })}
                                </>
                              ) : (
                                "No varients"
                              )}
                            </ul>
                          </div>
                        </>
                      );
                    })}
                </>
              ) : (
                <>
                  <div class="boxType1">
                    <section>
                      <div class="head">
                        <p>No Model Found</p>
                      </div>
                    </section>
                  </div>
                </>
              )}
            </div>
          </div>
        </div>
      </>
    </>
  );
}
