import React from 'react'
import { useState, useEffect } from 'react';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import BrandListing from './BrandListing';
import { pageTitles } from '../../../configuration/GlobalConfig';
export default function Brands({ setshowSubComponent }) {
    document.title = pageTitles.BRAND;
    const [brands, setBrands] = useState("");
    const [searchValue, setSearchValue] = useState("");
    const axiosPrivate = useAxiosIntercept();
    useEffect(() => {
        let isMounted = true;
        const controller = new AbortController();
        const getbrands = async () => {
            let URL = process.env.REACT_APP_GET_VEHICLE_BRAND_LIST + "&show_variant_count=true&show_all=1";
            if (searchValue !== "") {
                URL = URL + `&search_by=brand_name&search_keyword=${searchValue}`

            }

            try {
                const response = await axiosPrivate.get(URL, {
                    signal: controller.signal,
                });
                isMounted && setBrands(response?.data?.response?.data?.brand_details);



            } catch (err) {

            }
        };
        getbrands();
        return () => {
            isMounted = false;
            controller.abort();

        };
    }, [searchValue]);
    return (
        <>


            <BrandListing brands={brands} setshowSubComponent={setshowSubComponent} searchValue={searchValue}
                setSearchValue={setSearchValue} setBrands={setBrands}
            />
        </>
    )
}
