import React, { useState } from 'react'
import Error from '../../UI/Error';
import { useEffect } from 'react';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import Button from '../../UI/Button';
import Message from '../../../utils/Message';
import instructions from "../../../assets/images/imageUploadInstructions.png"

const CreateBrand = ({ errors, setErrors }) => {
    const axiosPrivate = useAxiosIntercept();
    const [brandName, setbrandName] = useState("");
    const [brandImage, setBrandImage] = useState("");
    const [modelName, setmodelName] = useState("");
    const [variantName, setvariantName] = useState("");
    const [variantThumbnail, setvariantThumbnail] = useState("");
    const [variantBattery, setvariantBattery] = useState("");
    const [variantImage, setvariantImage] = useState("");
    const [thumbnail, setThumbnail] = useState("");
    const [msg, setMsg] = useState('');
    const [showMessage, setshowMessage] = useState(false);
    const [message, setMessage] = useState("");
    const [isSuccess, setIsSuccess] = useState(false);
    const [isSubmit, setisSubmit] = useState(false);
    const [showImage, setshowImage] = useState(false);
    const [showvariantimage, setshowvarianImage] = useState(false);
    const handleImage = (e) => {
        setshowImage(true);
        setBrandImage(e.target.files[0]);
        setThumbnail(URL.createObjectURL(e.target.files[0]));
        setErrors(() => {
            return {
                brandImageError: ""
            }
        })
    }
    const handlevariantImage = (e) => {
        setshowvarianImage(true);

        setvariantImage(e.target.files[0]);
        setvariantThumbnail(URL.createObjectURL(e.target.files[0]));


    }
    const handleInput = (e) => {
        setbrandName(e.target.value);
        setErrors(() => {
            return {
                brandNameError: ""
            }
        })
    }
    const removeImage = () => {
        setshowImage(false);
        setThumbnail("");
        setBrandImage("");
        setErrors({
            brandImageError: ""
        })
    };
    const removeVariantThumbnail = () => {
        setshowvarianImage(false);
        setvariantThumbnail("");
        setvariantImage("");
    }
    const onBackdropClick = () => {
        setshowMessage(false);
    }
    const submit = (e) => {
        e.preventDefault();
        setisSubmit(true);
        if (modelName == "") {

            setErrors(() => {
                return {
                    modelNameError: "Please Enter Model Name"
                }
            })
        }
        if (brandImage == "" && brandName == "") {

            setErrors(() => {
                return {
                    brandImageError: "Brand image is mandatory",
                    brandNameError: "Brand name is mandatory"
                }
            })
        }
        else if (brandName == "" && brandImage != "") {

            setErrors(() => {
                return {
                    brandNameError: "Brand name is mandatory",
                    brandImageError: ""
                }
            })
        }
        else if (brandName != "" && brandImage == "") {
            setErrors(() => {
                return {
                    brandImageError: "Brand image is mandatory",
                    brandNameError: ""
                }
            })
        }
        else {
            setErrors(() => {
                return {
                    brandImageError: "",
                    brandNameError: ""
                }

            })
        }
        const createBrand = async () => {

            try {
                const formData = new FormData();
                formData.append("brand_logo", brandImage);
                formData.append("brand_name", brandName);
                formData.append("model_name", modelName);
                formData.append("variant_image", variantImage);
                formData.append("variant_name", variantName);
                formData.append("battery_capacity", variantBattery);
                const config = { headers: { 'content-type': 'multipart/form-data' } }
                if (brandImage != "" && brandName != "" && modelName != "" && variantName != "" && variantBattery != "" && variantImage != "") {
                    const response = await axiosPrivate.post(
                        process.env.REACT_APP_CREATE_VEHICLE_BRAND,
                        formData,
                        config
                    );



                    if (response?.data?.message === "success") {
                        setshowMessage(true);
                        setMessage({
                            id: 1,
                            text: "Brand Created Successfully"
                        })
                        setMsg("data added successfully");
                        setIsSuccess(true);
                        setBrandImage("");
                        setmodelName("");
                        setvariantBattery("");
                        setvariantImage("");
                        setbrandName("");
                        setThumbnail("");
                        setvariantName("");
                        setvariantThumbnail("");
                        setisSubmit(false);
                    }
                    else if (response?.data?.response?.errors.length != 0) {
                        setIsSuccess(false);
                        setshowMessage(true);
                        setMessage({
                            id: 2,
                            text: response?.data?.response?.errors[0]?.message

                        })
                        setMsg(response?.data?.response?.errors[0]?.message)
                    }

                }


            }

            catch (err) {
                console.log(err);

            }
        }
        createBrand();

    }
    return (

        <>
            {showMessage && <Message message={message}
                errorLink="/settings/addnewbrand"
                successLink="/settings"
                errorValue="Try again"
                successValue="Go Back To Brands"
                isSuccess={isSuccess}
                onBackdropClick={onBackdropClick}


            />}

            <div class="subContent">
                <div class="settings">
                    <div class="brands newEV newBrand">
                        <div class="dForm w300">
                            <section class="brandDetailSection mb-24">
                                <h3 class="mb-24">Brand details</h3>
                                <div class="fieldGroup mt-0">
                                    <label>Brand name</label>
                                    <span className={errors.brandNameError ? "error" : ""}>
                                        <input type="text" placeholder="Enter brand name" name="brand_name" value={brandName} onChange={handleInput} />
                                    </span>
                                    <Error error={errors.brandNameError} />

                                </div>
                                <div class="fieldGroup">
                                    <label>Upload photo of brand</label>
                                    <div class="customFileUploader">
                                        {showImage ? <div class="csutomImgUploads">
                                            <span>
                                                <i class="material-symbols-rounded white arrowBottom mt-m arrow" onClick={removeImage}>delete</i>
                                                <img src={thumbnail} alt="" />
                                            </span>
                                        </div> : (<> <input type="file" id="actual-btn1" onChange={handleImage} />
                                            <label for="actual-btn1">
                                                <i class="material-symbols-rounded grey arrowBottom mt-l arrow">add_a_photo</i>
                                            </label>
                                        </>)}


                                    </div>
                                    <Error error={errors.brandImageError} />
                                    {/* <span style={{ color: "red" }}>{errors.brandImageError}</span> */}
                                </div>
                            </section>
                            <section class="vehicleDetailsSection pt-24">
                                <h3 class="mb-24">Vehicle details</h3>
                                <div class="rows">
                                    <div class="fieldGroup mt-0">
                                        <label>EV model</label>
                                        <span className={isSubmit && modelName == "" ? "error" : ""}>
                                            <input type="text" placeholder="Enter model name" name="model_name" value={modelName} onChange={(e) => { setmodelName(e.target.value) }} />
                                        </span>
                                        {isSubmit && modelName == "" && <Error error={"Model name is mandatory"} />}
                                        {/* {isSubmit && modelName == "" && <span style={{ color: "red" }}>Model name is mandatory </span>} */}

                                    </div>
                                    <div class="fieldGroup ml-24  mt-0 ">
                                        <label>EV variant</label>
                                        <span className={isSubmit && variantName == "" ? "error" : ""}>
                                            <input type="text" placeholder="Enter variant name" name="variant_name" value={variantName} onChange={(e) => { setvariantName(e.target.value) }} />
                                        </span>
                                        {isSubmit && variantName == "" && <Error error={"Variant name is mandatory"} />}
                                        {/* {isSubmit && variantName == "" && <span style={{ color: "red" }}>Variant name is mandatory </span>} */}
                                    </div>
                                    <div class="fieldGroup ml-24  mt-0 ">
                                        <label>Battery size</label>
                                        <span className={isSubmit && variantBattery == "" ? "error" : ""}>
                                            <input type="number" placeholder="Enter battery size" name="" value={variantBattery} onChange={(e) => { setvariantBattery(e.target.value) }} />
                                        </span>

                                        {isSubmit && variantBattery == "" && <Error error={"Variant battery capacity is mandatory"} />}
                                        {/* {isSubmit && variantBattery == "" && <span style={{ color: 'red' }}>Variant battery capacity is mandatory</span>} */}
                                    </div>
                                </div>

                                <h5 class="mb-8">Upload photo of EV</h5>
                                <div class="rows">
                                    <div class="fieldGroup mt-0">
                                        <div class="customFileUploader fullW">
                                            {showvariantimage ? <div class="csutomImgUploads">
                                                <span>
                                                    <i class="material-symbols-rounded white arrowBottom mt-m arrow" onClick={removeVariantThumbnail}>delete</i>
                                                    <img src={variantThumbnail} alt="" />
                                                </span>
                                            </div> : <><input type="file" id="actual-btn2" onChange={handlevariantImage} />
                                                <label for="actual-btn2">
                                                    <i class="material-symbols-rounded grey arrowBottom mt-l arrow">add_a_photo</i>
                                                </label></>}
                                        </div>
                                    </div>
                                    <div class="fieldGroup ml-24 mt-0 widthAuto imageDemo">
                                        <img src={instructions} alt="" />
                                    </div>
                                </div>
                                {isSubmit && variantImage == "" && <Error error={"Variant Image is Mandatory"} />}
                                {/* {isSubmit && variantImage == "" && <span style={{ color: "red" }}>Variant Image is Mandatory</span>} */}
                            </section>

                            <div class="actionButtons mt-24">
                                <span class="">
                                    <a class="btn prim" onClick={submit}>Add  this EV</a>
                                </span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}

export default CreateBrand;