import React from 'react'
import { useState } from 'react';
import { useParams } from 'react-router-dom'
import { useEffect } from 'react';
import CreateNewEV from './CreateNewEV';
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';

export default function CreateEVData() {

    const params = useParams();
    const axiosPrivate = useAxiosIntercept();
    const [brandData, setbrandData] = useState("");
    const [singlebrandData, setsinglebrandData] = useState("")

    useEffect(() => {
        let isMounted = true;
        const controller = new AbortController();
        const getBrandDetails = async () => {
            const GETSINGLEBRAND = process.env.REACT_APP_GET_VEHICLE_BRAND_LIST + `&brand_id=${params.brand_id}&show_all=true`
            const URL = process.env.REACT_APP_GET_MODEL_LIST + "&variants=true";
            try {
                const response = await axiosPrivate.get(
                    URL + `&brand_id=${params.brand_id}`,
                    {
                        signal: controller.signal,

                    }
                );
                const brand = await axiosPrivate.get(
                    GETSINGLEBRAND,
                    {
                        signal: controller.signal
                    }

                )

                if (response.data.status === 200) {
                    isMounted && setbrandData(response?.data?.response?.data);


                } else {
                    setbrandData("");
                }
                if (brand?.data?.status === 200) {
                    isMounted && setsinglebrandData(brand?.data?.response?.data?.brand_details[0])


                }
                else {
                    setsinglebrandData("");

                }
            } catch (err) {

            }
        };
        if (isMounted) {
            getBrandDetails();
        }

        return () => {
            isMounted = false;
            controller.abort();
        };
    }, []);
    return (
        <>
            <CreateNewEV brandData={brandData} singlebrandData={singlebrandData} />
        </>
    )
}
