import React from "react";
import { useRef } from "react";
import { useState } from "react";
import { FormatDate } from "../../../utils/FormatDate";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import { useNavigate } from "react-router-dom";
import { useParams } from "react-router-dom";
import Message from "../../../utils/Message";
import loader from "../../../assets/images/spinner.gif";
import Spinner from "../../UI/Spinner";
import { useFormInputValidation } from "react-form-input-validation";
import useOutsideClick from "../../../hooks/useOutsideClick";
import instructions from "../../../assets/images/imageUploadInstructions.png";
import Error from "../../UI/Error";

export default function CreateNewEV({ brandData, singlebrandData }) {
  const params = useParams();
  const navigate = useNavigate();
  const modelRef = useRef();
  const axiosPrivate = useAxiosIntercept();
  const [errors, setErrors] = useState({
    modelIdError: "Please Select Model",
    variantNameError: "Variant Name is Mandatory",
    batterySizeError: "Battery Size is Mandatory",
    imageError: "Variant Image is Mandatory",
    modelNameError: "Model name is Required ",
  });
  const [isRadioSelected, setisRadioSelected] = useState("");
  const modelList = brandData?.models;
  const [isSelected, setisSelected] = useState(false);
  const [selectedOption, setselectedOption] = useState("");
  const [modelName, setmodelName] = useState("");
  const [variantName, setVariantName] = useState("");
  const [batterySize, setBatterySize] = useState("");
  const [modelId, setModelId] = useState("");
  const [thumbnail, setThumbnail] = useState("");
  const [image, setImage] = useState("");
  const [modelLabel, setmodelLabel] = useState("");
  const [showMessage, setshowMessage] = useState(false);
  const [message, setMessage] = useState("");
  const [isSuccess, setIsSuccess] = useState(false);
  const [showErrors, setShowErrors] = useState(false);
  const [showImage, setshowImage] = useState(false);
  const [isModelSelected, setisModelSelected] = useState(true);
  const showDropDown = () => {
    setisSelected(!isSelected);
  };
  const selecteOption = (e, name) => {
    setisRadioSelected(false);
    setmodelName("");
    setisModelSelected(true);
    setModelId(e.target.id);
    setisSelected(false);
    setselectedOption(e.target.id);
    setmodelLabel(name);
  };
  const handleImage = (e) => {
    setshowImage(true);
    setImage(e.target.files[0]);
    setThumbnail(URL.createObjectURL(e.target.files[0]));
  };
  const removeImage = () => {
    setshowImage(false);
    setThumbnail("");
    setImage("");
  };
  const onBackdropClick = () => {
    setshowMessage(false);
  };
  const createModel = (e) => {
    setmodelLabel("Select Model");
    setselectedOption("");
    setisModelSelected(false);
    setisRadioSelected(!isRadioSelected);
  };
  useOutsideClick(modelRef, () => {
    if (isSelected) {
      setisSelected(false);
    }
  });

  const submit = async () => {
    const formData = new FormData();
    if (isRadioSelected === true && modelName !== "") {
      formData.append("model_name", modelName);
      formData.append("brand_id", singlebrandData?.id);
      setModelId("");
    } else {
      formData.append("model_id", modelId);
    }

    formData.append("variant_name", variantName);
    formData.append("battery_capacity", batterySize);
    formData.append("variant_image", image);
    formData.append("mode", "variant");
    const URL = process.env.REACT_APP_ADD_NEW_VARIANT;
    const config = { headers: { "content-type": "multipart/form-data" } };
    setShowErrors(true);

    if (
      (modelId != "" || modelName != "") &&
      variantName != "" &&
      batterySize != "" &&
      image != ""
    ) {
      const response = await axiosPrivate.post(URL, formData, config);
      if (response?.data?.status == "200") {
        setisRadioSelected(false);
        setshowMessage(true);
        setMessage({
          id: 1,
          text: "EV created Successfully",
        });
        setIsSuccess(true);
        setImage("");
        setVariantName("");
        setmodelName("");
        setmodelLabel("");
        setBatterySize("");
        setThumbnail("");
        setErrors({
          modelIdError: "",
          modelNameError: "",
          batterySizeError: "",
          variantNameError: "",
          imageError: "",
        });
      } else {
        setIsSuccess(false);
        setshowMessage(true);
        setMessage({
          id: 2,
          text: response?.data?.response?.errors[0]?.message,
        });
      }
    }
  };
  return (
    <>
      {showMessage && (
        <Message
          message={message}
          isSuccess={isSuccess}
          successValue="Go Back To Variant Listing"
          successLink={`/settings/branddetails/${params.brand_id}`}
          errorValue="Try again"
          errorLink={`/settings/addnewEV/${params.brand_id}`}
          onBackdropClick={onBackdropClick}
        />
      )}

      <h2>
        <a style={{ cursor: "pointer" }}>
          <span
            class="material-symbols-rounded mt-l black"
            onClick={(e) => {
              navigate(-1);
            }}
          >
            arrow_back
          </span>
        </a>
        Add new EV
      </h2>
      <div class="subContent">
        <div class="settings">
          <div class="brands newEV">
            <div class="searchPanel vehicleHead mb-24">
              <div class="searchBar">
                <div class="userInfo">
                  <div class="imgBlock">
                    <div>
                      <img src={singlebrandData?.image} alt="" />
                    </div>
                  </div>
                  <div class="name">
                    <h2 class="mb-0">{singlebrandData?.name}</h2>
                    <span>
                      Added on {FormatDate(singlebrandData?.created_at)}
                    </span>
                  </div>
                </div>
              </div>
            </div>
            <form></form>
            <div class="dForm w300">
              <section>
                <div class="rows">
                  <div class="fieldGroup mt-0">
                    <label>EV model</label>
                    <div class="multiOption">
                      <div
                        class={
                          isSelected
                            ? "selectBox fullWidth open"
                            : "selectBox fullWidth"
                        }
                        onClick={showDropDown}
                        ref={modelRef}
                      >
                        <p>
                          {modelLabel ? modelLabel : "Select Model"}{" "}
                          <i
                            class="material-symbols-rounded grey"
                            style={{ marginLeft: "auto" }}
                          >
                            expand_more
                          </i>
                        </p>
                        <div class="selectDrop customScroll hFix">
                          <ul class="dropMenu">
                            <li class="selected">
                              <a
                                id=""
                                name="Select Model"
                                value="Select Model"
                                onClick={(e) => {
                                  selecteOption(e, "Select Models");
                                }}
                              >
                                Select Model
                              </a>
                            </li>
                            {modelList && modelList?.length > 0 ? (
                              <>
                                {modelList.map((models) => {
                                  return (
                                    <>
                                      <li class="selected">
                                        <a
                                          onClick={(e) => {
                                            selecteOption(e, models.name);
                                          }}
                                          id={models.id}
                                        >
                                          {models.name}

                                          {selectedOption == models.id ? (
                                            <>
                                              <i class="material-symbols-rounded">
                                                done
                                              </i>
                                            </>
                                          ) : (
                                            ""
                                          )}
                                        </a>
                                      </li>
                                    </>
                                  );
                                })}
                              </>
                            ) : (
                              ""
                            )}
                          </ul>
                        </div>
                        {isModelSelected && modelId == "" && showErrors && (
                          <Error error={errors.modelIdError} />
                        )}
                        {/* {isModelSelected && modelId == "" && showErrors && <span style={{ color: "red" }}>{errors.modelIdError && errors.modelIdError}</span>} */}
                      </div>
                    </div>
                  </div>
                  <div class="fieldGroup ml-24  mt-0 ">
                    <label>EV variant</label>
                    <span className={showErrors && variantName == "" ? "error" : ""}>
                      <input
                        type="text"
                        value={variantName}
                        placeholder="Enter variant name"
                        name="name"
                        onChange={(e) => {
                          setVariantName(e.target.value);
                        }}
                      />
                    </span>
                    {showErrors && variantName == "" && (
                      <Error error={errors.variantNameError} />
                    )}
                    {/* {showErrors && variantName == "" && <span style={{ color: "red" }}>{errors.variantNameError}</span>} */}
                  </div>
                  <div class="fieldGroup ml-24  mt-0 ">
                    <label>Battery size</label>
                    <span className={showErrors && batterySize == "" ? "error" : ""}>
                      <input
                        type="number"
                        value={batterySize}
                        onChange={(e) => {
                          setBatterySize(e.target.value);
                        }}
                        placeholder="Enter battery size"
                        name="battery"
                      />
                    </span>
                    {showErrors && batterySize == "" && (
                      <Error error={errors.batterySizeError} />
                    )}
                    {/* {showErrors && batterySize == "" && <span style={{ color: "red" }}> {errors.batterySizeError}</span>} */}
                  </div>
                </div>
                <div class="fieldGroup mt-0 mb-24">
                  <ul class="">
                    <li>
                      <input
                        onClick={createModel}
                        type="radio"
                        id="yTypeRadio41"
                        name="sd"
                        checked={isRadioSelected}
                      />
                      <label for="yTypeRadio41">Create new model</label>
                    </li>
                    {isRadioSelected && (
                      <li>
                        <span class={isRadioSelected && showErrors && modelName == "" ? "error" : ""}>
                          <input
                            type="text"
                            placeholder="Enter new Model"
                            name="name"
                            value={modelName}
                            onChange={(e) => {
                              setmodelName(e.target.value);
                            }}
                          />
                        </span>
                      </li>
                    )}
                    <br />
                    {isRadioSelected && showErrors && modelName == "" && (
                      <Error error={errors.modelNameError} />
                    )}
                    {/* {isRadioSelected && showErrors && modelName == "" && <span style={{ color: 'red' }}>{errors.modelNameError}</span>} */}
                  </ul>
                </div>
                <h5 class="mb-8">Upload photo of EV</h5>
                <div class="rows">
                  <div class="fieldGroup mt-0">
                    <div class="customFileUploader fullW">
                      {showImage ? (
                        <div class="csutomImgUploads">
                          <span>
                            <i
                              class="material-symbols-rounded white arrowBottom mt-m arrow"
                              onClick={removeImage}
                            >
                              delete
                            </i>
                            <img src={thumbnail} alt="" />
                          </span>
                        </div>
                      ) : (
                        <>
                          <input
                            type="file"
                            id="actual-btn"
                            onChange={handleImage}
                          />
                          <label for="actual-btn">
                            <i class="material-symbols-rounded grey arrowBottom mt-l arrow">
                              add_a_photo
                            </i>
                          </label>
                        </>
                      )}
                    </div>
                  </div>
                  <div class="fieldGroup ml-24 mt-0 widthAuto imageDemo">
                    <img src={instructions} alt="" />
                  </div>
                </div>
                {showErrors && image == "" && (
                  <Error error={errors.imageError} />
                )}
                {/* {showErrors && image == "" && <span style={{ color: "red" }}>{errors.imageError}</span>} */}
              </section>
              <div class="actionButtons mt-24">
                <span class="">
                  <a onClick={submit} class="btn prim">
                    Add this EV
                  </a>
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
