import React from 'react'
import { useState } from 'react';
import { useNavigate } from 'react-router-dom';
import { axiosPrivate } from '../../../api/PrivateRequestServices';
import Overlay from '../../../utils/Overlay'
export default function DeleteVehiclePopUp({ onBackdropClick, variantDetails, setdeleteVehiclepopup, reasons, brandDetails, setbrandDetails }) {

    const [reason_id, setreasonid] = useState("");

    const closepopup = () => {
        setdeleteVehiclepopup(false);
        document.body.classList.remove('hidden');

    }
    const [message, setMessage] = useState();
    const handleinput = (e) => {
        setreasonid(e.target.id);

    }
    const deleteVehicle = async () => {
        const URL = process.env.REACT_APP_UPDATE_MODEL;
        const body = {
            reason_id: reason_id,
            mode: "variant",
            variant_id: variantDetails.variant_id,
            status: "0"
        }


        const response = await axiosPrivate.post(URL, body);
        if (response?.data?.status == "200") {
            let brand_details_temp = brandDetails;

            brand_details_temp.models[variantDetails?.modelIndex]?.variants.splice(variantDetails?.variantIndex, 1)
            setbrandDetails(brand_details_temp);
            setdeleteVehiclepopup(false);

        }
        else {
            setMessage(response?.data?.response?.errors[0]?.message);
        }








    }
    return (
        <>
            <Overlay onBackdropClick={onBackdropClick}>

                <div class="model_box_child deleteVehicleP" id="deleteVehicleP" style={{ width: "340px" }}>
                    <div class="ap_heading">
                        <h4>Delete vehicle <span class="material-symbols-rounded black close_model" onClick={closepopup} style={{ marginLeft: "auto" }}>close</span></h4>
                    </div>
                    <div class="contentSection">
                        <section class="dForm">
                            <div class="fieldGroup mt-0">
                                <label>Select reason to delete</label>
                                <div class="brandLists">
                                    <ul>
                                        <li>
                                            <a href="javascript:void(0);">
                                                <img src={variantDetails.variant_image} alt="" />
                                                <em>{variantDetails.variant_name}</em>
                                                <span class="chargingCapicity"><i class="material-symbols-rounded">
                                                    battery_horiz_050
                                                </i>{variantDetails.variant_battery + " kWh"}</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                                <ul class="yType">
                                    {reasons && reasons.length > 0 ? (<>
                                        {reasons.map((reason) => {
                                            return (<>
                                                <li>
                                                    <input onClick={handleinput} type="radio" id={reason.reason_id} name="radio" value={reason.reason} />
                                                    <label for={reason.reason_id}>{reason.reason}</label>

                                                </li>

                                            </>
                                            )

                                        })}


                                    </>) : (<></>)}



                                </ul>
                            </div>
                        </section>
                        <div class="actionButtons mt-24">
                            <span>
                                <a onClick={deleteVehicle} class="btn prim btnError fullW">Delete vehicle</a>
                            </span>
                            {message && <span style={{ color: "red" }}>{message}</span>}
                        </div>
                    </div>
                </div>

            </Overlay>
        </>
    )
}
