import React from "react";
import { Navigate, useNavigate } from "react-router-dom";
import { useState } from "react";
import { FormatDate } from "../../../utils/FormatDate";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Message from "../../../utils/Message";
import { useParams } from "react-router-dom";

import Instructions from "../../../assets/images/imageUploadInstructions.png";
export default function EditEV({
  brandDetails,
  setShowEditEVComponent,
  variantDetails,
}) {
  const params = useParams();
  const navigate = useNavigate();
  const axiosPrivate = useAxiosIntercept();
  const [thumbnail, setThumbnail] = useState("");
  const [variantName, setvariantName] = useState(variantDetails?.variant_name);
  const [battery, setBattery] = useState(variantDetails?.variant_battery);
  const [image, setImage] = useState();
  const [isSuccess, setIsSuccess] = useState(false);
  const [message, setMessage] = useState("");
  const [showMessage, setshowMessage] = useState(false);
  const [showImage, setshowImage] = useState(false);
  const handleImage = (e) => {
    setshowImage(true);
    setImage(e.target.files[0]);
    setThumbnail(URL.createObjectURL(e.target.files[0]));
  };
  const removeImage = () => {
    setshowImage(false);
    setThumbnail("");
    setImage("");
    variantDetails.variant_image = "";
  };

  const editEV = (e) => {
    e.preventDefault();
    const editDetails = async () => {
      try {
        const URL = process.env.REACT_APP_UPDATE_MODEL;
        const formData = new FormData();
        formData.append("variant_name", variantName);

        if (image !== undefined && image != "") {
          formData.append("variant_image", image);
        }
        formData.append("battery_capacity", battery);
        formData.append("mode", "variant");
        formData.append("variant_id", variantDetails?.variant_id);
        const config = { headers: { "content-type": "multipart/form-data" } };
        const response = await axiosPrivate.post(URL, formData, config);

        if (response?.status == "200") {
          setshowMessage(true);
          setMessage({
            id: 1,
            text: "EV Updated Successfully",
          });
          setIsSuccess(true);
        }
      } catch (err) {
        console.log(err);
      }
    };
    editDetails();
  };
  const onBackdropClick = () => {
    setshowMessage(false);
  };

  return (
    <>
      {showMessage && (
        <Message
          message={message}
          isSuccess={isSuccess}
          successValue="Go Back To Variants"
          errorValue="Try again"
          successLink={`/settings/branddetails/${params.brand_id}`}
          errorLink="/settings/addnewbrand"
          onBackdropClick={onBackdropClick}
          setshowMessage={setshowMessage}
        />
      )}
      <h2>
        <a
          onClick={() => {
            setShowEditEVComponent(false);
          }}
          style={{ cursor: "pointer" }}
        >
          <span class="material-symbols-rounded mt-l black">arrow_back</span>
        </a>
        Edit EV
      </h2>
      <div class="subContent">
        <div class="settings">
          <div class="brands newEV">
            <div class="searchPanel vehicleHead mb-24">
              <div class="searchBar">
                <div class="userInfo">
                  <div class="imgBlock">
                    <div>
                      <img src={brandDetails?.brand_logo} alt="" />
                    </div>
                  </div>
                  <div class="name">
                    <h2 class="mb-0">{brandDetails?.brand_name}</h2>
                    <span>{FormatDate(brandDetails?.created_at)}</span>
                  </div>
                </div>
              </div>
            </div>
            <div class="dForm w300">
              <section>
                <div class="rows">
                  <div class="fieldGroup mt-0">
                    <label>EV model &amp; variant</label>
                    <span>
                      <input
                        type="text"
                        placeholder={variantDetails?.variant_name}
                        value={variantName}
                        name="name"
                        onChange={(e) => {
                          setvariantName(e.target.value);
                        }}
                        disabled="true"
                      />
                    </span>
                  </div>
                  <div class="fieldGroup ml-24  mt-0 ">
                    <label>Battery size</label>
                    <span>
                      <input
                        type="text"
                        placeholder={variantDetails?.variant_battery + " kWh"}
                        name="battery"
                        value={battery + " kWh"}
                        onChange={(e) => {
                          setBattery(e.target.value);
                        }}
                        disabled="true"
                      />
                    </span>
                  </div>
                </div>
                <h5 class="mb-8">Upload photo of EV</h5>
                <div class="rows">
                  <div class="fieldGroup mt-0">
                    <div class="customFileUploader fullW">
                      {showImage || variantDetails?.variant_image ? (
                        <>
                          <div class="csutomImgUploads">
                            <span>
                              <i
                                class="material-symbols-rounded white arrowBottom mt-m arrow"
                                onClick={removeImage}
                              >
                                delete
                              </i>

                              <img
                                src={
                                  thumbnail
                                    ? thumbnail
                                    : variantDetails?.variant_image
                                }
                                alt=""
                              />
                            </span>
                          </div>
                        </>
                      ) : (
                        <>
                          <input
                            type="file"
                            id="actual-btn"
                            onChange={handleImage}
                          />
                          <label for="actual-btn">
                            <i class="material-symbols-rounded grey arrowBottom mt-l arrow">
                              add_a_photo
                            </i>
                          </label>
                        </>
                      )}
                    </div>
                  </div>
                  <div class="fieldGroup ml-24 mt-0 widthAuto imageDemo">
                    <img src={Instructions} alt="" />
                  </div>
                </div>
              </section>
              <div class="actionButtons mt-24">
                <span class="">
                  <a onClick={editEV} class="btn prim">
                    Save changes
                  </a>
                </span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </>
  );
}
