import React, { useState } from "react";
import Overlay from "../../../utils/Overlay";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import Error from "../../UI/Error";
export default function InactiveBrandPopUp({
  reasons,
  brandId,
  setshowInactiveBrand,
  onBackdropClick,
  brandName,
  setshowSubComponent,
  index,
}) {
  const axiosPrivate = useAxiosIntercept();
  const [reason_id, setreasonid] = useState();
  const handleinput = (e) => {
    setreasonid(e.target.id);
  };
  const [message, setMessage] = useState();
  const closepopup = () => {
    document.body.classList.remove("hidden");
    setshowInactiveBrand(false);
  };
  const markbrandInactive = async () => {
    const body = {
      reason_id: reason_id,
      brand_id: brandId,
      status: "0",
    };

    const response = await axiosPrivate.post(
      process.env.REACT_APP_UPDATE_VEHICLE_BRAND,
      body
    );
    if (response?.data?.status == "200") {
      onBackdropClick(true, index);
      setshowInactiveBrand(false);
      setshowSubComponent({
        brandsTab: true,
      });
    } else {
      setMessage(response?.data?.response?.errors[0]?.message);
    }
  };
  return (
    <>
      <Overlay onBackdropClick={onBackdropClick}>
        <div
          class="model_box_child MarkInactiveP"
          id="MarkInactiveP"
          style={{ width: "300px" }}
        >
          <div class="ap_heading">
            <h4>
              Mark brands as inactive{" "}
              <span
                class="material-symbols-rounded black close_model"
                onClick={closepopup}
                style={{ marginLeft: "auto" }}
              >
                close
              </span>
            </h4>
          </div>
          <div class="contentSection">
            <section class="assignPromoP dForm">
              <div class="promoText customer">
                <h4>{brandName}</h4>
              </div>
              <div class="fieldGroup">
                <label>Select reason to mark inactive</label>
                <ul class="yType">
                  {reasons && reasons?.length > 0 ? (
                    <>
                      {reasons?.map((reason) => {
                        return (
                          <>
                            <li>
                              <input
                                onClick={handleinput}
                                type="radio"
                                id={reason.reason_id}
                                name="radio"
                                value={reason.reason}
                              />
                              <label for={reason.reason_id}>
                                {reason.reason}
                              </label>
                            </li>
                          </>
                        );
                      })}
                    </>
                  ) : (
                    ""
                  )}
                </ul>
              </div>
            </section>
            <div class="actionButtons mt-24">
              <span>
                <a class="btn prim btnError fullW" onClick={markbrandInactive}>
                  Mark inactive
                </a>
              </span>
              {message && <Error error={message} />}
              {/* {message && <span style={{ color: "red" }}>{message}</span>} */}
            </div>
          </div>
        </div>
      </Overlay>
    </>
  );
}
