import React from 'react'
import { useState, useEffect } from 'react'
import { useParams } from 'react-router-dom'
import useAxiosIntercept from '../../../hooks/useAxiosIntercept';
import BrandModelAndVarientsListing from './BrandModelAndVarientsListing';
import EditEV from "./EditEV";
export default function ViewBrandDetails() {
    const params = useParams();
    const axiosPrivate = useAxiosIntercept();
    const [brandDetails, setbrandDetails] = useState("");
    const [deleteVehiclepopup, setdeleteVehiclepopup] = useState(false);
    const onBackdropClick = () => {
        setdeleteVehiclepopup(false);
    }
    const [singlebrandData, setsinglebrandData] = useState("")
    const [showEditEVComponent, setShowEditEVComponent] = useState(false);
    const [variantDetails, setvariantDetails] = useState({
        variant_name: "",
        variant_image: "",
        variant_battery: "",
        variant_id: "",
        modelIndex: "",
        variantIndex: ""
    });

    useEffect(() => {
        let isMounted = true;
        const controller = new AbortController();
        const getBrandDetails = async () => {
            const GETSINGLEBRAND = process.env.REACT_APP_GET_VEHICLE_BRAND_LIST + `&brand_id=${params.brand_id}&show_all=true`
            const URL = process.env.REACT_APP_GET_MODEL_LIST + "&variants=true";
            try {
                const response = await axiosPrivate.get(
                    URL + `&brand_id=${params.brand_id}`,
                    {
                        signal: controller.signal,

                    }
                );
                const brand = await axiosPrivate.get(
                    GETSINGLEBRAND,
                    {
                        signal: controller.signal
                    }

                )


                if (response.data.status === 200) {

                    isMounted && setbrandDetails(response?.data?.response?.data);

                } else {

                    setbrandDetails("");
                }
                if (brand?.data?.status === 200) {
                    isMounted && setsinglebrandData(brand?.data?.response?.data?.brand_details)

                }
                else {
                    setsinglebrandData("");

                }
            } catch (err) {

            }
        };
        if (isMounted) {
            getBrandDetails();
        }

        return () => {
            isMounted = false;
            controller.abort();
        };
    }, []);

    return (
        <>
            {showEditEVComponent ? <EditEV brandDetails={brandDetails} setShowEditEVComponent={setShowEditEVComponent} variantDetails={variantDetails} /> : <BrandModelAndVarientsListing brandDetails={brandDetails} onBackdropClick={onBackdropClick}
                setdeleteVehiclepopup={setdeleteVehiclepopup} deleteVehiclepopup={deleteVehiclepopup} setvariantDetails={setvariantDetails} variantDetails={variantDetails} setbrandDetails={setbrandDetails}
                setShowEditEVComponent={setShowEditEVComponent} singlebrandData={singlebrandData}
            />}


        </>
    )
}
