import React from "react";
import { useState, useEffect } from "react";
import { Link } from "react-router-dom";
//import { pageTitles } from "../../../configuration/GlobalConfig";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import responseHandler from "../../../services/responseHandler";
import { messages } from "../../../configuration/GlobalConfig";
import { HourMapping } from "../../../configuration/createPackageFormConfigs";
import UpdateCancellationCharge from "./UpdateCancellationCharge";
import useAuth from "../../../hooks/useAuth";
const CancellationCharge = ({hideSettings, handleHideSettings}) => {
  const axiosPrivate = useAxiosIntercept();
  const { auth } = useAuth();
  const [cancellationCharge, setCancellationCharge] = useState([]);
  const [error, setError] = useState("");
  const [openPopup, setOpenPopup] = useState(false);
  const [success, setSuccess] = useState(false);
  const [showPopup, setShowPopup] = useState({
    payAsuGo: false,
    member: false,
    emergency: false,
  });
  const onBackdropClick = () => {
    document.body.classList.remove("hidden");
    setOpenPopup(false);
  };
  const [value, setValue] = useState("");
  const handelPopup = (e) => {
    setShowPopup({ [e.currentTarget.id]: true });
    setValue(e.currentTarget.id);
    setOpenPopup(true);
  };
  useEffect(() => {
    let isMounted = true;
    const controller = new AbortController();
    let response = {};
    const getChargeAndTaxes = async () => {
      let URL = process.env.REACT_APP_GET_ATTENDANT_INCENTIVE;
      const request = {
        config_data: [
          {
            site: "admin",
            module: "settings",
            config_key: "cancellation_charges",
          },
        ],
      };
      try {
        const { data } = await axiosPrivate.post(URL, request);

        if (data?.status === 200 && isMounted) {
          response = responseHandler(data, "API_SUCCESS");

          let json_value = response?.response?.data[0].value;
          let jsonObj = JSON.parse(json_value);

          setCancellationCharge(jsonObj);
        } else {
          response = responseHandler(data, "API_ERROR");
          //Handler Error Here...
          setError(messages.API_ERROR);
        }
      } catch (err) {
        response = responseHandler(err, "NETWORK_ERROR");
        //Handler Error Here...
        setError(messages.NETWORK_ERROR);
      }
    };

    isMounted && getChargeAndTaxes();

    return () => {
      isMounted = false;
      controller.abort();
    };
  }, [success]);
  // document.title = pageTitles.GENERAL;
  const cancellationKey =
    value == "payAsuGo"
      ? "pay_as_you_go"
      : value == "member"
      ? "members"
      : "emergency";
  const { cancellation_payg, cancellation_members } = cancellationCharge;
  const cancellationValue =
    cancellationCharge &&
    cancellationCharge?.[cancellationKey]?.cancellation_allowed;
  return (
    <div class="boxT1">
      <div class="item">
        <div class="text">
          <h4>Cancellation charge</h4>
          <span>Manage the cancellation charge of all types of accounts</span>
        </div>
        <i className={hideSettings.cancellation_charge === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"} 
            onClick={() => handleHideSettings("cancellation_charge")}      
        >expand_more</i>
      </div>
      <div class="tableList mt-16" style={hideSettings.cancellation_charge === true ? {
            display:"none"
        } : {
            display:"block"
        }}>
        <div>
          <h5>Service fee</h5>
          <table class="widthAuto">
            <tbody>
              <tr>
                <td>
                  <span>Pay as you go</span>
                  <span class="time">
                    {cancellationCharge?.pay_as_you_go?.cancellation_allowed ==
                    "1" ? (
                      <>
                        {`
                        ${
                          cancellationCharge?.pay_as_you_go?.data
                            ?.cancellation_window?.value + " "
                        }${
                          HourMapping[
                            cancellationCharge?.pay_as_you_go?.data
                              ?.cancellation_window?.unit
                          ]
                        }, 
                        ${
                          " $" +
                          cancellationCharge?.pay_as_you_go?.data
                            ?.cancellation_charge
                        }
                    `}
                      </>
                    ) : (
                      <>Cannot cancel</>
                    )}
                    {auth.priviliges.includes("write_settings") &&
                      <Link
                        class="open_model"
                        data-target="CancellationCharge1"
                        onClick={(e) => handelPopup(e)}
                        id="payAsuGo"
                      >
                        Manage
                      </Link>}
                  </span>
                </td>
                <td>
                  <span>Members</span>
                  <span class="time">
                    {cancellationCharge?.members?.cancellation_allowed ==
                    "1" ? (
                      <>
                        {`
                        ${
                          cancellationCharge?.members?.data?.cancellation_window
                            ?.value + " "
                        }${
                          HourMapping[
                            cancellationCharge?.members?.data
                              ?.cancellation_window?.unit
                          ]
                        }, 
                        ${
                          " " +
                          cancellationCharge?.members?.data?.cancellation_charge +
                          " booking"
                        }
                    `}
                      </>
                    ) : (
                      <>Cannot cancel</>
                    )}
                    {auth.priviliges.includes("write_settings") &&
                      <a
                        class="open_model"
                        href="javascript:void(0);"
                        data-target="CancellationCharge1"
                        onClick={(e) => handelPopup(e)}
                        id="member"
                      >
                        Manage
                      </a>}
                  </span>
                </td>
                <td>
                  <span>Emergency</span>
                  <span class="time">
                    {cancellationCharge?.emergency?.cancellation_allowed ==
                    "1" ? (
                      <>
                        {`
                        ${
                          cancellationCharge?.emergency?.data
                            ?.cancellation_window?.value + " "
                        }${
                          HourMapping[
                            cancellationCharge?.emergency?.data
                              ?.cancellation_window?.unit
                          ]
                        }, 
                        ${
                          " $" +
                          cancellationCharge?.emergency?.data
                            ?.cancellation_charge
                        }
                    `}
                      </>
                    ) : (
                      <>Cannot cancel</>
                    )}
                    {auth.priviliges.includes("write_settings") &&
                      <a
                        onClick={(e) => handelPopup(e)}
                        id="emergency"
                        class="open_model"
                        href="javascript:void(0);"
                        data-target="CancellationCharge1"
                      >
                        Manage
                      </a>}
                  </span>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
      {showPopup?.[value] && (
        <UpdateCancellationCharge
          cancellationCharge={cancellationCharge}
          value={value}
          openPopup={openPopup}
          success={success}
          setSuccess={setSuccess}
          onBackdropClick={onBackdropClick}
        />
      )}
    </div>
  );
};

export default CancellationCharge;
