import React from "react";
import { useState } from "react";
import { useEffect } from "react";
import CancellationCharge from "./CancellationCharge";
import ChargeRate from "./ChargeRate";
import Surcharge from "./Surcharge";
import useAxiosIntercept from "../../../hooks/useAxiosIntercept";
import NoPriviliges from "../../UI/NoPriviliges";
import useAuth from "../../../hooks/useAuth";

const ChargeAndTaxes = () => {
  const [data, setData] = useState("");
  const { auth } = useAuth();
  const [isSuccess, setisSuccess] = useState(false);
  const [hideSettings, setHideSettings] = useState({ charge_rate: true, surcharge: true, cancellation_charge: true });
  const handleHideSettings = (type) => {
    let currentData = { ...hideSettings };
    currentData[type] = !currentData[type];
    setHideSettings(currentData);
  };
  const axiosPrivate = useAxiosIntercept();
  const getData = async () => {
    const URL = process.env.REACT_APP_GET_CHARGES_AND_TAXES;
    const body = {

      config_data: [{
        "site": "admin",
        "module": "settings",
        "config_key": "global_gst"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "global_parking_charge"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "global_charge_rate"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "charge_rate_emergency_members"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "charge_rate_emergency_non_members"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "service_fee_emergency_members"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "service_fee_emergency_non_members"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "service_fee_payg_with_addon"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "service_fee_payg_without_addon"
      },
      {
        "site": "admin",
        "module": "settings",
        "config_key": "service_fee_members_global"
      }
      ]

    }
    const response = await axiosPrivate.post(URL, body);
    if (response?.data?.status == "200") {
      setData(response?.data?.response?.data)
    }


  }
  useEffect(() => {
    getData();

  }, [isSuccess])
  return (
    <>
      {auth.priviliges.includes("read_settings")?
      <div class="yRow mt-24 rowLists">
        <ChargeRate data={data} setisSuccess={setisSuccess} isSuccess={isSuccess}
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
        <Surcharge data={data} setisSuccess={setisSuccess} isSuccess={isSuccess}
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
        <CancellationCharge
          hideSettings={hideSettings}
          handleHideSettings={handleHideSettings}
        />
      </div>:<NoPriviliges/>}
    </>
  );
};

export default ChargeAndTaxes;
