import React from "react";
import ParseJson from "../../../utils/ParseJson";
import { getType } from "../../../utils/ParseJson";
import UpdateChargeRate from "./UpdateChargeRate";
import { useState } from "react";
import useAuth from "../../../hooks/useAuth";
const ChargeRate = ({ data, setisSuccess, isSuccess, hideSettings, handleHideSettings}) => {
  const [updateChargeRate, setupdateChargeRate] = useState(false);
  const { auth } = useAuth();
  const [updateChargeRateEmergency, setupdateChargeRateEmergency] = useState(false);
  const [updateChargeRateNonEmergency, setupdateChargeRateNonEmergency] = useState(false);
  // const [updateEmergencyChargeRate,setupdate]
  const global_charge_rate = data ? data?.global_charge_rate?.value : "";
  const charge_rate_emergency_members = data ? ParseJson(data.charge_rate_emergency_members.value) : "";
  const charge_rate_emergency_non_members = data ? ParseJson(data.charge_rate_emergency_non_members.value) : ""
  const global_charge_rate_type = data ? data?.global_charge_rate?.type : ""
  const charge_rate_emergency_members_type = data ? getType(data.charge_rate_emergency_members.value) : "";
  const charge_rate_emergency_non_members_type = data ? getType(data.charge_rate_emergency_non_members.value) : ""



  return (
    <>

      {updateChargeRate && <UpdateChargeRate setupdateChargeRate={setupdateChargeRate} membertype={"Global"} configkey="global_charge_rate" charge_rate={global_charge_rate} type={"F"} heading={"Manage charge rate"} subheading={"Charge rate/kWh"} close={setupdateChargeRate} btn_value={'Update charge rate'} setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {updateChargeRateEmergency && <UpdateChargeRate setupdateChargeRate={setupdateChargeRate} membertype={"Emergency(For Members)"} configkey="charge_rate_emergency_members" charge_rate={charge_rate_emergency_members} type={charge_rate_emergency_members_type} heading={"Manage charge rate"} subheading={"Charge rate/kWh"} close={setupdateChargeRateEmergency} btn_value={'Update charge rate'} setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {updateChargeRateNonEmergency && <UpdateChargeRate membertype={"Emergency(For non-members)"} configkey="charge_rate_emergency_non_members" charge_rate={charge_rate_emergency_non_members} type={charge_rate_emergency_non_members_type} heading={"Manage charge rate"} subheading={"Charge rate/kWh"} close={setupdateChargeRateNonEmergency} btn_value={'Update charge rate'} setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      <div class="boxT1">
        <div class="item">
          <div class="text">
            <h4>Charge rate</h4>
            <span>Manage vehicle charging rate</span>
          </div>
           <i className={hideSettings.charge_rate === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"} 
            onClick={() => handleHideSettings("charge_rate")}      
        >expand_more</i>
        </div>
        <div class="tableList mt-16" style={hideSettings.charge_rate === true ? {
            display:"none"
        } : {
            display:"block"
        }}>
          <div>
            <h5>Service fee</h5>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Global</span>
                    <span class="time">
                      {"$"}
                      {global_charge_rate}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setupdateChargeRate(true) }}

                          data-target="ChargeRateP_Global"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Emergency (for members)</span>
                    <span class="time">
                      Free upto {charge_rate_emergency_members} % charge{" "}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setupdateChargeRateEmergency(true) }}
                          data-target="ChargeRateP_Emergency"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Emergency (for non-members)</span>
                    <span class="time">
                      Free upto {charge_rate_emergency_non_members} % charge{" "}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setupdateChargeRateNonEmergency(true) }}
                          data-target="ChargeRateP_EmergencyN"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          {/* <div class="text">
              <h4>Charge rate</h4>
              <span>Manage vehicle charging rate</span>
            </div>
            <i class="material-symbols-rounded arrowBottom mt-l">expand_more</i> */}
        </div>
        <div class="tableList mt-16">
          {/* <div>
                               <h5>Service fee</h5>
                              <table class="widthAuto">
                                 <tbody>
                                    <tr>
                                       <td><span>Global</span><span class="time">$0.58 <a class="open_model" href="javascript:void(0);" data-target="ChargeRateP_Global">Manage
                                          </a></span>
                                       </td>
                                       <td><span>Emergency (for members)</span><span class="time">Free upto 20% charge <a class="open_model" href="javascript:void(0);" data-target="ChargeRateP_Emergency">Manage
                                          </a></span>
                                       </td>
                                       <td><span>Emergency (for non-members)</span><span class="time">Free upto 20% charge<a class="open_model" href="javascript:void(0);" data-target="ChargeRateP_EmergencyN">Manage
                                          </a></span>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div> */}
          {/* <div>
              <h5>Service fee</h5>
              <table class="mt-16">
                <tbody>
                  <tr>
                    <td>
                      <span>Direct customers</span>
                      <span class="time">
                        7am - 11pm{" "}
                        <a
                          class="open_model"
                          href="javascript:void(0);"
                          data-target="manageBookingTimeP_DirectCustomers"
                        >
                          Manage
                        </a>
                      </span>
                    </td>
                    <td>
                      <span>Partners</span>
                      <span class="time">
                        7am - 11pm <a href="javascript:void(0);">Manage</a>
                      </span>
                    </td>
                    <td>
                      <span>Corporate</span>
                      <span class="time">
                        11am - 7pm, 1am - 6am
                        <a
                          class="open_model"
                          href="javascript:void(0);"
                          data-target="manageBookingTimeP_Corporate"
                        >
                          Manage
                        </a>
                      </span>
                    </td>
                    <td>
                      <span>Emergency</span>
                      <span class="time">
                        24 hours<a href="javascript:void(0);">Manage</a>
                      </span>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div> */}
        </div>
      </div>

    </>

  );
};

export default ChargeRate;
