import React from "react";
import { useState } from "react";
import ParseJson from "../../../utils/ParseJson";
import UpdateChargeRate from "./UpdateChargeRate";
import UpdateServiceFee from "./UpdateServiceFee";
import UpdateParkingFee from "./UpdateParkingFee";
import { getType } from "../../../utils/ParseJson";
import useAuth from "../../../hooks/useAuth";
const Surcharge = ({ data, setisSuccess, isSuccess, hideSettings, handleHideSettings }) => {
  const gst_tax_rate = data ? ParseJson(data.global_gst.value) : "";
  //const gst_tax_type = data ? getType(data.global_gst.value) : "";
  const { auth } = useAuth();
  const gst_tax_type = "P";
  const parking_charge = data ? ParseJson(data?.global_parking_charge?.value) : "";
  const parking_charge_type = data ? getType(data?.global_parking_charge?.value) : "";
  const service_fee_emergency_members = data ? ParseJson(data?.service_fee_emergency_members?.value) : "";
  const service_fee_emergency_members_type = data ? getType(data?.service_fee_emergency_members?.value) : ""
  const service_fee_emergency_non_members = data ? ParseJson(data.service_fee_emergency_non_members.value) : "";
  const service_fee_emergency_non_members_type = data ? getType(data.service_fee_emergency_non_members.value) : ""
  const service_fee_paug_withaddons = data ? ParseJson(data.service_fee_payg_with_addon.value) : ""
  const service_fee_paug_withoutaddons = data ? ParseJson(data.service_fee_payg_without_addon.value) : ""
  const service_fee_paug_withaddons_type = data ? getType(data.service_fee_payg_with_addon.value) : ""
  const service_fee_paug_withoutaddons_type = data ? getType(data.service_fee_payg_without_addon.value) : ""
  const service_fee_members = data ? ParseJson(data.service_fee_members_global.value) : ""
  const service_fee_members_type = data ? getType(data.service_fee_members_global.value) : ""
  const [manageGst, setmanageGst] = useState(false);
  const [manageParking, setmanageParking] = useState(false);
  const [manageserviceFee, setmanageserviceFee] = useState({
    emergencyMember: false,
    nonemergencymember: false,
    paugowithaddons: false,
    paugowithoutaddons: false,
    members: false

  })
  return (
    <>
      {manageGst && <UpdateChargeRate membertype={"Global"} configkey="global_gst" charge_rate={gst_tax_rate} type={gst_tax_type} heading={"Manage GST tax"} subheading={"GST tax"} close={setmanageGst} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageParking && <UpdateParkingFee membertype="Global" configkey="global_parking_charge" charge_rate={parking_charge} type={parking_charge_type} heading={"Manage parking fee"} subheading={"Parking fee"} close={() => { setmanageParking(false) }} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageserviceFee.emergencyMember && <UpdateServiceFee membertype="Emergency(Member)" configkey={"service_fee_emergency_members"} charge_rate={service_fee_emergency_members} type={service_fee_emergency_members_type} heading={"Manage service fee"} subheading={"Service fee"} close={() => { setmanageserviceFee({ emergencyMember: false }) }} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageserviceFee.nonemergencymember && <UpdateServiceFee membertype={"Emergency(Non Member)"} configkey={"service_fee_emergency_non_members"} charge_rate={service_fee_emergency_non_members} type={service_fee_emergency_non_members_type} heading={"Manage service fee"} subheading={"Service fee"} close={(() => { setmanageserviceFee({ nonemergencymember: false }) })} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageserviceFee.paugowithaddons && <UpdateServiceFee membertype={"Pay as u go (With add-ons)"} configkey={"service_fee_payg_with_addon"} charge_rate={service_fee_paug_withaddons} type={service_fee_paug_withaddons_type} heading={"Manage service fee"} subheading={"Service fee"} close={() => { setmanageserviceFee({ paugowithaddons: false }) }} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageserviceFee.paugowithoutaddons && <UpdateServiceFee membertype={"Pay as u go (Without add-ons)"} configkey={"service_fee_payg_without_addon"} charge_rate={service_fee_paug_withoutaddons} type={service_fee_paug_withoutaddons_type} heading={"Manage service fee"} subheading={"Service fee"} close={() => { setmanageserviceFee({ paugowithoutaddons: false }) }} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      {manageserviceFee.members && <UpdateServiceFee membertype={"Global"} configkey={"service_fee_members_global"} charge_rate={service_fee_members} type={service_fee_members_type} heading={"Manage service fee"} subheading={"Service fee"} close={() => { setmanageserviceFee({ members: false }) }} btn_value="Save" setisSuccess={setisSuccess} isSuccess={isSuccess} />}
      <div class="boxT1">
        <div class="item">
          <div class="text">
            <h4>Surcharge</h4>
            <span>Manage the service fee, parking fee, GST tax</span>
          </div>
           <i className={hideSettings.surcharge === true ? "material-symbols-rounded arrowBottom mt-l" : "material-symbols-rounded arrowTop mt-l"} 
            onClick={() => handleHideSettings("surcharge")}      
        >expand_more</i>
        </div>
        <div class="tableList mt-16" style={hideSettings.surcharge === true ? {
            display:"none"
        } : {
            display:"block"
        }}>
          <div>
            <h5>Service fee</h5>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Emergency (member)</span>
                    <span class="time">
                      {data && service_fee_emergency_members > 0 && "$"}
                      {data && service_fee_emergency_members}
                      {/* $60 */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setmanageserviceFee({ emergencyMember: true }) }}
                          data-target="SurchargeServiceFee1"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Emergency (non-member)</span>
                    <span class="time">
                      {data && service_fee_emergency_non_members > 0 && "$"}
                      {data && data && service_fee_emergency_non_members}
                      {/* $120 */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          onClick={() => { setmanageserviceFee({ nonemergencymember: true }) }}
                          class="open_model"
                          data-target="SurchargeServiceFee1"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Pay as you go (with add-on)</span>
                    <span class="time">

                      {data && service_fee_paug_withaddons > 0 && "$"}
                      {data && service_fee_paug_withaddons}

                      {/* $7 */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          onClick={() => { setmanageserviceFee({ paugowithaddons: true }) }}
                          class="open_model"
                          data-target="SurchargeServiceFee1"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Pay as you go (without add-on)</span>
                    <span class="time">
                      {data && service_fee_paug_withoutaddons > 0 && "$"}

                      {data && service_fee_paug_withoutaddons}
                      {/* $10 */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          onClick={() => { setmanageserviceFee({ paugowithoutaddons: true }) }}
                          class="open_model"
                          data-target="SurchargeServiceFee1"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                  <td>
                    <span>Members</span>
                    <span class="time">
                      {data && service_fee_members > 0 && "$"}
                      {data && service_fee_members}
                      {/* Free */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          onClick={() => { setmanageserviceFee({ members: true }) }}

                          class="open_model"
                          data-target="SurchargeServiceFee1"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <div>
            <h5>Parking fee</h5>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Global</span>
                    <span class="time">
                      {data && parking_charge > 0 && "$"}
                      {data && parking_charge}
                      ({parking_charge_type})
                      {/* $2 (inclusive) */}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setmanageParking(true) }}
                          data-target="SurchargeParkingFeeGlobal"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
          <div>
            <h5>GST tax</h5>
            <table class="widthAuto">
              <tbody>
                <tr>
                  <td>
                    <span>Global</span>
                    <span class="time">
                      {data && gst_tax_rate}
                      {data && gst_tax_rate >= 0 && " %"}
                      {auth.priviliges.includes("write_settings") &&
                        <a
                          class="open_model"
                          onClick={() => { setmanageGst(true) }}
                          data-target="SurchargeGSTGlobal"
                        >
                          Manage
                        </a>}
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </>

  );
};

export default Surcharge;
